/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.entity;

import com.eucalyptus.cloudformation.AlreadyExistsException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StackEntityManager {
    static final Logger LOG = Logger.getLogger(StackEntityManager.class);

    public static StackEntity addStack(StackEntity stackEntity) throws AlreadyExistsException {
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)Restrictions.eq((String)"stackName", (Object)stackEntity.getStackName())).add((Criterion)Restrictions.eq((String)"accountId", (Object)stackEntity.getAccountId())).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List EntityList = criteria.list();
            if (!EntityList.isEmpty()) {
                throw new AlreadyExistsException("Stack already exists");
            }
            if (stackEntity.getCreateOperationTimestamp() == null) {
                stackEntity.setCreateOperationTimestamp(new Date());
            }
            Entities.persist((Object)((Object)stackEntity));
            db.commit();
        }
        return stackEntity;
    }

    public static List<StackEntity> describeStacks(String accountId, String stackNameOrId) {
        List returnValue;
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)(accountId != null ? Restrictions.eq((String)"accountId", (Object)accountId) : Restrictions.conjunction()));
            if (stackNameOrId != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)"stackName", (Object)stackNameOrId)), (Criterion)Restrictions.eq((String)"stackId", (Object)stackNameOrId)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            }
            returnValue = criteria.list();
            db.commit();
        }
        return returnValue;
    }

    public static List<StackEntity> listStacks(String accountId, List<StackEntity.Status> statusValues) {
        List returnValue;
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
            if (statusValues != null && !statusValues.isEmpty()) {
                Criterion[] orClauses = new Criterion[statusValues.size()];
                int ctr = 0;
                for (StackEntity.Status statusValue : statusValues) {
                    orClauses[ctr++] = Restrictions.eq((String)"stackStatus", (Object)((Object)statusValue));
                }
                criteria.add((Criterion)Restrictions.or((Criterion[])orClauses));
            }
            returnValue = criteria.list();
            db.commit();
        }
        return returnValue;
    }

    public static StackEntity getNonDeletedStackById(String stackId, String accountId) {
        StackEntity stackEntity = null;
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List entityList = criteria.list();
            if (entityList != null && !entityList.isEmpty()) {
                stackEntity = (StackEntity)((Object)entityList.get(0));
            }
            db.commit();
        }
        return stackEntity;
    }

    public static StackEntity getNonDeletedStackByNameOrId(String stackNameOrId, String accountId) {
        StackEntity stackEntity = null;
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)(accountId != null ? Restrictions.eq((String)"accountId", (Object)accountId) : Restrictions.conjunction())).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"stackName", (Object)stackNameOrId), (Criterion)Restrictions.eq((String)"stackId", (Object)stackNameOrId))).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List entityList = criteria.list();
            if (entityList != null && !entityList.isEmpty()) {
                stackEntity = (StackEntity)((Object)entityList.get(0));
            }
            db.commit();
        }
        return stackEntity;
    }

    public static StackEntity getAnyStackByNameOrId(String stackNameOrId, String accountId) {
        StackEntity stackEntity = null;
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)(accountId != null ? Restrictions.eq((String)"accountId", (Object)accountId) : Restrictions.conjunction())).add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)"stackName", (Object)stackNameOrId)), (Criterion)Restrictions.eq((String)"stackId", (Object)stackNameOrId)));
            List entityList = criteria.list();
            if (entityList != null && !entityList.isEmpty()) {
                stackEntity = (StackEntity)((Object)entityList.get(0));
            }
            db.commit();
        }
        return stackEntity;
    }

    public static void deleteStack(String stackId, String accountId) {
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId)).add((Criterion)Restrictions.eq((String)"stackId", (Object)stackId)).add((Criterion)Restrictions.eq((String)"recordDeleted", (Object)Boolean.FALSE));
            List entityList = criteria.list();
            for (StackEntity stackEntity : entityList) {
                stackEntity.setRecordDeleted(Boolean.TRUE);
            }
            db.commit();
        }
    }

    public static void updateStack(StackEntity stackEntity) {
        try (TransactionResource db = Entities.transactionFor(StackEntity.class);){
            Criteria criteria = Entities.createCriteria(StackEntity.class).add((Criterion)Restrictions.eq((String)"naturalId", (Object)stackEntity.getNaturalId()));
            StackEntity dbEntity = (StackEntity)((Object)criteria.uniqueResult());
            if (dbEntity == null) {
                Entities.persist((Object)((Object)stackEntity));
            } else {
                dbEntity.setCreateOperationTimestamp(stackEntity.getCreateOperationTimestamp());
                dbEntity.setLastUpdateOperationTimestamp(stackEntity.getLastUpdateOperationTimestamp());
                dbEntity.setDeleteOperationTimestamp(stackEntity.getDeleteOperationTimestamp());
                dbEntity.setAccountId(stackEntity.getAccountId());
                dbEntity.setAvailabilityZoneMapJson(stackEntity.getAvailabilityZoneMapJson());
                dbEntity.setResourceDependencyManagerJson(stackEntity.getResourceDependencyManagerJson());
                dbEntity.setCapabilitiesJson(stackEntity.getCapabilitiesJson());
                dbEntity.setDescription(stackEntity.getDescription());
                dbEntity.setDisableRollback(stackEntity.getDisableRollback());
                dbEntity.setPseudoParameterMapJson(stackEntity.getPseudoParameterMapJson());
                dbEntity.setConditionMapJson(stackEntity.getConditionMapJson());
                dbEntity.setTemplateBody(stackEntity.getTemplateBody());
                dbEntity.setMappingJson(stackEntity.getMappingJson());
                dbEntity.setNotificationARNsJson(stackEntity.getNotificationARNsJson());
                dbEntity.setOutputsJson(stackEntity.getOutputsJson());
                dbEntity.setParametersJson(stackEntity.getParametersJson());
                dbEntity.setStackId(stackEntity.getStackId());
                dbEntity.setStackName(stackEntity.getStackName());
                dbEntity.setStackStatus(stackEntity.getStackStatus());
                dbEntity.setStackStatusReason(stackEntity.getStackStatusReason());
                dbEntity.setTagsJson(stackEntity.getTagsJson());
                dbEntity.setTemplateFormatVersion(stackEntity.getTemplateFormatVersion());
                dbEntity.setTimeoutInMinutes(stackEntity.getTimeoutInMinutes());
                dbEntity.setRecordDeleted(stackEntity.getRecordDeleted());
                dbEntity.setStackPolicy(stackEntity.getStackPolicy());
            }
            db.commit();
        }
    }
}

