/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.entity;

import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.Tag;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.template.Template;
import com.eucalyptus.cloudformation.template.dependencies.DependencyManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StackEntityHelper {
    private static ObjectMapper mapper = new ObjectMapper();

    public static Map<String, List<String>> jsonToAvailabilityZoneMap(String availabilityZoneMapJson) throws CloudFormationException {
        try {
            return availabilityZoneMapJson == null ? Maps.newLinkedHashMap() : (Map)mapper.readValue(availabilityZoneMapJson, (TypeReference)new TypeReference<LinkedHashMap<String, List<String>>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String availabilityZoneMapToJson(Map<String, List<String>> availabilityZoneMap) throws CloudFormationException {
        try {
            return mapper.writeValueAsString((Object)(availabilityZoneMap == null ? Maps.newLinkedHashMap() : availabilityZoneMap));
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static ArrayList<String> jsonToCapabilities(String capabilitiesJson) throws CloudFormationException {
        try {
            return capabilitiesJson == null ? Lists.newArrayList() : (ArrayList)mapper.readValue(capabilitiesJson, (TypeReference)new TypeReference<ArrayList<String>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String capabilitiesToJson(ArrayList<String> capabilities) throws CloudFormationException {
        try {
            return mapper.writeValueAsString(capabilities == null ? Lists.newArrayList() : capabilities);
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static ArrayList<String> jsonToNotificationARNs(String notificationARNsJson) throws CloudFormationException {
        try {
            return notificationARNsJson == null ? Lists.newArrayList() : (ArrayList)mapper.readValue(notificationARNsJson, (TypeReference)new TypeReference<ArrayList<String>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String notificationARNsToJson(ArrayList<String> notificationARNs) throws CloudFormationException {
        try {
            return mapper.writeValueAsString(notificationARNs == null ? Lists.newArrayList() : notificationARNs);
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static ArrayList<StackEntity.Output> jsonToOutputs(String outputsJson) throws CloudFormationException {
        try {
            return outputsJson == null ? Lists.newArrayList() : (ArrayList)mapper.readValue(outputsJson, (TypeReference)new TypeReference<ArrayList<StackEntity.Output>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String outputsToJson(ArrayList<StackEntity.Output> outputs) throws CloudFormationException {
        try {
            return mapper.writeValueAsString(outputs == null ? Lists.newArrayList() : outputs);
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static ArrayList<StackEntity.Parameter> jsonToParameters(String parametersJson) throws CloudFormationException {
        try {
            return parametersJson == null ? Lists.newArrayList() : (ArrayList)mapper.readValue(parametersJson, (TypeReference)new TypeReference<ArrayList<StackEntity.Parameter>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static Map<String, StackEntity.Parameter> jsonToParameterMap(String parametersJson) throws CloudFormationException {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (StackEntity.Parameter parameter : StackEntityHelper.jsonToParameters(parametersJson)) {
            map.put(parameter.getKey(), parameter);
        }
        return map;
    }

    public static String parametersToJson(ArrayList<StackEntity.Parameter> parameters) throws CloudFormationException {
        try {
            return mapper.writeValueAsString(parameters == null ? Lists.newArrayList() : parameters);
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static ArrayList<Tag> jsonToTags(String tagsJson) throws CloudFormationException {
        try {
            return tagsJson == null ? Lists.newArrayList() : (ArrayList)mapper.readValue(tagsJson, (TypeReference)new TypeReference<ArrayList<Tag>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String tagsToJson(ArrayList<Tag> tags) throws CloudFormationException {
        try {
            return mapper.writeValueAsString(tags == null ? Lists.newArrayList() : tags);
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static Map<String, String> jsonToPseudoParameterMap(String pseudoParameterMapJson) throws CloudFormationException {
        try {
            return pseudoParameterMapJson == null ? Maps.newLinkedHashMap() : (Map)mapper.readValue(pseudoParameterMapJson, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String pseudoParameterMapToJson(Map<String, String> pseudoParameterMap) throws CloudFormationException {
        try {
            return mapper.writeValueAsString((Object)(pseudoParameterMap == null ? Maps.newLinkedHashMap() : pseudoParameterMap));
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static Map<String, Boolean> jsonToConditionMap(String conditionMapJson) throws CloudFormationException {
        try {
            return conditionMapJson == null ? Maps.newLinkedHashMap() : (Map)mapper.readValue(conditionMapJson, (TypeReference)new TypeReference<LinkedHashMap<String, Boolean>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String conditionMapToJson(Map<String, Boolean> conditionMap) throws CloudFormationException {
        try {
            return mapper.writeValueAsString((Object)(conditionMap == null ? Maps.newLinkedHashMap() : conditionMap));
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static Map<String, Map<String, Map<String, String>>> jsonToMapping(String mappingJson) throws CloudFormationException {
        try {
            return mappingJson == null ? Maps.newLinkedHashMap() : (Map)mapper.readValue(mappingJson, (TypeReference)new TypeReference<LinkedHashMap<String, Map<String, Map<String, String>>>>(){});
        }
        catch (IOException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static String mappingToJson(Map<String, Map<String, Map<String, String>>> mapping) throws CloudFormationException {
        try {
            return mapper.writeValueAsString((Object)(mapping == null ? Maps.newLinkedHashMap() : mapping));
        }
        catch (JsonProcessingException e) {
            throw new ValidationErrorException(e.getMessage());
        }
    }

    public static DependencyManager jsonToResourceDependencyManager(String resourceDependencyManagerJson) throws CloudFormationException {
        return DependencyManager.fromJson(resourceDependencyManagerJson);
    }

    public static String resourceDependencyManagerToJson(DependencyManager resourceDependencyManager) throws CloudFormationException {
        return resourceDependencyManager.toJson();
    }

    public static void populateTemplateWithStackEntity(Template template, StackEntity stackEntity) throws CloudFormationException {
        template.setDescription(stackEntity.getDescription());
        template.setPseudoParameterMap(StackEntityHelper.jsonToPseudoParameterMap(stackEntity.getPseudoParameterMapJson()));
        template.setAvailabilityZoneMap(StackEntityHelper.jsonToAvailabilityZoneMap(stackEntity.getAvailabilityZoneMapJson()));
        template.setTemplateFormatVersion(stackEntity.getTemplateFormatVersion());
        template.setMapping(StackEntityHelper.jsonToMapping(stackEntity.getMappingJson()));
        template.setParameters(StackEntityHelper.jsonToParameters(stackEntity.getParametersJson()));
        template.setConditionMap(StackEntityHelper.jsonToConditionMap(stackEntity.getConditionMapJson()));
        template.setResourceDependencyManager(StackEntityHelper.jsonToResourceDependencyManager(stackEntity.getResourceDependencyManagerJson()));
        template.setOutputs(StackEntityHelper.jsonToOutputs(stackEntity.getOutputsJson()));
    }

    public static void populateStackEntityWithTemplate(StackEntity stackEntity, Template template) throws CloudFormationException {
        stackEntity.setDescription(template.getDescription());
        stackEntity.setPseudoParameterMapJson(StackEntityHelper.pseudoParameterMapToJson(template.getPseudoParameterMap()));
        stackEntity.setAvailabilityZoneMapJson(StackEntityHelper.availabilityZoneMapToJson(template.getAvailabilityZoneMap()));
        stackEntity.setTemplateFormatVersion(template.getTemplateFormatVersion());
        stackEntity.setMappingJson(StackEntityHelper.mappingToJson(template.getMapping()));
        stackEntity.setParametersJson(StackEntityHelper.parametersToJson(template.getParameters()));
        stackEntity.setConditionMapJson(StackEntityHelper.conditionMapToJson(template.getConditionMap()));
        stackEntity.setResourceDependencyManagerJson(StackEntityHelper.resourceDependencyManagerToJson(template.getResourceDependencyManager()));
        stackEntity.setOutputsJson(StackEntityHelper.outputsToJson(template.getOutputs()));
    }
}

