/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation.config;

import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.cloudformation.CloudFormation;
import com.eucalyptus.cloudformation.config.CloudFormationConfiguration;
import com.eucalyptus.cloudformation.config.DeregisterCloudFormationType;
import com.eucalyptus.cloudformation.config.DescribeCloudFormationType;
import com.eucalyptus.cloudformation.config.ModifyCloudFormationAttributeType;
import com.eucalyptus.cloudformation.config.RegisterCloudFormationType;
import com.eucalyptus.cloudformation.workflow.WorkflowClientManager;
import com.eucalyptus.component.AbstractServiceBuilder;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.annotation.ComponentPart;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;

@ComponentPart(value=CloudFormation.class)
@Handles(value={DeregisterCloudFormationType.class, DescribeCloudFormationType.class, ModifyCloudFormationAttributeType.class, RegisterCloudFormationType.class})
public class CloudFormationServiceBuilder
extends AbstractServiceBuilder<CloudFormationConfiguration> {
    private static final Logger logger = Logger.getLogger(CloudFormationServiceBuilder.class);

    public CloudFormationConfiguration newInstance() {
        return new CloudFormationConfiguration();
    }

    public CloudFormationConfiguration newInstance(String partition, String name, String host, Integer port) {
        return new CloudFormationConfiguration(partition, name, host, port);
    }

    public ComponentId getComponentId() {
        return ComponentIds.lookup(CloudFormation.class);
    }

    public void fireStart(ServiceConfiguration config) {
    }

    public void fireStop(ServiceConfiguration config) {
    }

    public void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
        if (this.noOtherEnabled(config)) {
            try {
                WorkflowClientManager.start();
            }
            catch (Exception e) {
                throw new ServiceRegistrationException("Error creating workflow client", (Throwable)e);
            }
        }
    }

    public void fireDisable(ServiceConfiguration config) {
        if (this.noOtherEnabled(config)) {
            try {
                WorkflowClientManager.stop();
            }
            catch (Exception e) {
                logger.error((Object)"Error stopping workflow client", (Throwable)e);
            }
        }
    }

    public void fireCheck(ServiceConfiguration config) {
    }

    private boolean noOtherEnabled(ServiceConfiguration config) {
        return Iterables.isEmpty((Iterable)ServiceConfigurations.filter(CloudFormation.class, (Predicate)Predicates.and((Predicate[])new Predicate[]{ServiceConfigurations.filterHostLocal(), ServiceConfigurations.filterEnabled(), Predicates.not((Predicate)Predicates.equalTo((Object)config))})));
    }
}

