/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloudformation;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.cloudformation.AccessDeniedException;
import com.eucalyptus.cloudformation.CancelUpdateStackResponseType;
import com.eucalyptus.cloudformation.CancelUpdateStackType;
import com.eucalyptus.cloudformation.CloudFormationException;
import com.eucalyptus.cloudformation.CreateStackResponseType;
import com.eucalyptus.cloudformation.CreateStackResult;
import com.eucalyptus.cloudformation.CreateStackType;
import com.eucalyptus.cloudformation.DeleteStackResponseType;
import com.eucalyptus.cloudformation.DeleteStackType;
import com.eucalyptus.cloudformation.DescribeStackEventsResponseType;
import com.eucalyptus.cloudformation.DescribeStackEventsResult;
import com.eucalyptus.cloudformation.DescribeStackEventsType;
import com.eucalyptus.cloudformation.DescribeStackResourceResponseType;
import com.eucalyptus.cloudformation.DescribeStackResourceResult;
import com.eucalyptus.cloudformation.DescribeStackResourceType;
import com.eucalyptus.cloudformation.DescribeStackResourcesResponseType;
import com.eucalyptus.cloudformation.DescribeStackResourcesResult;
import com.eucalyptus.cloudformation.DescribeStackResourcesType;
import com.eucalyptus.cloudformation.DescribeStacksResponseType;
import com.eucalyptus.cloudformation.DescribeStacksResult;
import com.eucalyptus.cloudformation.DescribeStacksType;
import com.eucalyptus.cloudformation.EstimateTemplateCostResponseType;
import com.eucalyptus.cloudformation.EstimateTemplateCostType;
import com.eucalyptus.cloudformation.GetStackPolicyResponseType;
import com.eucalyptus.cloudformation.GetStackPolicyResult;
import com.eucalyptus.cloudformation.GetStackPolicyType;
import com.eucalyptus.cloudformation.GetTemplateResponseType;
import com.eucalyptus.cloudformation.GetTemplateResult;
import com.eucalyptus.cloudformation.GetTemplateType;
import com.eucalyptus.cloudformation.InternalFailureException;
import com.eucalyptus.cloudformation.Limits;
import com.eucalyptus.cloudformation.ListStackResourcesResponseType;
import com.eucalyptus.cloudformation.ListStackResourcesResult;
import com.eucalyptus.cloudformation.ListStackResourcesType;
import com.eucalyptus.cloudformation.ListStacksResponseType;
import com.eucalyptus.cloudformation.ListStacksResult;
import com.eucalyptus.cloudformation.ListStacksType;
import com.eucalyptus.cloudformation.Output;
import com.eucalyptus.cloudformation.Outputs;
import com.eucalyptus.cloudformation.Parameter;
import com.eucalyptus.cloudformation.Parameters;
import com.eucalyptus.cloudformation.ResourceList;
import com.eucalyptus.cloudformation.SetStackPolicyResponseType;
import com.eucalyptus.cloudformation.SetStackPolicyType;
import com.eucalyptus.cloudformation.Stack;
import com.eucalyptus.cloudformation.StackEvent;
import com.eucalyptus.cloudformation.StackEvents;
import com.eucalyptus.cloudformation.StackResource;
import com.eucalyptus.cloudformation.StackResourceDetail;
import com.eucalyptus.cloudformation.StackResourceSummaries;
import com.eucalyptus.cloudformation.StackResourceSummary;
import com.eucalyptus.cloudformation.StackResources;
import com.eucalyptus.cloudformation.StackSummaries;
import com.eucalyptus.cloudformation.StackSummary;
import com.eucalyptus.cloudformation.Stacks;
import com.eucalyptus.cloudformation.Tag;
import com.eucalyptus.cloudformation.Tags;
import com.eucalyptus.cloudformation.UpdateStackResponseType;
import com.eucalyptus.cloudformation.UpdateStackType;
import com.eucalyptus.cloudformation.ValidateTemplateResponseType;
import com.eucalyptus.cloudformation.ValidateTemplateResult;
import com.eucalyptus.cloudformation.ValidateTemplateType;
import com.eucalyptus.cloudformation.ValidationErrorException;
import com.eucalyptus.cloudformation.config.CloudFormationProperties;
import com.eucalyptus.cloudformation.entity.StackEntity;
import com.eucalyptus.cloudformation.entity.StackEntityHelper;
import com.eucalyptus.cloudformation.entity.StackEntityManager;
import com.eucalyptus.cloudformation.entity.StackEventEntityManager;
import com.eucalyptus.cloudformation.entity.StackResourceEntity;
import com.eucalyptus.cloudformation.entity.StackResourceEntityManager;
import com.eucalyptus.cloudformation.entity.StackWorkflowEntity;
import com.eucalyptus.cloudformation.entity.StackWorkflowEntityManager;
import com.eucalyptus.cloudformation.resources.ResourceInfo;
import com.eucalyptus.cloudformation.template.PseudoParameterValues;
import com.eucalyptus.cloudformation.template.Template;
import com.eucalyptus.cloudformation.template.TemplateParser;
import com.eucalyptus.cloudformation.workflow.CreateStackWorkflow;
import com.eucalyptus.cloudformation.workflow.CreateStackWorkflowClient;
import com.eucalyptus.cloudformation.workflow.CreateStackWorkflowDescriptionTemplate;
import com.eucalyptus.cloudformation.workflow.DeleteStackWorkflow;
import com.eucalyptus.cloudformation.workflow.DeleteStackWorkflowClient;
import com.eucalyptus.cloudformation.workflow.DeleteStackWorkflowDescriptionTemplate;
import com.eucalyptus.cloudformation.workflow.MonitorCreateStackWorkflow;
import com.eucalyptus.cloudformation.workflow.MonitorCreateStackWorkflowClient;
import com.eucalyptus.cloudformation.workflow.MonitorCreateStackWorkflowDescriptionTemplate;
import com.eucalyptus.cloudformation.workflow.StartTimeoutPassableWorkflowClientFactory;
import com.eucalyptus.cloudformation.workflow.WorkflowClientManager;
import com.eucalyptus.cloudformation.ws.StackWorkflowTags;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesType;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.glisten.InterfaceBasedWorkflowClient;
import com.netflix.glisten.WorkflowClientFactory;
import com.netflix.glisten.WorkflowDescriptionTemplate;
import com.netflix.glisten.WorkflowTags;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

@ConfigurableClass(root="cloudformation", description="Parameters controlling cloud formation")
public class CloudFormationService {
    @ConfigurableField(initial="", description="The value of AWS::Region and value in CloudFormation ARNs for Region")
    public static volatile String REGION = "";
    @ConfigurableField(initial="*.s3.amazonaws.com", description="A comma separated white list of domains (other than Eucalyptus S3 URLs) allowed by CloudFormation URL parameters")
    public static volatile String URL_DOMAIN_WHITELIST = "*s3.amazonaws.com";
    private static final String NO_ECHO_PARAMETER_VALUE = "****";
    private static final String STACK_ID_PREFIX = "arn:aws:cloudformation:";
    private static final Logger LOG = Logger.getLogger(CloudFormationService.class);

    public CancelUpdateStackResponseType cancelUpdateStack(CancelUpdateStackType request) throws CloudFormationException {
        return (CancelUpdateStackResponseType)request.getReply();
    }

    public CreateStackResponseType createStack(final CreateStackType request) throws CloudFormationException {
        CreateStackResponseType reply = (CreateStackResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            final String userId = user.getUserId();
            final String accountId = user.getAccount().getAccountNumber();
            final String accountName = user.getAccount().getName();
            final String stackName = request.getStackName();
            String templateBody = request.getTemplateBody();
            String templateUrl = request.getTemplateURL();
            if (stackName == null) {
                throw new ValidationErrorException("Stack name is null");
            }
            if (!stackName.matches("^[\\p{Alpha}][\\p{Alnum}-]*$")) {
                throw new ValidationErrorException("Stack name " + stackName + " must contain only letters, numbers, dashes and start with an alpha character.");
            }
            if ((long)stackName.length() > 255L) {
                throw new ValidationErrorException("Stack name " + stackName + " must be no longer than " + 255L + " characters.");
            }
            if (templateBody == null && templateUrl == null) {
                throw new ValidationErrorException("Either TemplateBody or TemplateURL must be set.");
            }
            if (templateBody != null && templateUrl != null) {
                throw new ValidationErrorException("Exactly one of TemplateBody or TemplateURL must be set.");
            }
            ArrayList parameters = null;
            if (request.getParameters() != null && request.getParameters().getMember() != null) {
                parameters = request.getParameters().getMember();
            }
            final String stackIdLocal = UUID.randomUUID().toString();
            final String stackId = STACK_ID_PREFIX + REGION + ":" + accountId + ":stack/" + stackName + "/" + stackIdLocal;
            PseudoParameterValues pseudoParameterValues = new PseudoParameterValues();
            pseudoParameterValues.setAccountId(accountId);
            pseudoParameterValues.setStackName(stackName);
            pseudoParameterValues.setStackId(stackId);
            if (request.getNotificationARNs() != null && request.getNotificationARNs().getMember() != null) {
                ArrayList notificationArns = Lists.newArrayList();
                for (String notificationArn : request.getNotificationARNs().getMember()) {
                    notificationArns.add(notificationArn);
                }
                pseudoParameterValues.setNotificationArns(notificationArns);
            }
            pseudoParameterValues.setRegion(REGION);
            List<String> defaultRegionAvailabilityZones = CloudFormationService.describeAvailabilityZones(userId);
            HashMap availabilityZones = Maps.newHashMap();
            availabilityZones.put(REGION, defaultRegionAvailabilityZones);
            availabilityZones.put("", defaultRegionAvailabilityZones);
            pseudoParameterValues.setAvailabilityZones(availabilityZones);
            final ArrayList capabilities = Lists.newArrayList();
            if (request.getCapabilities() != null && request.getCapabilities().getMember() != null) {
                capabilities.addAll(request.getCapabilities().getMember());
            }
            if (templateBody != null && (long)templateBody.getBytes().length > Limits.REQUEST_TEMPLATE_BODY_MAX_LENGTH_BYTES) {
                throw new ValidationErrorException("Template body may not exceed " + Limits.REQUEST_TEMPLATE_BODY_MAX_LENGTH_BYTES + " bytes in a request.");
            }
            if (request.getTags() != null && request.getTags().getMember() != null) {
                for (Tag tag : request.getTags().getMember()) {
                    if (Strings.isNullOrEmpty((String)tag.getKey()) || Strings.isNullOrEmpty((String)tag.getValue())) {
                        throw new ValidationErrorException("Tags can not be null or empty");
                    }
                    if (tag.getKey().startsWith("aws:")) {
                        throw new ValidationErrorException("Invalid tag key.  \"aws:\" is a reserved prefix.");
                    }
                    if (!tag.getKey().startsWith("euca:")) continue;
                    throw new ValidationErrorException("Invalid tag key.  \"euca:\" is a reserved prefix.");
                }
            }
            final String templateText = templateBody != null ? templateBody : CloudFormationService.extractTemplateTextFromURL(templateUrl, user);
            final Template template = new TemplateParser().parse(templateText, parameters, capabilities, pseudoParameterValues);
            Supplier<StackEntity> allocator = new Supplier<StackEntity>(){

                public StackEntity get() {
                    try {
                        String onFailure;
                        StackEntity stackEntity = new StackEntity();
                        StackEntityHelper.populateStackEntityWithTemplate(stackEntity, template);
                        stackEntity.setStackName(stackName);
                        stackEntity.setStackId(stackId);
                        stackEntity.setNaturalId(stackIdLocal);
                        stackEntity.setAccountId(accountId);
                        stackEntity.setTemplateBody(templateText);
                        stackEntity.setStackStatus(StackEntity.Status.CREATE_IN_PROGRESS);
                        stackEntity.setStackStatusReason("User initiated");
                        stackEntity.setDisableRollback(request.getDisableRollback() == Boolean.TRUE);
                        stackEntity.setCreationTimestamp(new Date());
                        if (request.getCapabilities() != null && request.getCapabilities().getMember() != null) {
                            stackEntity.setCapabilitiesJson(StackEntityHelper.capabilitiesToJson(capabilities));
                        }
                        if (request.getNotificationARNs() != null && request.getNotificationARNs().getMember() != null) {
                            stackEntity.setNotificationARNsJson(StackEntityHelper.notificationARNsToJson(request.getNotificationARNs().getMember()));
                        }
                        if (request.getTags() != null && request.getTags().getMember() != null) {
                            stackEntity.setTagsJson(StackEntityHelper.tagsToJson(request.getTags().getMember()));
                        }
                        stackEntity.setRecordDeleted(Boolean.FALSE);
                        stackEntity = StackEntityManager.addStack(stackEntity);
                        if (request.getOnFailure() != null && !request.getOnFailure().isEmpty()) {
                            if (!(request.getOnFailure().equals("ROLLBACK") || request.getOnFailure().equals("DELETE") || request.getOnFailure().equals("DO_NOTHING"))) {
                                throw new ValidationErrorException("Value '" + request.getOnFailure() + "' at 'onFailure' failed to satisfy " + "constraint: Member must satisfy enum value set: [ROLLBACK, DELETE, DO_NOTHING]");
                            }
                            onFailure = request.getOnFailure();
                        } else {
                            onFailure = request.getDisableRollback() == Boolean.TRUE ? "DO_NOTHING" : "ROLLBACK";
                        }
                        for (ResourceInfo resourceInfo : template.getResourceInfoMap().values()) {
                            StackResourceEntity stackResourceEntity = new StackResourceEntity();
                            stackResourceEntity = StackResourceEntityManager.updateResourceInfo(stackResourceEntity, resourceInfo);
                            stackResourceEntity.setDescription("");
                            stackResourceEntity.setResourceStatus(StackResourceEntity.Status.NOT_STARTED);
                            stackResourceEntity.setStackId(stackId);
                            stackResourceEntity.setStackName(stackName);
                            stackResourceEntity.setRecordDeleted(Boolean.FALSE);
                            StackResourceEntityManager.addStackResource(stackResourceEntity);
                        }
                        StackWorkflowTags stackWorkflowTags = new StackWorkflowTags(stackId, stackName, accountId, accountName);
                        Long timeoutInSeconds = request.getTimeoutInMinutes() != null && request.getTimeoutInMinutes() > 0 ? Long.valueOf(60L * (long)request.getTimeoutInMinutes().intValue()) : null;
                        StartTimeoutPassableWorkflowClientFactory createStackWorkflowClientFactory = new StartTimeoutPassableWorkflowClientFactory(WorkflowClientManager.getSimpleWorkflowClient(), CloudFormationProperties.SWF_DOMAIN, CloudFormationProperties.SWF_TASKLIST);
                        CreateStackWorkflowDescriptionTemplate createStackWorkflowDescriptionTemplate = new CreateStackWorkflowDescriptionTemplate();
                        InterfaceBasedWorkflowClient<CreateStackWorkflow> createStackWorkflowClient = createStackWorkflowClientFactory.getNewWorkflowClient(CreateStackWorkflow.class, createStackWorkflowDescriptionTemplate, stackWorkflowTags, timeoutInSeconds, null);
                        CreateStackWorkflowClient createStackWorkflow = new CreateStackWorkflowClient(createStackWorkflowClient);
                        createStackWorkflow.createStack(stackEntity.getStackId(), stackEntity.getAccountId(), stackEntity.getResourceDependencyManagerJson(), userId, onFailure);
                        StackWorkflowEntityManager.addOrUpdateStackWorkflowEntity(stackId, StackWorkflowEntity.WorkflowType.CREATE_STACK_WORKFLOW, CloudFormationProperties.SWF_DOMAIN, createStackWorkflowClient.getWorkflowExecution().getWorkflowId(), createStackWorkflowClient.getWorkflowExecution().getRunId());
                        WorkflowClientFactory monitorCreateStackWorkflowClientFactory = new WorkflowClientFactory(WorkflowClientManager.getSimpleWorkflowClient(), CloudFormationProperties.SWF_DOMAIN, CloudFormationProperties.SWF_TASKLIST);
                        MonitorCreateStackWorkflowDescriptionTemplate monitorCreateStackWorkflowDescriptionTemplate = new MonitorCreateStackWorkflowDescriptionTemplate();
                        InterfaceBasedWorkflowClient monitorCreateStackWorkflowClient = monitorCreateStackWorkflowClientFactory.getNewWorkflowClient(MonitorCreateStackWorkflow.class, (WorkflowDescriptionTemplate)monitorCreateStackWorkflowDescriptionTemplate, (WorkflowTags)stackWorkflowTags);
                        MonitorCreateStackWorkflowClient monitorCreateStackWorkflow = new MonitorCreateStackWorkflowClient((InterfaceBasedWorkflowClient<MonitorCreateStackWorkflow>)monitorCreateStackWorkflowClient);
                        monitorCreateStackWorkflow.monitorCreateStack(stackEntity.getStackId(), stackEntity.getAccountId(), stackEntity.getResourceDependencyManagerJson(), userId, onFailure);
                        StackWorkflowEntityManager.addOrUpdateStackWorkflowEntity(stackId, StackWorkflowEntity.WorkflowType.MONITOR_CREATE_STACK_WORKFLOW, CloudFormationProperties.SWF_DOMAIN, monitorCreateStackWorkflowClient.getWorkflowExecution().getWorkflowId(), monitorCreateStackWorkflowClient.getWorkflowExecution().getRunId());
                        return stackEntity;
                    }
                    catch (CloudFormationException e) {
                        throw Exceptions.toUndeclared((Throwable)((Object)e));
                    }
                }
            };
            StackEntity stackEntity = (StackEntity)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
            CreateStackResult createStackResult = new CreateStackResult();
            createStackResult.setStackId(stackId);
            reply.setCreateStackResult(createStackResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    /*
     * Exception decompiling
     */
    private static String extractTemplateTextFromURL(String templateUrl, User user) throws ValidationErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> describeAvailabilityZones(String userId) throws Exception {
        ServiceConfiguration configuration = Topology.lookup(Eucalyptus.class, (Partition[])new Partition[0]);
        DescribeAvailabilityZonesType describeAvailabilityZonesType = new DescribeAvailabilityZonesType();
        describeAvailabilityZonesType.setEffectiveUserId(userId);
        DescribeAvailabilityZonesResponseType describeAvailabilityZonesResponseType = (DescribeAvailabilityZonesResponseType)AsyncRequests.sendSync((ServiceConfiguration)configuration, (BaseMessage)describeAvailabilityZonesType);
        ArrayList availabilityZones = Lists.newArrayList();
        for (ClusterInfoType clusterInfoType : describeAvailabilityZonesResponseType.getAvailabilityZoneInfo()) {
            availabilityZones.add(clusterInfoType.getZoneName());
        }
        return availabilityZones;
    }

    public DeleteStackResponseType deleteStack(DeleteStackType request) throws CloudFormationException {
        DeleteStackResponseType reply;
        block11: {
            reply = (DeleteStackResponseType)request.getReply();
            try {
                Context ctx = Contexts.lookup();
                User user = ctx.getUser();
                String userId = user.getUserId();
                String accountId = user.getAccount().getAccountNumber();
                String stackName = request.getStackName();
                if (stackName == null) {
                    throw new ValidationErrorException("Stack name is null");
                }
                StackEntity stackEntity = StackEntityManager.getNonDeletedStackByNameOrId(stackName, accountId);
                if (stackEntity == null && ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX)) {
                    stackEntity = StackEntityManager.getNonDeletedStackByNameOrId(stackName, null);
                }
                if (stackEntity == null) break block11;
                if (!RestrictedTypes.filterPrivileged().apply((Object)stackEntity)) {
                    throw new AccessDeniedException("Not authorized.");
                }
                String stackAccountId = stackEntity.getAccountId();
                boolean existingOpenDeleteWorkflow = false;
                List<StackWorkflowEntity> deleteWorkflows = StackWorkflowEntityManager.getStackWorkflowEntities(stackEntity.getStackId(), StackWorkflowEntity.WorkflowType.DELETE_STACK_WORKFLOW);
                if (deleteWorkflows != null && !deleteWorkflows.isEmpty()) {
                    if (deleteWorkflows.size() > 1) {
                        throw new ValidationErrorException("More than one delete workflow exists for " + stackEntity.getStackId());
                    }
                    try {
                        AmazonSimpleWorkflow simpleWorkflowClient = WorkflowClientManager.getSimpleWorkflowClient();
                        StackWorkflowEntity deleteStackWorkflowEntity = deleteWorkflows.get(0);
                        DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest = new DescribeWorkflowExecutionRequest();
                        describeWorkflowExecutionRequest.setDomain(deleteStackWorkflowEntity.getDomain());
                        WorkflowExecution execution = new WorkflowExecution();
                        execution.setRunId(deleteStackWorkflowEntity.getRunId());
                        execution.setWorkflowId(deleteStackWorkflowEntity.getWorkflowId());
                        describeWorkflowExecutionRequest.setExecution(execution);
                        WorkflowExecutionDetail workflowExecutionDetail = simpleWorkflowClient.describeWorkflowExecution(describeWorkflowExecutionRequest);
                        if ("OPEN".equals(workflowExecutionDetail.getExecutionInfo().getExecutionStatus())) {
                            existingOpenDeleteWorkflow = true;
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Unable to get status of delete workflow for " + stackEntity.getStackId() + ", assuming not open"));
                        LOG.debug((Object)ex);
                    }
                }
                if (!existingOpenDeleteWorkflow) {
                    String stackId = stackEntity.getStackId();
                    StackWorkflowTags stackWorkflowTags = new StackWorkflowTags(stackId, stackName, stackAccountId, AccountFullName.getInstance((String)stackAccountId, (String[])new String[0]).getAccountName());
                    WorkflowClientFactory workflowClientFactory = new WorkflowClientFactory(WorkflowClientManager.getSimpleWorkflowClient(), CloudFormationProperties.SWF_DOMAIN, CloudFormationProperties.SWF_TASKLIST);
                    DeleteStackWorkflowDescriptionTemplate workflowDescriptionTemplate = new DeleteStackWorkflowDescriptionTemplate();
                    InterfaceBasedWorkflowClient client = workflowClientFactory.getNewWorkflowClient(DeleteStackWorkflow.class, (WorkflowDescriptionTemplate)workflowDescriptionTemplate, (WorkflowTags)stackWorkflowTags);
                    DeleteStackWorkflowClient deleteStackWorkflow = new DeleteStackWorkflowClient((InterfaceBasedWorkflowClient<DeleteStackWorkflow>)client);
                    deleteStackWorkflow.deleteStack(stackId, stackAccountId, stackEntity.getResourceDependencyManagerJson(), userId);
                    StackWorkflowEntityManager.addOrUpdateStackWorkflowEntity(stackEntity.getStackId(), StackWorkflowEntity.WorkflowType.DELETE_STACK_WORKFLOW, CloudFormationProperties.SWF_DOMAIN, client.getWorkflowExecution().getWorkflowId(), client.getWorkflowExecution().getRunId());
                }
            }
            catch (Exception ex) {
                CloudFormationService.handleException(ex);
            }
        }
        return reply;
    }

    public DescribeStackEventsResponseType describeStackEvents(DescribeStackEventsType request) throws CloudFormationException {
        DescribeStackEventsResponseType reply = (DescribeStackEventsResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            if (stackName == null) {
                throw new ValidationErrorException("Stack name is null");
            }
            CloudFormationService.checkStackPermission(ctx, stackName, accountId);
            ArrayList<StackEvent> stackEventList = StackEventEntityManager.getStackEventsByNameOrId(stackName, accountId);
            if (stackEventList.isEmpty() && ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX)) {
                stackEventList = StackEventEntityManager.getStackEventsByNameOrId(stackName, null);
            }
            StackEvents stackEvents = new StackEvents();
            stackEvents.setMember(stackEventList);
            DescribeStackEventsResult describeStackEventsResult = new DescribeStackEventsResult();
            describeStackEventsResult.setStackEvents(stackEvents);
            reply.setDescribeStackEventsResult(describeStackEventsResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public DescribeStackResourceResponseType describeStackResource(DescribeStackResourceType request) throws CloudFormationException {
        DescribeStackResourceResponseType reply = (DescribeStackResourceResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            if (stackName == null) {
                throw new ValidationErrorException("Stack name is null");
            }
            CloudFormationService.checkStackPermission(ctx, stackName, accountId);
            String logicalResourceId = request.getLogicalResourceId();
            if (logicalResourceId == null) {
                throw new ValidationErrorException("logicalResourceId is null");
            }
            StackResourceEntity stackResourceEntity = StackResourceEntityManager.describeStackResource((String)(ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX) ? null : accountId), stackName, logicalResourceId);
            StackResourceDetail stackResourceDetail = new StackResourceDetail();
            stackResourceDetail.setDescription(stackResourceEntity.getDescription());
            stackResourceDetail.setLastUpdatedTimestamp(stackResourceEntity.getLastUpdateTimestamp());
            stackResourceDetail.setLogicalResourceId(stackResourceEntity.getLogicalResourceId());
            stackResourceDetail.setMetadata(stackResourceEntity.getMetadataJson());
            stackResourceDetail.setPhysicalResourceId(stackResourceEntity.getPhysicalResourceId());
            stackResourceDetail.setResourceStatus(stackResourceEntity.getResourceStatus() == null ? null : stackResourceEntity.getResourceStatus().toString());
            stackResourceDetail.setResourceStatusReason(stackResourceEntity.getResourceStatusReason());
            stackResourceDetail.setResourceType(stackResourceEntity.getResourceType());
            stackResourceDetail.setStackId(stackResourceEntity.getStackId());
            stackResourceDetail.setStackName(stackResourceEntity.getStackName());
            DescribeStackResourceResult describeStackResourceResult = new DescribeStackResourceResult();
            describeStackResourceResult.setStackResourceDetail(stackResourceDetail);
            reply.setDescribeStackResourceResult(describeStackResourceResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public DescribeStackResourcesResponseType describeStackResources(DescribeStackResourcesType request) throws CloudFormationException {
        DescribeStackResourcesResponseType reply = (DescribeStackResourcesResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            String logicalResourceId = request.getLogicalResourceId();
            String physicalResourceId = request.getPhysicalResourceId();
            if (stackName != null && logicalResourceId != null) {
                throw new ValidationErrorException("Only one of StackName or LogicalResourceId can be set");
            }
            if (stackName == null && logicalResourceId == null) {
                throw new ValidationErrorException("StackName or LogicalResourceId must be set");
            }
            ArrayList stackResourceList = Lists.newArrayList();
            List<StackResourceEntity> stackResourceEntityList = StackResourceEntityManager.describeStackResources((String)(ctx.isAdministrator() && stackName != null && stackName.startsWith(STACK_ID_PREFIX) ? null : accountId), stackName, physicalResourceId, logicalResourceId);
            if (stackResourceEntityList != null && !stackResourceEntityList.isEmpty()) {
                CloudFormationService.checkStackPermission(ctx, stackResourceEntityList.get(0).getStackId(), accountId);
                for (StackResourceEntity stackResourceEntity : stackResourceEntityList) {
                    StackResource stackResource = new StackResource();
                    stackResource.setDescription(stackResourceEntity.getDescription());
                    stackResource.setLogicalResourceId(stackResourceEntity.getLogicalResourceId());
                    stackResource.setPhysicalResourceId(stackResourceEntity.getPhysicalResourceId());
                    stackResource.setResourceStatus(stackResourceEntity.getResourceStatus().toString());
                    stackResource.setResourceStatusReason(stackResourceEntity.getResourceStatusReason());
                    stackResource.setResourceType(stackResourceEntity.getResourceType());
                    stackResource.setStackId(stackResourceEntity.getStackId());
                    stackResource.setStackName(stackResourceEntity.getStackName());
                    stackResource.setTimestamp(stackResourceEntity.getLastUpdateTimestamp());
                    stackResourceList.add(stackResource);
                }
            }
            DescribeStackResourcesResult describeStackResourcesResult = new DescribeStackResourcesResult();
            StackResources stackResources = new StackResources();
            stackResources.setMember(stackResourceList);
            describeStackResourcesResult.setStackResources(stackResources);
            reply.setDescribeStackResourcesResult(describeStackResourcesResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public DescribeStacksResponseType describeStacks(DescribeStacksType request) throws CloudFormationException {
        DescribeStacksResponseType reply = (DescribeStacksResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            List<StackEntity> stackEntities = StackEntityManager.describeStacks((String)(ctx.isAdministrator() && stackName != null && ("verbose".equals(stackName) || stackName.startsWith(STACK_ID_PREFIX)) ? null : accountId), (String)(ctx.isAdministrator() && "verbose".equals(stackName) ? null : stackName));
            ArrayList<Stack> stackList = new ArrayList<Stack>();
            for (StackEntity stackEntity : Iterables.filter(stackEntities, (Predicate)RestrictedTypes.filterPrivileged())) {
                ArrayList<Tag> member;
                Stack stack = new Stack();
                if (stackEntity.getCapabilitiesJson() != null && !stackEntity.getCapabilitiesJson().isEmpty()) {
                    ResourceList capabilities = new ResourceList();
                    member = StackEntityHelper.jsonToCapabilities(stackEntity.getCapabilitiesJson());
                    capabilities.setMember(member);
                    stack.setCapabilities(capabilities);
                }
                stack.setCreationTime(stackEntity.getCreateOperationTimestamp());
                stack.setDescription(stackEntity.getDescription());
                stack.setStackName(stackEntity.getStackName());
                stack.setDisableRollback(stackEntity.getDisableRollback());
                stack.setLastUpdatedTime(stackEntity.getLastUpdateTimestamp());
                if (stackEntity.getNotificationARNsJson() != null && !stackEntity.getNotificationARNsJson().isEmpty()) {
                    ResourceList notificationARNs = new ResourceList();
                    member = StackEntityHelper.jsonToNotificationARNs(stackEntity.getNotificationARNsJson());
                    notificationARNs.setMember(member);
                    stack.setNotificationARNs(notificationARNs);
                }
                if (stackEntity.getOutputsJson() != null && !stackEntity.getOutputsJson().isEmpty()) {
                    boolean somethingNotReady = false;
                    ArrayList<StackEntity.Output> stackEntityOutputs = StackEntityHelper.jsonToOutputs(stackEntity.getOutputsJson());
                    ArrayList member2 = Lists.newArrayList();
                    for (StackEntity.Output stackEntityOutput : stackEntityOutputs) {
                        if (!stackEntityOutput.isReady()) {
                            somethingNotReady = true;
                            break;
                        }
                        if (!stackEntityOutput.isAllowedByCondition()) continue;
                        Output output = new Output();
                        output.setDescription(stackEntityOutput.getDescription());
                        output.setOutputKey(stackEntityOutput.getKey());
                        output.setOutputValue(stackEntityOutput.getStringValue());
                        member2.add(output);
                    }
                    if (!somethingNotReady) {
                        Outputs outputs = new Outputs();
                        outputs.setMember(member2);
                        stack.setOutputs(outputs);
                    }
                }
                if (stackEntity.getParametersJson() != null && !stackEntity.getParametersJson().isEmpty()) {
                    ArrayList<StackEntity.Parameter> stackEntityParameters = StackEntityHelper.jsonToParameters(stackEntity.getParametersJson());
                    member = Lists.newArrayList();
                    for (StackEntity.Parameter stackEntityParameter : stackEntityParameters) {
                        Parameter parameter = new Parameter();
                        parameter.setParameterKey(stackEntityParameter.getKey());
                        parameter.setParameterValue(stackEntityParameter.isNoEcho() ? NO_ECHO_PARAMETER_VALUE : stackEntityParameter.getStringValue());
                        member.add((Tag)parameter);
                    }
                    Parameters parameters = new Parameters();
                    parameters.setMember((ArrayList)member);
                    stack.setParameters(parameters);
                }
                stack.setStackId(stackEntity.getStackId());
                stack.setStackName(stackEntity.getStackName());
                stack.setStackStatus(stackEntity.getStackStatus().toString());
                stack.setStackStatusReason(stackEntity.getStackStatusReason());
                if (stackEntity.getTagsJson() != null && !stackEntity.getTagsJson().isEmpty()) {
                    Tags tags = new Tags();
                    member = StackEntityHelper.jsonToTags(stackEntity.getTagsJson());
                    tags.setMember(member);
                    stack.setTags(tags);
                }
                stack.setTimeoutInMinutes(stackEntity.getTimeoutInMinutes());
                stackList.add(stack);
            }
            DescribeStacksResult describeStacksResult = new DescribeStacksResult();
            Stacks stacks = new Stacks();
            stacks.setMember(stackList);
            describeStacksResult.setStacks(stacks);
            reply.setDescribeStacksResult(describeStacksResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public EstimateTemplateCostResponseType estimateTemplateCost(EstimateTemplateCostType request) throws CloudFormationException {
        return (EstimateTemplateCostResponseType)request.getReply();
    }

    public GetStackPolicyResponseType getStackPolicy(GetStackPolicyType request) throws CloudFormationException {
        GetStackPolicyResponseType reply = (GetStackPolicyResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            if (stackName == null) {
                throw new ValidationErrorException("StackName must not be null");
            }
            CloudFormationService.checkStackPermission(ctx, stackName, accountId);
            StackEntity stackEntity = StackEntityManager.getAnyStackByNameOrId(stackName, (String)(ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX) ? null : accountId));
            if (stackEntity == null) {
                throw new ValidationErrorException("Stack " + stackName + " does not exist");
            }
            GetStackPolicyResult getStackPolicyResult = new GetStackPolicyResult();
            getStackPolicyResult.setStackPolicyBody(stackEntity.getStackPolicy());
            reply.setGetStackPolicyResult(getStackPolicyResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public GetTemplateResponseType getTemplate(GetTemplateType request) throws CloudFormationException {
        GetTemplateResponseType reply = (GetTemplateResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            if (stackName == null) {
                throw new ValidationErrorException("StackName must not be null");
            }
            CloudFormationService.checkStackPermission(ctx, stackName, accountId);
            StackEntity stackEntity = StackEntityManager.getAnyStackByNameOrId(stackName, (String)(ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX) ? null : accountId));
            if (stackEntity == null) {
                throw new ValidationErrorException("Stack " + stackName + " does not exist");
            }
            GetTemplateResult getTemplateResult = new GetTemplateResult();
            getTemplateResult.setTemplateBody(stackEntity.getTemplateBody());
            reply.setGetTemplateResult(getTemplateResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public ListStackResourcesResponseType listStackResources(ListStackResourcesType request) throws CloudFormationException {
        ListStackResourcesResponseType reply = (ListStackResourcesResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            if (stackName == null) {
                throw new ValidationErrorException("StackName must not be null");
            }
            CloudFormationService.checkStackPermission(ctx, stackName, accountId);
            ArrayList stackResourceSummaryList = Lists.newArrayList();
            List<StackResourceEntity> stackResourceEntityList = StackResourceEntityManager.listStackResources((String)(ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX) ? null : accountId), stackName);
            if (stackResourceEntityList != null) {
                for (StackResourceEntity stackResourceEntity : stackResourceEntityList) {
                    StackResourceSummary stackResourceSummary = new StackResourceSummary();
                    stackResourceSummary.setLogicalResourceId(stackResourceEntity.getLogicalResourceId());
                    stackResourceSummary.setPhysicalResourceId(stackResourceEntity.getPhysicalResourceId());
                    stackResourceSummary.setResourceStatus(stackResourceEntity.getResourceStatus().toString());
                    stackResourceSummary.setResourceStatusReason(stackResourceEntity.getResourceStatusReason());
                    stackResourceSummary.setResourceType(stackResourceEntity.getResourceType());
                    stackResourceSummary.setLastUpdatedTimestamp(stackResourceEntity.getLastUpdateTimestamp());
                    stackResourceSummaryList.add(stackResourceSummary);
                }
            }
            ListStackResourcesResult listStackResourcesResult = new ListStackResourcesResult();
            StackResourceSummaries stackResourceSummaries = new StackResourceSummaries();
            stackResourceSummaries.setMember(stackResourceSummaryList);
            listStackResourcesResult.setStackResourceSummaries(stackResourceSummaries);
            reply.setListStackResourcesResult(listStackResourcesResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public ListStacksResponseType listStacks(ListStacksType request) throws CloudFormationException {
        ListStacksResponseType reply = (ListStacksResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            ResourceList stackStatusFilter = request.getStackStatusFilter();
            ArrayList statusFilterList = Lists.newArrayList();
            if (stackStatusFilter != null && stackStatusFilter.getMember() != null) {
                for (String statusFilterStr : stackStatusFilter.getMember()) {
                    try {
                        statusFilterList.add(StackEntity.Status.valueOf(statusFilterStr));
                    }
                    catch (Exception ex) {
                        throw new ValidationErrorException("Invalid value for StackStatus " + statusFilterStr);
                    }
                }
            }
            List<StackEntity> stackEntities = StackEntityManager.listStacks(accountId, statusFilterList);
            ArrayList<StackSummary> stackSummaryList = new ArrayList<StackSummary>();
            for (StackEntity stackEntity : Iterables.filter(stackEntities, (Predicate)RestrictedTypes.filterPrivileged())) {
                StackSummary stackSummary = new StackSummary();
                stackSummary.setCreationTime(stackEntity.getCreateOperationTimestamp());
                stackSummary.setDeletionTime(stackEntity.getDeleteOperationTimestamp());
                stackSummary.setLastUpdatedTime(stackEntity.getLastUpdateOperationTimestamp());
                stackSummary.setStackId(stackEntity.getStackId());
                stackSummary.setStackName(stackEntity.getStackName());
                stackSummary.setStackStatus(stackEntity.getStackStatus().toString());
                stackSummary.setTemplateDescription(stackEntity.getDescription());
                stackSummaryList.add(stackSummary);
            }
            ListStacksResult listStacksResult = new ListStacksResult();
            StackSummaries stackSummaries = new StackSummaries();
            stackSummaries.setMember(stackSummaryList);
            listStacksResult.setStackSummaries(stackSummaries);
            reply.setListStacksResult(listStacksResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public SetStackPolicyResponseType setStackPolicy(SetStackPolicyType request) throws CloudFormationException {
        SetStackPolicyResponseType reply = (SetStackPolicyResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            User user = ctx.getUser();
            String accountId = user.getAccount().getAccountNumber();
            String stackName = request.getStackName();
            String stackPolicyBody = request.getStackPolicyBody();
            if (request.getStackPolicyURL() != null) {
                throw new ValidationErrorException("StackPolicyURL is not supported");
            }
            if (stackName == null) {
                throw new ValidationErrorException("Stack name is null");
            }
            StackEntity stackEntity = StackEntityManager.getAnyStackByNameOrId(stackName, (String)(ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX) ? null : accountId));
            if (stackEntity == null) {
                throw new ValidationErrorException("Stack " + stackName + " does not exist");
            }
            if (!RestrictedTypes.filterPrivileged().apply((Object)stackEntity)) {
                throw new AccessDeniedException("Not authorized.");
            }
            stackEntity.setStackPolicy(stackPolicyBody);
            StackEntityManager.updateStack(stackEntity);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    public UpdateStackResponseType updateStack(UpdateStackType request) throws CloudFormationException {
        return (UpdateStackResponseType)request.getReply();
    }

    public ValidateTemplateResponseType validateTemplate(ValidateTemplateType request) throws CloudFormationException {
        ValidateTemplateResponseType reply = (ValidateTemplateResponseType)request.getReply();
        try {
            Context ctx = Contexts.lookup();
            CloudFormationService.checkActionPermission("validatetemplate", ctx);
            User user = ctx.getUser();
            String userId = user.getUserId();
            String accountId = user.getAccount().getAccountNumber();
            String templateBody = request.getTemplateBody();
            String templateUrl = request.getTemplateURL();
            String stackName = "stackName";
            if (templateBody == null && templateUrl == null) {
                throw new ValidationErrorException("Either TemplateBody or TemplateURL must be set.");
            }
            if (templateBody != null && templateUrl != null) {
                throw new ValidationErrorException("Exactly one of TemplateBody or TemplateURL must be set.");
            }
            if (templateBody != null && (long)templateBody.getBytes().length > Limits.REQUEST_TEMPLATE_BODY_MAX_LENGTH_BYTES) {
                throw new ValidationErrorException("Template body may not exceed " + Limits.REQUEST_TEMPLATE_BODY_MAX_LENGTH_BYTES + " bytes in a request.");
            }
            String templateText = templateBody != null ? templateBody : CloudFormationService.extractTemplateTextFromURL(templateUrl, user);
            String stackIdLocal = UUID.randomUUID().toString();
            String stackId = STACK_ID_PREFIX + REGION + ":" + accountId + ":stack/" + stackName + "/" + stackIdLocal;
            PseudoParameterValues pseudoParameterValues = new PseudoParameterValues();
            pseudoParameterValues.setAccountId(accountId);
            pseudoParameterValues.setStackName(stackName);
            pseudoParameterValues.setStackId(stackId);
            ArrayList notificationArns = Lists.newArrayList();
            pseudoParameterValues.setRegion(REGION);
            List<String> defaultRegionAvailabilityZones = CloudFormationService.describeAvailabilityZones(userId);
            HashMap availabilityZones = Maps.newHashMap();
            availabilityZones.put(REGION, defaultRegionAvailabilityZones);
            availabilityZones.put("", defaultRegionAvailabilityZones);
            pseudoParameterValues.setAvailabilityZones(availabilityZones);
            ArrayList parameters = Lists.newArrayList();
            ValidateTemplateResult validateTemplateResult = new TemplateParser().validateTemplate(templateText, parameters, pseudoParameterValues);
            reply.setValidateTemplateResult(validateTemplateResult);
        }
        catch (Exception ex) {
            CloudFormationService.handleException(ex);
        }
        return reply;
    }

    private static void handleException(Exception e) throws CloudFormationException {
        CloudFormationException cause = (CloudFormationException)((Object)Exceptions.findCause((Throwable)e, CloudFormationException.class));
        if (cause != null) {
            throw cause;
        }
        LOG.error((Object)e, (Throwable)e);
        InternalFailureException exception = new InternalFailureException(String.valueOf(e.getMessage()));
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            exception.initCause(e);
        }
        throw exception;
    }

    private static void checkStackPermission(Context ctx, String stackName, String accountId) throws AccessDeniedException {
        StackEntity stackEntity = StackEntityManager.getAnyStackByNameOrId(stackName, accountId);
        if (stackEntity == null && ctx.isAdministrator() && stackName.startsWith(STACK_ID_PREFIX)) {
            stackEntity = StackEntityManager.getAnyStackByNameOrId(stackName, null);
        }
        if (stackEntity != null && !RestrictedTypes.filterPrivileged().apply((Object)stackEntity)) {
            throw new AccessDeniedException("Not authorized.");
        }
    }

    private static void checkActionPermission(String actionType, Context ctx) throws AccessDeniedException {
        if (!Permissions.isAuthorized((String)"cloudformation", (String)actionType, (String)"", (Account)ctx.getAccount(), (String)actionType, (AuthContextSupplier)ctx.getAuthContext())) {
            throw new AccessDeniedException("User does not have permission");
        }
    }
}

