/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.euare.events;

import com.eucalyptus.auth.euare.events.AccountCreatedEvent;
import com.eucalyptus.auth.euare.events.AccountDeletedEvent;
import com.eucalyptus.event.GenericEvent;
import com.eucalyptus.event.ListenerRegistry;
import org.apache.log4j.Logger;

public class AccountEventUtils {
    private static final Logger logger = Logger.getLogger(AccountEventUtils.class);

    public static void fireCreated(String accountNumber) {
        AccountEventUtils.fire(new AccountCreatedEvent(accountNumber));
    }

    public static void fireDeleted(String accountNumber) {
        AccountEventUtils.fire(new AccountDeletedEvent(accountNumber));
    }

    private static void fire(GenericEvent<String> event) {
        try {
            ListenerRegistry.getInstance().fireEvent(event);
        }
        catch (Exception e) {
            logger.error((Object)("Error firing account event " + event), (Throwable)e);
        }
    }
}

