/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.database.activities;

import com.eucalyptus.bootstrap.DatabaseInfo;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.crypto.util.SSLSocketFactoryWrapper;
import com.eucalyptus.crypto.util.SimpleClientX509TrustManager;
import com.eucalyptus.crypto.util.SslUtils;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Charsets;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

public class VmDatabaseSSLSocketFactory
extends SSLSocketFactoryWrapper {
    private static Logger LOG = Logger.getLogger(VmDatabaseSSLSocketFactory.class);
    private static final String PROP_VMDB_SSL_PROVIDER = "com.eucalyptus.database.vmSslProvider";
    private static final String PROP_VMDB_SSL_PROTOCOL = "com.eucalyptus.database.vmSslProtocol";
    private static final String PROP_VMDB_SSL_CIPHER_SUITES = "com.eucalyptus.database.vmSslCipherSuites";
    private static final String DEFAULT_CIPHER_STRINGS = "RSA+AES:+SHA:!EXPORT:!EXPORT1025:!MD5";
    private static final String DEFAULT_PROTOCOL = "TLS";
    private final List<String> cipherSuites = ImmutableList.copyOf((Object[])SslUtils.getEnabledCipherSuites((String)VmDatabaseSSLSocketFactory.getCipherStrings(), (String[])this.getSupportedCipherSuites()));

    public VmDatabaseSSLSocketFactory() {
        super(Suppliers.ofInstance((Object)VmDatabaseSSLSocketFactory.buildDelegate()));
    }

    protected Socket notifyCreated(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledCipherSuites((String[])Iterables.toArray(this.cipherSuites, String.class));
        }
        return socket;
    }

    private static String getCipherStrings() {
        return System.getProperty(PROP_VMDB_SSL_CIPHER_SUITES, DEFAULT_CIPHER_STRINGS);
    }

    private static SSLSocketFactory buildDelegate() {
        X509Certificate certificate;
        String provider = System.getProperty(PROP_VMDB_SSL_PROVIDER);
        String protocol = System.getProperty(PROP_VMDB_SSL_PROTOCOL, DEFAULT_PROTOCOL);
        try {
            String bodyPem = DatabaseInfo.getDatabaseInfo().getAppendOnlySslCert();
            bodyPem = bodyPem.trim();
            certificate = PEMFiles.getCert((byte[])bodyPem.getBytes(Charsets.UTF_8));
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to read the server certificate", (Throwable)ex);
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        try {
            SSLContext sslContext = provider != null ? SSLContext.getInstance(protocol, provider) : SSLContext.getInstance(protocol);
            SimpleClientX509TrustManager trustManager = new SimpleClientX509TrustManager(certificate, false);
            sslContext.init(null, new TrustManager[]{trustManager}, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

