/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.database.activities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.database.activities.EnableDBInstanceEvent;
import com.eucalyptus.database.activities.EventHandlerChainCreateDbInstance;
import com.eucalyptus.resources.AbstractEventHandler;
import com.eucalyptus.resources.EventHandler;
import com.eucalyptus.resources.EventHandlerChain;
import com.eucalyptus.resources.EventHandlerException;
import com.eucalyptus.resources.StoredResult;
import com.eucalyptus.resources.client.AutoScalingClient;
import com.eucalyptus.resources.client.Ec2Client;
import com.eucalyptus.resources.client.EuareClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EventHandlerChainEnableVmDatabase
extends EventHandlerChain<EnableDBInstanceEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainEnableVmDatabase.class);

    public EventHandlerChain<EnableDBInstanceEvent> build() {
        this.append((EventHandler)new CheckAutoscalingGroup(this));
        this.append((EventHandler)new WaitOnVm(this));
        this.append((EventHandler)new WaitOnDb(this));
        this.append((EventHandler)new UpdateProperties(this));
        return this;
    }

    private static String getSystemUserId() {
        try {
            return Accounts.lookupSystemAdmin().getUserId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static class UpdateProperties
    extends AbstractEventHandler<EnableDBInstanceEvent> {
        protected UpdateProperties(EventHandlerChain<EnableDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(EnableDBInstanceEvent evt) throws EventHandlerException {
            String dbHost = null;
            try {
                dbHost = ((WaitOnDb)((Object)this.getChain().findHandler(WaitOnDb.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to look up database host");
            }
            try {
                String certBody;
                String acctNumber = Accounts.lookupUserById((String)evt.getUserId()).getAccountNumber();
                String dbId = evt.getDbInstanceIdentifier();
                String certName = EventHandlerChainCreateDbInstance.UploadServerCertificate.getCertificateName(acctNumber, dbId);
                ServerCertificateType serverCert = EuareClient.getInstance().getServerCertificate(null, certName);
                String bodyPem = certBody = serverCert.getCertificateBody();
                ConfigurableProperty certProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlysslcert");
                certProp.setValue(bodyPem);
                LOG.debug((Object)"Certificate body is updated for postgresql ssl connection");
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to read the server certificate", (Throwable)ex);
                throw new EventHandlerException("Failed to read the server certificate");
            }
            try {
                ConfigurableProperty portProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlyport");
                portProp.setValue(String.format("%d", evt.getPort()));
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to set port property", (Throwable)ex);
            }
            try {
                ConfigurableProperty userNameProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlyuser");
                userNameProp.setValue(evt.getMasterUserName());
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to set username property", (Throwable)ex);
            }
            try {
                ConfigurableProperty passwordProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlypassword");
                passwordProp.setValue(evt.getMasterUserPassword());
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to set password property", (Throwable)ex);
            }
            try {
                ConfigurableProperty hostProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlyhost");
                hostProp.setValue(dbHost);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to set hostname property", (Throwable)ex);
            }
            LOG.info((Object)"services.database.appendonly* properties are updated");
        }

        public void rollback() throws EventHandlerException {
        }
    }

    public static class WaitOnDb
    extends AbstractEventHandler<EnableDBInstanceEvent>
    implements StoredResult<String> {
        private static final String PING_DB_NAME = "eucalyptus_reporting_backend";
        private String instanceIp = null;

        protected WaitOnDb(EventHandlerChain<EnableDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(EnableDBInstanceEvent evt) throws EventHandlerException {
            try {
                String instanceId = ((WaitOnVm)((Object)this.getChain().findHandler(WaitOnVm.class))).getResult().get(0);
                List instances = Ec2Client.getInstance().describeInstances(EventHandlerChainEnableVmDatabase.getSystemUserId(), (List)Lists.newArrayList((Object[])new String[]{instanceId}));
                for (RunningInstancesItemType instance : instances) {
                    if (!instanceId.equals(instance.getInstanceId())) continue;
                    this.instanceIp = instance.getIpAddress();
                    break;
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to lookup vm ip", (Throwable)ex);
            }
            if (this.instanceIp == null) {
                throw new EventHandlerException("Failed to lookup vm ip");
            }
            String jdbcUrl = WaitOnDb.getJdbcUrl(this.instanceIp, evt.getPort());
            boolean connected = false;
            int MAX_RETRY_SEC = 120;
            for (int i = 1; i <= 120; ++i) {
                if (WaitOnDb.pingDatabase(jdbcUrl, evt.getMasterUserName(), evt.getMasterUserPassword())) {
                    connected = true;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i % 10 != 0) continue;
                LOG.info((Object)("Trying to connect to database at " + this.instanceIp));
            }
            if (!connected) {
                throw new EventHandlerException("Failed to connect to database at " + this.instanceIp);
            }
            LOG.info((Object)("Database host " + this.instanceIp + " is connected"));
        }

        public static String getJdbcUrl(String instanceIp, int port) {
            String jdbcUrl = String.format("jdbc:postgresql://%s:%s/%s", instanceIp, port, PING_DB_NAME);
            return jdbcUrl;
        }

        public static String getJdbcUrlWithSsl(String instanceIp, int port) {
            String ssl = "ssl=true&sslfactory=com.eucalyptus.database.activities.VmDatabaseSSLSocketFactory";
            String jdbcUrl = String.format("jdbc:postgresql://%s:%s/%s?%s", instanceIp, port, PING_DB_NAME, "ssl=true&sslfactory=com.eucalyptus.database.activities.VmDatabaseSSLSocketFactory");
            return jdbcUrl;
        }

        /*
         * Exception decompiling
         */
        public static boolean pingDatabase(String jdbcUrl, String userName, String password) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void rollback() throws EventHandlerException {
        }

        public List<String> getResult() {
            if (this.instanceIp != null) {
                return Lists.newArrayList((Object[])new String[]{this.instanceIp});
            }
            return Lists.newArrayList();
        }
    }

    public static class WaitOnVm
    extends AbstractEventHandler<EnableDBInstanceEvent>
    implements StoredResult<String> {
        private String instanceId = null;

        protected WaitOnVm(EventHandlerChain<EnableDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(EnableDBInstanceEvent evt) throws EventHandlerException {
            String tagKey = "Name";
            String tagValue = "euca-internal-db-servers";
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainEnableVmDatabase.getSystemUserId();
            boolean vmFound = false;
            int MAX_RETRY_SEC = 600;
            for (int i = 1; i <= 600; ++i) {
                try {
                    List instances = Ec2Client.getInstance().describeInstances(systemUserId, (List)Lists.newArrayList());
                    for (RunningInstancesItemType instance : instances) {
                        ArrayList tags = instance.getTagSet();
                        String state = instance.getStateName();
                        if (tags != null) {
                            for (ResourceTag tag : tags) {
                                if (!"Name".equals(tag.getKey()) || !"euca-internal-db-servers".equals(tag.getValue()) || !"running".equals(state)) continue;
                                vmFound = true;
                                this.instanceId = instance.getInstanceId();
                                break;
                            }
                        }
                        if (!vmFound) continue;
                        break;
                    }
                }
                catch (Exception ex) {
                    vmFound = false;
                }
                if (vmFound) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i % 10 != 0) continue;
                LOG.info((Object)"Looking for running database VM");
            }
            if (!vmFound) {
                throw new EventHandlerException("Cannot find a running database VM");
            }
            LOG.info((Object)("Database VM (" + this.instanceId + ") is found"));
        }

        public void rollback() throws EventHandlerException {
        }

        public List<String> getResult() {
            if (this.instanceId != null) {
                return Lists.newArrayList((Object[])new String[]{this.instanceId});
            }
            return Lists.newArrayList();
        }
    }

    public static class CheckAutoscalingGroup
    extends AbstractEventHandler<EnableDBInstanceEvent> {
        protected CheckAutoscalingGroup(EventHandlerChain<EnableDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(EnableDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainEnableVmDatabase.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
            }
            String asgName = EventHandlerChainCreateDbInstance.CreateAutoScalingGroup.getAutoscalingGroupName(acctNumber, evt.getDbInstanceIdentifier());
            boolean asgFound = false;
            try {
                DescribeAutoScalingGroupsResponseType response = AutoScalingClient.getInstance().describeAutoScalingGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{asgName}));
                ArrayList groups = response.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
                if (groups.size() > 0 && ((AutoScalingGroupType)groups.get(0)).getAutoScalingGroupName().equals(asgName)) {
                    asgFound = true;
                }
            }
            catch (Exception ex) {
                asgFound = false;
            }
            if (!asgFound) {
                throw new EventHandlerException("No such autoscaling group is found: " + asgName);
            }
        }

        public void rollback() throws EventHandlerException {
        }
    }
}

