/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.database.activities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.database.activities.DatabaseServerProperties;
import com.eucalyptus.database.activities.DeleteDBInstanceEvent;
import com.eucalyptus.database.activities.EventHandlerChainCreateDbInstance;
import com.eucalyptus.database.activities.NewDBInstanceEvent;
import com.eucalyptus.resources.AbstractEventHandler;
import com.eucalyptus.resources.EventHandler;
import com.eucalyptus.resources.EventHandlerChain;
import com.eucalyptus.resources.EventHandlerException;
import org.apache.log4j.Logger;

public class EventHandlerChainDeleteDbInstance
extends EventHandlerChain<DeleteDBInstanceEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainDeleteDbInstance.class);

    public EventHandlerChain<DeleteDBInstanceEvent> build() {
        this.append((EventHandler)new RollbackRun(this));
        return this;
    }

    public static class ExceptionThrower
    extends AbstractEventHandler<NewDBInstanceEvent> {
        protected ExceptionThrower(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            throw new EventHandlerException("Exception to trigger intentional rollback");
        }

        public void rollback() throws EventHandlerException {
        }
    }

    public static class RollbackRun
    extends AbstractEventHandler<DeleteDBInstanceEvent> {
        protected RollbackRun(EventHandlerChain<DeleteDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(DeleteDBInstanceEvent evt) throws EventHandlerException {
            EventHandlerChainCreateDbInstance createChain = new EventHandlerChainCreateDbInstance();
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.SecurityGroupSetup(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.AuthorizePort(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.IamRoleSetup(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.IamInstanceProfileSetup(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.UploadServerCertificate(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.AuthorizeServerCertificate(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.AuthorizeVolumeOperations(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.UserDataSetup(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.CreateLaunchConfiguration(createChain, DatabaseServerProperties.IMAGE, DatabaseServerProperties.INSTANCE_TYPE, DatabaseServerProperties.KEYNAME != null && DatabaseServerProperties.KEYNAME.length() > 0 ? DatabaseServerProperties.KEYNAME : null));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.CreateAutoScalingGroup(createChain));
            createChain.append((EventHandler)new EventHandlerChainCreateDbInstance.CreateTags(createChain));
            createChain.append((EventHandler)new ExceptionThrower(createChain));
            try {
                NewDBInstanceEvent createEvent = new NewDBInstanceEvent(Accounts.lookupSystemAdmin().getUserId());
                createEvent.setDbInstanceIdentifier(evt.getDbInstanceIdentifier());
                createChain.execute(createEvent);
            }
            catch (Exception ex) {
                LOG.debug((Object)ex, (Throwable)ex);
            }
        }

        public void rollback() throws EventHandlerException {
        }
    }
}

