/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.database.activities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.Instance;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.TagDescription;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.database.activities.DatabaseServerProperties;
import com.eucalyptus.database.activities.NewDBInstanceEvent;
import com.eucalyptus.resources.AbstractEventHandler;
import com.eucalyptus.resources.EventHandler;
import com.eucalyptus.resources.EventHandlerChain;
import com.eucalyptus.resources.EventHandlerException;
import com.eucalyptus.resources.StoredResult;
import com.eucalyptus.resources.client.AutoScalingClient;
import com.eucalyptus.resources.client.Ec2Client;
import com.eucalyptus.resources.client.EuareClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class EventHandlerChainCreateDbInstance
extends EventHandlerChain<NewDBInstanceEvent> {
    private static Logger LOG = Logger.getLogger(EventHandlerChainCreateDbInstance.class);

    public EventHandlerChain<NewDBInstanceEvent> build() {
        this.append((EventHandler)new AdmissionControl(this));
        this.append((EventHandler)new SecurityGroupSetup(this));
        this.append((EventHandler)new AuthorizePort(this));
        this.append((EventHandler)new IamRoleSetup(this));
        this.append((EventHandler)new IamInstanceProfileSetup(this));
        this.append((EventHandler)new UploadServerCertificate(this));
        this.append((EventHandler)new AuthorizeServerCertificate(this));
        this.append((EventHandler)new AuthorizeVolumeOperations(this));
        this.append((EventHandler)new UserDataSetup(this));
        this.append((EventHandler)new CreateLaunchConfiguration(this, DatabaseServerProperties.IMAGE, DatabaseServerProperties.INSTANCE_TYPE, DatabaseServerProperties.KEYNAME != null && DatabaseServerProperties.KEYNAME.length() > 0 ? DatabaseServerProperties.KEYNAME : null));
        this.append((EventHandler)new CreateAutoScalingGroup(this));
        this.append((EventHandler)new CreateTags(this));
        return this;
    }

    private static String getSystemUserId() {
        try {
            return Accounts.lookupSystemAdmin().getUserId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static class CreateTags
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private String tagValue = "euca-internal-db-servers";
        private String tagKey = "Name";
        private String taggedSgroupId = null;
        private String taggedAsgName = null;

        public CreateTags(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String sgroupId;
            String systemUserId;
            block19: {
                String asgName = null;
                try {
                    asgName = ((CreateAutoScalingGroup)((Object)this.getChain().findHandler(CreateAutoScalingGroup.class))).getResult().get(0);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to get autoscaling group name", (Throwable)ex);
                }
                systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
                try {
                    DescribeAutoScalingGroupsResponseType resp = AutoScalingClient.getInstance().describeAutoScalingGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{asgName}));
                    block12: for (AutoScalingGroupType asg : resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember()) {
                        if (asg.getTags() == null) continue;
                        for (TagDescription tag : asg.getTags().getMember()) {
                            if (!this.tagValue.equals(tag.getValue())) continue;
                            this.taggedAsgName = asgName;
                            continue block12;
                        }
                    }
                }
                catch (Exception resp) {
                    // empty catch block
                }
                if (this.taggedAsgName == null) {
                    try {
                        AutoScalingClient.getInstance().createOrUpdateAutoscalingTags(systemUserId, this.tagKey, this.tagValue, asgName);
                        this.taggedAsgName = asgName;
                    }
                    catch (Exception ex) {
                        throw new EventHandlerException("failed to tag autoscaling group", (Throwable)ex);
                    }
                }
                String sgroupName = null;
                sgroupId = null;
                try {
                    SecurityGroupItemType current;
                    sgroupName = ((SecurityGroupSetup)((Object)this.getChain().findHandler(SecurityGroupSetup.class))).getResult().get(0);
                    List groups = Ec2Client.getInstance().describeSecurityGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{sgroupName}));
                    if (groups != null && groups.size() > 0 && sgroupName.equals((current = (SecurityGroupItemType)groups.get(0)).getGroupName())) {
                        sgroupId = current.getGroupId();
                    }
                    if (sgroupId == null) {
                        throw new Exception(String.format("No security group named %s is found", sgroupName));
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to get security group name", (Throwable)ex);
                }
                try {
                    List tags = Ec2Client.getInstance().describeTags(systemUserId, (List)Lists.newArrayList((Object[])new String[]{"value"}), (List)Lists.newArrayList((Object[])new String[]{this.tagValue}));
                    if (tags == null) break block19;
                    for (TagDescription tag : tags) {
                        if (!sgroupId.equals(tag.getResourceId())) continue;
                        this.taggedSgroupId = sgroupId;
                        break;
                    }
                }
                catch (Exception tags) {
                    // empty catch block
                }
            }
            if (this.taggedSgroupId == null) {
                try {
                    Ec2Client.getInstance().createTags(systemUserId, this.tagKey, this.tagValue, (List)Lists.newArrayList((Object[])new String[]{sgroupId}));
                    this.taggedSgroupId = sgroupId;
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to tag security group", (Throwable)ex);
                }
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.tagKey != null && this.tagValue != null) {
                String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
                if (this.taggedSgroupId != null) {
                    try {
                        Ec2Client.getInstance().deleteTags(systemUserId, this.tagKey, this.tagValue, (List)Lists.newArrayList((Object[])new String[]{this.taggedSgroupId}));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.taggedAsgName != null) {
                    try {
                        AutoScalingClient.getInstance().deleteAutoscalingTags(systemUserId, this.tagKey, this.tagValue, this.taggedAsgName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public List<String> getResult() {
            return Lists.newArrayList((Object[])new String[]{this.tagValue});
        }
    }

    public static class CreateAutoScalingGroup
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private String createdAutoScalingGroup = null;

        public CreateAutoScalingGroup(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
            }
            String asgName = CreateAutoScalingGroup.getAutoscalingGroupName(acctNumber, evt.getDbInstanceIdentifier());
            boolean asgFound = false;
            try {
                DescribeAutoScalingGroupsResponseType response = AutoScalingClient.getInstance().describeAutoScalingGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{asgName}));
                ArrayList groups = response.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
                if (groups.size() > 0 && ((AutoScalingGroupType)groups.get(0)).getAutoScalingGroupName().equals(asgName)) {
                    asgFound = true;
                }
            }
            catch (Exception ex) {
                asgFound = false;
            }
            if (asgFound) {
                this.createdAutoScalingGroup = asgName;
                return;
            }
            String launchConfigName = null;
            try {
                launchConfigName = ((CreateLaunchConfiguration)((Object)this.getChain().findHandler(CreateLaunchConfiguration.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to find the launch configuration name", (Throwable)ex);
            }
            List<String> availabilityZones = null;
            try {
                availabilityZones = DatabaseServerProperties.listConfiguredZones();
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to lookup configured availability zones for db servers", (Throwable)ex);
            }
            if (availabilityZones.size() <= 0) {
                throw new EventHandlerException("No availability zone is found for deploying db servers");
            }
            try {
                AutoScalingClient.getInstance().createAutoScalingGroup(systemUserId, asgName, availabilityZones, 1, launchConfigName, null, null);
                this.createdAutoScalingGroup = asgName;
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to create autoscaling group", (Throwable)ex);
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.createdAutoScalingGroup != null) {
                HashSet instances = Sets.newHashSet();
                String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
                try {
                    DescribeAutoScalingGroupsResponseType resp = AutoScalingClient.getInstance().describeAutoScalingGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{this.createdAutoScalingGroup}));
                    for (AutoScalingGroupType asg : resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember()) {
                        if (asg.getInstances() == null) continue;
                        for (Instance instance : asg.getInstances().getMember()) {
                            instances.add(instance.getInstanceId());
                        }
                    }
                }
                catch (Exception resp) {
                    // empty catch block
                }
                try {
                    AutoScalingClient.getInstance().updateAutoScalingGroup(systemUserId, this.createdAutoScalingGroup, null, 0);
                }
                catch (Exception ex) {
                    LOG.warn((Object)String.format("Unable to set desired capacity for %s", this.createdAutoScalingGroup), (Throwable)ex);
                }
                boolean error = false;
                int NUM_DELETE_ASG_RETRY = 4;
                for (int i = 0; i < 4; ++i) {
                    try {
                        AutoScalingClient.getInstance().deleteAutoScalingGroup(systemUserId, this.createdAutoScalingGroup, true);
                        boolean asgFound = false;
                        try {
                            DescribeAutoScalingGroupsResponseType resp = AutoScalingClient.getInstance().describeAutoScalingGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{this.createdAutoScalingGroup}));
                            for (AutoScalingGroupType asg : resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember()) {
                                if (!this.createdAutoScalingGroup.equals(asg.getAutoScalingGroupName())) continue;
                                asgFound = true;
                            }
                        }
                        catch (Exception ex) {
                            asgFound = false;
                        }
                        if (asgFound) {
                            throw new Exception("Autoscaling group was not deleted");
                        }
                        error = false;
                    }
                    catch (Exception ex) {
                        error = true;
                        LOG.warn((Object)String.format("Failed to delete autoscale group (%d'th attempt): %s", i + 1, this.createdAutoScalingGroup));
                        try {
                            long sleepMs = (i + 1) * 500;
                            Thread.sleep(sleepMs);
                        }
                        catch (Exception sleepMs) {
                            // empty catch block
                        }
                    }
                    if (!error) break;
                }
                if (error) {
                    throw new EventHandlerException("Failed to delete autoscaling group");
                }
                do {
                    ArrayList terminated = Lists.newArrayList();
                    for (String instanceId : instances) {
                        try {
                            List runningInstances = Ec2Client.getInstance().describeInstances(systemUserId, (List)Lists.newArrayList((Object[])new String[]{instanceId}));
                            String state = ((RunningInstancesItemType)runningInstances.get(0)).getStateName();
                            if (!"terminated".equals(state)) continue;
                            terminated.add(instanceId);
                        }
                        catch (Exception ex) {
                            terminated.add(instanceId);
                        }
                    }
                    for (String terminatedId : terminated) {
                        instances.remove(terminatedId);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (instances.size() > 0);
            }
        }

        public List<String> getResult() {
            if (this.createdAutoScalingGroup != null) {
                return Lists.newArrayList((Object[])new String[]{this.createdAutoScalingGroup});
            }
            return Lists.newArrayList();
        }

        public static String getAutoscalingGroupName(String acctNumber, String dbName) {
            return String.format("asg-euca-internal-db-%s-%s", acctNumber, dbName);
        }
    }

    public static class CreateLaunchConfiguration
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private String emi = null;
        private String instanceType = null;
        private String keyName = null;
        private String createdLaunchConfig = null;

        public CreateLaunchConfiguration(EventHandlerChain<NewDBInstanceEvent> chain, String emi, String instanceType) {
            super(chain);
            this.emi = emi;
            this.instanceType = instanceType;
        }

        public CreateLaunchConfiguration(EventHandlerChain<NewDBInstanceEvent> chain, String emi, String instanceType, String keyName) {
            this(chain, emi, instanceType);
            this.keyName = keyName;
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
            }
            String launchConfigName = String.format("lc-euca-internal-db-%s-%s", acctNumber, evt.getDbInstanceIdentifier());
            try {
                LaunchConfigurationType lcFound = AutoScalingClient.getInstance().describeLaunchConfiguration(systemUserId, launchConfigName);
                if (lcFound != null) {
                    try {
                        AutoScalingClient.getInstance().deleteLaunchConfiguration(systemUserId, launchConfigName);
                        LOG.debug((Object)("Deleted the existing launch config: " + launchConfigName));
                        this.createdLaunchConfig = null;
                    }
                    catch (Exception ex) {
                        this.createdLaunchConfig = launchConfigName;
                    }
                }
            }
            catch (Exception lcFound) {
                // empty catch block
            }
            if (this.createdLaunchConfig == null) {
                String instanceProfileName = null;
                try {
                    instanceProfileName = ((IamInstanceProfileSetup)((Object)this.getChain().findHandler(IamInstanceProfileSetup.class))).getResult().get(0);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to get the instance profile name", (Throwable)ex);
                }
                String sgName = null;
                try {
                    sgName = ((SecurityGroupSetup)((Object)this.getChain().findHandler(SecurityGroupSetup.class))).getResult().get(0);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to get the security group name", (Throwable)ex);
                }
                String userData = null;
                try {
                    userData = ((UserDataSetup)((Object)this.getChain().findHandler(UserDataSetup.class))).getResult().get(0);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to get the user-data field", (Throwable)ex);
                }
                try {
                    AutoScalingClient.getInstance().createLaunchConfiguration(systemUserId, this.emi, this.instanceType, instanceProfileName, launchConfigName, sgName, this.keyName, userData);
                    this.createdLaunchConfig = launchConfigName;
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to create launch configuration", (Throwable)ex);
                }
            }
        }

        public void rollback() {
            if (this.createdLaunchConfig != null) {
                try {
                    AutoScalingClient.getInstance().deleteLaunchConfiguration(EventHandlerChainCreateDbInstance.getSystemUserId(), this.createdLaunchConfig);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public List<String> getResult() {
            if (this.createdLaunchConfig != null) {
                return Lists.newArrayList((Object[])new String[]{this.createdLaunchConfig});
            }
            return Lists.newArrayList();
        }
    }

    public static class UserDataSetup
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private String encryptedPassword = null;
        private String serverCertArn = null;

        public UserDataSetup(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String certPem = null;
            X509Certificate serverCert = null;
            String serverCertName = null;
            try {
                List<String> result = ((UploadServerCertificate)((Object)this.getChain().findHandler(UploadServerCertificate.class))).getResult();
                serverCertName = result.get(0);
                certPem = result.get(1);
                serverCert = PEMFiles.toCertificate((String)certPem);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to find the server certificate");
            }
            try {
                Cipher cipher = Ciphers.RSA_PKCS1.get();
                cipher.init(1, (Key)serverCert.getPublicKey(), (SecureRandom)Crypto.getSecureRandomSupplier().get());
                byte[] bencPassword = cipher.doFinal(evt.getMasterUserPassword().getBytes());
                this.encryptedPassword = new String(Base64.encode((byte[])bencPassword));
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to encrypt the password");
            }
            try {
                ServerCertificateType cert = EuareClient.getInstance().getServerCertificate(EventHandlerChainCreateDbInstance.getSystemUserId(), serverCertName);
                this.serverCertArn = cert.getServerCertificateMetadata().getArn();
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to get server certificate named " + serverCertName, (Throwable)ex);
            }
        }

        public void rollback() {
        }

        public List<String> getResult() {
            String userData = B64.standard.encString((String)String.format("%s\n%s", DatabaseServerProperties.getCredentialsString(), DatabaseServerProperties.getServerUserData(DatabaseServerProperties.VOLUME, DatabaseServerProperties.NTP_SERVER, DatabaseServerProperties.INIT_SCRIPT, this.encryptedPassword, this.serverCertArn)));
            return Lists.newArrayList((Object[])new String[]{userData});
        }
    }

    public static class AuthorizeVolumeOperations
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        public static final String VOLUME_OPS_ROLE_POLICY_NAME_PREFIX = "db-iam-policy-volumes";
        public static final String ROLE_VOLUME_OPS_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\":[\"ec2:CreateVolume\",\"ec2:AttachVolume\",\"ec2:DetachVolume\",\"ec2:DescribeVolumes\"],\"Effect\": \"Allow\",\"Resource\": \"*\"}]}";
        private String roleName = null;
        private String createdPolicyName = null;

        public AuthorizeVolumeOperations(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
            }
            try {
                this.roleName = ((IamRoleSetup)((Object)this.getChain().findHandler(IamRoleSetup.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to find the created role name", (Throwable)ex);
            }
            String policyName = String.format("%s-%s-%s", VOLUME_OPS_ROLE_POLICY_NAME_PREFIX, acctNumber, evt.getDbInstanceIdentifier());
            String rolePolicyDoc = ROLE_VOLUME_OPS_POLICY_DOCUMENT;
            try {
                GetRolePolicyResult rolePolicy = EuareClient.getInstance().getRolePolicy(systemUserId, this.roleName, policyName);
                if (rolePolicy != null && policyName.equals(rolePolicy.getPolicyName())) {
                    this.createdPolicyName = policyName;
                }
            }
            catch (Exception rolePolicy) {
                // empty catch block
            }
            if (this.createdPolicyName == null) {
                try {
                    EuareClient.getInstance().putRolePolicy(systemUserId, this.roleName, policyName, ROLE_VOLUME_OPS_POLICY_DOCUMENT);
                    this.createdPolicyName = policyName;
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to authorize volume operations", (Throwable)ex);
                }
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.createdPolicyName != null) {
                try {
                    EuareClient.getInstance().deleteRolePolicy(EventHandlerChainCreateDbInstance.getSystemUserId(), this.roleName, this.createdPolicyName);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to delete role policy for volume operations", (Throwable)ex);
                }
            }
        }

        public List<String> getResult() {
            if (this.createdPolicyName != null) {
                return Lists.newArrayList((Object[])new String[]{this.createdPolicyName});
            }
            return Lists.newArrayList();
        }
    }

    public static class AuthorizeServerCertificate
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        public static final String SERVER_CERT_ROLE_POLICY_NAME_PREFIX = "db-iam-policy-servercert";
        public static final String ROLE_SERVER_CERT_POLICY_DOCUMENT = "{\"Statement\":[{\"Action\":[\"iam:DownloadServerCertificate\"],\"Effect\": \"Allow\",\"Resource\": \"CERT_ARN_PLACEHOLDER\"}]}";
        private String roleName = null;
        private String createdPolicyName = null;

        public AuthorizeServerCertificate(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
            }
            String certName = null;
            String certArn = null;
            try {
                this.roleName = ((IamRoleSetup)((Object)this.getChain().findHandler(IamRoleSetup.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to find the created role name", (Throwable)ex);
            }
            try {
                certName = ((UploadServerCertificate)((Object)this.getChain().findHandler(UploadServerCertificate.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to find the uploaded cert name", (Throwable)ex);
            }
            try {
                ServerCertificateType cert = EuareClient.getInstance().getServerCertificate(systemUserId, certName);
                certArn = cert.getServerCertificateMetadata().getArn();
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to lookup server certificate", (Throwable)ex);
            }
            String policyName = String.format("%s-%s-%s", SERVER_CERT_ROLE_POLICY_NAME_PREFIX, acctNumber, evt.getDbInstanceIdentifier());
            String rolePolicyDoc = ROLE_SERVER_CERT_POLICY_DOCUMENT.replace("CERT_ARN_PLACEHOLDER", certArn);
            try {
                GetRolePolicyResult rolePolicy = EuareClient.getInstance().getRolePolicy(systemUserId, this.roleName, policyName);
                if (rolePolicy != null && policyName.equals(rolePolicy.getPolicyName())) {
                    this.createdPolicyName = policyName;
                }
            }
            catch (Exception rolePolicy) {
                // empty catch block
            }
            if (this.createdPolicyName == null) {
                try {
                    EuareClient.getInstance().putRolePolicy(systemUserId, this.roleName, policyName, rolePolicyDoc);
                    this.createdPolicyName = policyName;
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to authorize server certificate", (Throwable)ex);
                }
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.createdPolicyName != null) {
                try {
                    EuareClient.getInstance().deleteRolePolicy(EventHandlerChainCreateDbInstance.getSystemUserId(), this.roleName, this.createdPolicyName);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to delete role policy for server certificate", (Throwable)ex);
                }
            }
        }

        public List<String> getResult() {
            if (this.createdPolicyName != null) {
                return Lists.newArrayList((Object[])new String[]{this.createdPolicyName});
            }
            return Lists.newArrayList();
        }
    }

    public static class UploadServerCertificate
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private static final String DEFAULT_SERVER_CERT_PATH = "/euca-internal";
        private static final String SERVER_CERT_NAME_PREFIX = "euca-internal-db";
        private String createdServerCert = null;
        private String certificate = null;

        public UploadServerCertificate(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public static String getCertificateName(String acctNumber, String dbIdentifier) {
            return String.format("%s-%s-%s", SERVER_CERT_NAME_PREFIX, acctNumber, dbIdentifier);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String certName;
            String acctNumber;
            String systemUserId;
            block12: {
                String userId = evt.getUserId();
                systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
                acctNumber = null;
                try {
                    acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
                }
                catch (AuthException ex) {
                    throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
                }
                String certPath = DEFAULT_SERVER_CERT_PATH;
                certName = UploadServerCertificate.getCertificateName(acctNumber, evt.getDbInstanceIdentifier());
                try {
                    ServerCertificateType cert = EuareClient.getInstance().getServerCertificate(systemUserId, certName);
                    if (cert == null || cert.getServerCertificateMetadata() == null) break block12;
                    try {
                        EuareClient.getInstance().deleteServerCertificate(systemUserId, cert.getServerCertificateMetadata().getServerCertificateName());
                        this.createdServerCert = null;
                    }
                    catch (Exception ex) {
                        throw new EventHandlerException("failed to delete server certificate");
                    }
                }
                catch (EventHandlerException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.createdServerCert = null;
                }
            }
            if (this.createdServerCert == null) {
                String pkPem = null;
                String certPem = null;
                try {
                    KeyPair kp = Certs.generateKeyPair();
                    X509Certificate kpCert = Certs.generateCertificate((KeyPair)kp, (String)String.format("Certificate-for-db-(%s-%s)", acctNumber, evt.getDbInstanceIdentifier()));
                    certPem = new String(PEMFiles.getBytes((Object)kpCert));
                    pkPem = new String(PEMFiles.getBytes((Object)kp));
                    this.certificate = PEMFiles.fromCertificate((X509Certificate)kpCert);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed generating server cert", (Throwable)ex);
                }
                try {
                    EuareClient.getInstance().uploadServerCertificate(systemUserId, certName, DEFAULT_SERVER_CERT_PATH, certPem, pkPem, null);
                    this.createdServerCert = certName;
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to upload server cert", (Throwable)ex);
                }
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.createdServerCert != null) {
                try {
                    EuareClient.getInstance().deleteServerCertificate(EventHandlerChainCreateDbInstance.getSystemUserId(), this.createdServerCert);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to delete server certificate");
                }
            }
        }

        public List<String> getResult() {
            if (this.createdServerCert != null) {
                return Lists.newArrayList((Object[])new String[]{this.createdServerCert, this.certificate});
            }
            return Lists.newArrayList();
        }
    }

    public static class IamInstanceProfileSetup
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        public static final String DEFAULT_INSTANCE_PROFILE_PATH_PREFIX = "/internal/db";
        public static final String DEFAULT_INSTANCE_PROFILE_NAME_PREFIX = "db";
        private InstanceProfileType instanceProfile = null;
        private String attachedRole = null;

        public IamInstanceProfileSetup(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
            }
            String profilePath = DEFAULT_INSTANCE_PROFILE_PATH_PREFIX;
            String profileName = String.format("%s-%s-%s", DEFAULT_INSTANCE_PROFILE_NAME_PREFIX, acctNumber, evt.getDbInstanceIdentifier());
            String roleName = null;
            try {
                roleName = ((IamRoleSetup)((Object)this.getChain().findHandler(IamRoleSetup.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to lookup the created role name");
            }
            try {
                List instanceProfiles = EuareClient.getInstance().listInstanceProfiles(systemUserId, DEFAULT_INSTANCE_PROFILE_PATH_PREFIX);
                for (InstanceProfileType ip : instanceProfiles) {
                    if (!profileName.equals(ip.getInstanceProfileName())) continue;
                    this.instanceProfile = ip;
                    break;
                }
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to list instance profiles", (Throwable)ex);
            }
            if (this.instanceProfile == null) {
                try {
                    this.instanceProfile = EuareClient.getInstance().createInstanceProfile(systemUserId, profileName, DEFAULT_INSTANCE_PROFILE_PATH_PREFIX);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to create instance profile", (Throwable)ex);
                }
            }
            if (this.instanceProfile == null) {
                throw new EventHandlerException("No instance profile for db server VM is found");
            }
            try {
                ArrayList roles = this.instanceProfile.getRoles().getMember();
                boolean roleFound = false;
                for (RoleType role : roles) {
                    if (!role.getRoleName().equals(roleName)) continue;
                    roleFound = true;
                    this.attachedRole = role.getRoleName();
                    break;
                }
                if (!roleFound) {
                    throw new NoSuchElementException();
                }
            }
            catch (Exception ex) {
                if (roleName == null) {
                    throw new EventHandlerException("No role name is found for db service VMs");
                }
                try {
                    EuareClient.getInstance().addRoleToInstanceProfile(systemUserId, this.instanceProfile.getInstanceProfileName(), roleName);
                    this.attachedRole = roleName;
                }
                catch (Exception ex2) {
                    throw new EventHandlerException("Failed to add role to the instance profile", (Throwable)ex2);
                }
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.attachedRole != null && this.instanceProfile != null) {
                try {
                    EuareClient.getInstance().removeRoleFromInstanceProfile(EventHandlerChainCreateDbInstance.getSystemUserId(), this.instanceProfile.getInstanceProfileName(), this.attachedRole);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.instanceProfile != null) {
                try {
                    EuareClient.getInstance().deleteInstanceProfile(EventHandlerChainCreateDbInstance.getSystemUserId(), this.instanceProfile.getInstanceProfileName());
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to delete instance profile", (Throwable)ex);
                }
            }
        }

        public List<String> getResult() {
            if (this.instanceProfile != null) {
                return Lists.newArrayList((Object[])new String[]{this.instanceProfile.getInstanceProfileName()});
            }
            return Lists.newArrayList();
        }
    }

    public static class IamRoleSetup
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private static final String DEFAULT_ROLE_PATH_PREFIX = "/internal/db";
        private static final String DEFAULT_ROLE_NAME = "db";
        private static final String DEFAULT_ASSUME_ROLE_POLICY = "{\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"ec2.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}";
        private RoleType role = null;

        public IamRoleSetup(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String roleName;
            String systemUserId;
            block9: {
                String userId = evt.getUserId();
                systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
                String acctNumber = null;
                try {
                    acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
                }
                catch (AuthException ex) {
                    throw new EventHandlerException("Failed to lookup account number", (Throwable)ex);
                }
                String rolePath = DEFAULT_ROLE_PATH_PREFIX;
                roleName = String.format("%s-%s-%s", DEFAULT_ROLE_NAME, acctNumber, evt.getDbInstanceIdentifier());
                String assumeRolePolicy = DEFAULT_ASSUME_ROLE_POLICY;
                try {
                    List result = EuareClient.getInstance().listRoles(systemUserId, DEFAULT_ROLE_PATH_PREFIX);
                    if (result == null) break block9;
                    for (RoleType r : result) {
                        if (!roleName.equals(r.getRoleName())) continue;
                        this.role = r;
                        break;
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to list IAM roles", (Throwable)ex);
                }
            }
            if (this.role == null) {
                try {
                    this.role = EuareClient.getInstance().createRole(systemUserId, roleName, DEFAULT_ROLE_PATH_PREFIX, DEFAULT_ASSUME_ROLE_POLICY);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to create the role for db server Vms");
                }
            }
            if (this.role == null) {
                throw new EventHandlerException("No role is found for db server Vms");
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.role != null) {
                try {
                    EuareClient.getInstance().deleteRole(EventHandlerChainCreateDbInstance.getSystemUserId(), this.role.getRoleName());
                }
                catch (Exception ex) {
                    throw new EventHandlerException("failed to delete the created role");
                }
            }
        }

        public List<String> getResult() {
            if (this.role != null) {
                return Lists.newArrayList((Object[])new String[]{this.role.getRoleName()});
            }
            return Lists.newArrayList();
        }
    }

    public static class AuthorizePort
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<Integer> {
        private String sgroupName = null;
        private int authorizedPort = -1;

        protected AuthorizePort(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            try {
                this.sgroupName = ((SecurityGroupSetup)((Object)this.getChain().findHandler(SecurityGroupSetup.class))).getResult().get(0);
            }
            catch (Exception ex) {
                throw new EventHandlerException("Cannot find the created security group name", (Throwable)ex);
            }
            try {
                Ec2Client.getInstance().authorizeSecurityGroup(systemUserId, this.sgroupName, "tcp", evt.getPort());
                this.authorizedPort = evt.getPort();
            }
            catch (Exception ex) {
                throw new EventHandlerException("Failed to authorize the port", (Throwable)ex);
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.sgroupName != null && this.authorizedPort > 0) {
                try {
                    Ec2Client.getInstance().revokeSecurityGroup(EventHandlerChainCreateDbInstance.getSystemUserId(), this.sgroupName, "tcp", this.authorizedPort);
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to revoke the port", (Throwable)ex);
                }
            }
        }

        public List<Integer> getResult() {
            if (this.authorizedPort > 0) {
                return Lists.newArrayList((Object[])new Integer[]{this.authorizedPort});
            }
            return Lists.newArrayList();
        }
    }

    public static class SecurityGroupSetup
    extends AbstractEventHandler<NewDBInstanceEvent>
    implements StoredResult<String> {
        private String createdGroup = null;
        private String createdGroupId = null;
        private String groupOwnerAccountId = null;
        NewDBInstanceEvent event = null;

        SecurityGroupSetup(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        /*
         * Unable to fully structure code
         */
        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            this.event = evt;
            userId = evt.getUserId();
            systemUserId = EventHandlerChainCreateDbInstance.access$000();
            acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup system user", (Throwable)ex);
            }
            groupName = String.format("euca-internal-db-%s-%s", new Object[]{acctNumber, evt.getDbInstanceIdentifier()});
            groupDesc = String.format("group for db server %s", new Object[]{evt.getDbInstanceIdentifier()});
            groupFound = false;
            try {
                groups = Ec2Client.getInstance().describeSecurityGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{groupName}));
                if (groups != null && groups.size() > 0 && groupName.equals((current = (SecurityGroupItemType)groups.get(0)).getGroupName())) {
                    groupFound = true;
                    this.createdGroupId = current.getGroupId();
                    this.groupOwnerAccountId = current.getAccountId();
                }
            }
            catch (Exception ex) {
                groupFound = false;
            }
            if (!groupFound) {
                try {
                    Ec2Client.getInstance().createSecurityGroup(systemUserId, groupName, groupDesc);
                    this.createdGroup = groupName;
                    groups = Ec2Client.getInstance().describeSecurityGroups(systemUserId, (List)Lists.newArrayList((Object[])new String[]{groupName}));
                    if (groups == null || groups.size() <= 0 || !groupName.equals((current = (SecurityGroupItemType)groups.get(0)).getGroupName())) ** GOTO lbl34
                    this.groupOwnerAccountId = current.getAccountId();
                    this.createdGroupId = current.getGroupId();
                }
                catch (Exception ex) {
                    throw new EventHandlerException("Failed to create the security group for db server", (Throwable)ex);
                }
            } else {
                this.createdGroup = groupName;
            }
lbl34:
            // 3 sources

            if (this.createdGroup == null || this.groupOwnerAccountId == null) {
                throw new EventHandlerException("Failed to create the security group for db server");
            }
        }

        public void rollback() throws EventHandlerException {
            if (this.createdGroup == null) {
                return;
            }
            try {
                Ec2Client.getInstance().deleteSecurityGroup(EventHandlerChainCreateDbInstance.getSystemUserId(), this.createdGroup);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public List<String> getResult() {
            ArrayList result = Lists.newArrayList();
            if (this.createdGroup != null) {
                result.add(this.createdGroup);
            }
            if (this.createdGroupId != null) {
                result.add(this.createdGroupId);
            }
            return result;
        }
    }

    public static class AdmissionControl
    extends AbstractEventHandler<NewDBInstanceEvent> {
        public AdmissionControl(EventHandlerChain<NewDBInstanceEvent> chain) {
            super(chain);
        }

        public void apply(NewDBInstanceEvent evt) throws EventHandlerException {
            boolean asgFound = false;
            String userId = evt.getUserId();
            String systemUserId = EventHandlerChainCreateDbInstance.getSystemUserId();
            String acctNumber = null;
            try {
                acctNumber = Accounts.lookupUserById((String)userId).getAccountNumber();
            }
            catch (AuthException ex) {
                throw new EventHandlerException("Failed to lookup system user", (Throwable)ex);
            }
            String asgName = CreateAutoScalingGroup.getAutoscalingGroupName(acctNumber, evt.getDbInstanceIdentifier());
            try {
                DescribeAutoScalingGroupsResponseType resp = AutoScalingClient.getInstance().describeAutoScalingGroups(null, (List)Lists.newArrayList((Object[])new String[]{asgName}));
                ArrayList groups = resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
                for (AutoScalingGroupType asg : groups) {
                    if (!asg.getAutoScalingGroupName().contains(asgName)) continue;
                    asgFound = true;
                    break;
                }
            }
            catch (Exception ex) {
                asgFound = false;
            }
            if (asgFound) {
                throw new EventHandlerException("Existing autoscaling group (" + asgName + ") found");
            }
            String emi = DatabaseServerProperties.IMAGE;
            List images = null;
            try {
                images = Ec2Client.getInstance().describeImages(systemUserId, (List)Lists.newArrayList((Object[])new String[]{emi}));
                if (images == null || images.size() <= 0 || !((ImageDetails)images.get(0)).getImageId().toLowerCase().equals(emi.toLowerCase())) {
                    throw new EventHandlerException("No such EMI is found: " + emi);
                }
            }
            catch (EventHandlerException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to validate the db server EMI", (Throwable)ex);
            }
            String volumeId = DatabaseServerProperties.VOLUME;
            List volumes = null;
            try {
                volumes = Ec2Client.getInstance().describeVolumes(systemUserId, (List)Lists.newArrayList((Object[])new String[]{volumeId}));
                if (volumes == null || volumes.size() <= 0 || !((Volume)volumes.get(0)).getVolumeId().toLowerCase().equals(volumeId.toLowerCase())) {
                    throw new EventHandlerException("No such volume id is found: " + volumeId);
                }
                if (!"available".equals(((Volume)volumes.get(0)).getStatus())) {
                    throw new EventHandlerException("Volume is not available");
                }
            }
            catch (EventHandlerException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to validate the db server volume ID", (Throwable)ex);
            }
            List clusters = null;
            try {
                clusters = Ec2Client.getInstance().describeAvailabilityZones(null, true);
            }
            catch (Exception ex) {
                throw new EventHandlerException("failed to validate the zones", (Throwable)ex);
            }
            String instanceType = DatabaseServerProperties.INSTANCE_TYPE;
            int numVm = 1;
            boolean resourceAvailable = false;
            for (ClusterInfoType cluster : clusters) {
                int capacity = this.findAvailableResources(clusters, cluster.getZoneName(), instanceType);
                if (numVm > capacity) continue;
                resourceAvailable = true;
                break;
            }
            if (!resourceAvailable) {
                throw new EventHandlerException("not enough resource in the cloud");
            }
            String keyName = DatabaseServerProperties.KEYNAME;
            if (keyName != null && keyName.length() > 0) {
                try {
                    List keypairs = Ec2Client.getInstance().describeKeyPairs(systemUserId, (List)Lists.newArrayList((Object[])new String[]{keyName}));
                    if (keypairs == null || keypairs.size() <= 0 || !((DescribeKeyPairsResponseItemType)keypairs.get(0)).getKeyName().equals(keyName)) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    throw new EventHandlerException(String.format("The configured keyname %s is not found", DatabaseServerProperties.KEYNAME));
                }
            }
        }

        private int findAvailableResources(List<ClusterInfoType> clusters, String zoneName, String instanceType) {
            block3: for (int i = 0; i < clusters.size(); ++i) {
                ClusterInfoType cc = clusters.get(i);
                if (!zoneName.equals(cc.getZoneName())) continue;
                for (int j = i + 1; j < clusters.size(); ++j) {
                    String state;
                    String[] tokens;
                    ClusterInfoType candidate = clusters.get(j);
                    if (candidate.getZoneName() == null || !candidate.getZoneName().toLowerCase().contains(instanceType.toLowerCase()) || (tokens = (state = candidate.getZoneState()).split("/")) == null || tokens.length <= 0) continue;
                    try {
                        String strNum = tokens[0].trim().replaceFirst("0+", "");
                        if (strNum.length() <= 0) {
                            strNum = "0";
                        }
                        return Integer.parseInt(strNum);
                    }
                    catch (NumberFormatException ex) {
                        break block3;
                    }
                    catch (Exception ex) {
                        break block3;
                    }
                }
                break;
            }
            return Integer.MAX_VALUE;
        }

        public void rollback() {
        }
    }
}

