/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.database.activities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.Instance;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.TagDescription;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DatabaseInfo;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.cloudwatch.common.CloudWatchBackend;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.component.id.Reporting;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.database.activities.DatabaseEventListeners;
import com.eucalyptus.database.activities.DatabaseUserEvent;
import com.eucalyptus.database.activities.DeleteDBInstanceEvent;
import com.eucalyptus.database.activities.DisableDBInstanceEvent;
import com.eucalyptus.database.activities.EnableDBInstanceEvent;
import com.eucalyptus.database.activities.EventHandlerChainEnableVmDatabase;
import com.eucalyptus.database.activities.NewDBInstanceEvent;
import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.resources.client.AutoScalingClient;
import com.eucalyptus.resources.client.Ec2Client;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.DNSProperties;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.HostSpecifier;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.util.StringUtils;

@ConfigurableClass(root="services.database.worker", description="Parameters controlling database information.", singleton=true)
public class DatabaseServerProperties {
    private static Logger LOG = Logger.getLogger(DatabaseServerProperties.class);
    @ConfigurableField(displayName="configured", description="Configure DB service so a VM can be launched. If something goes south with the service thereis a chance that setting it to false and back to true would solve issues", initial="false", readonly=false, type=ConfigurableFieldType.BOOLEAN, changeListener=EnabledChangeListener.class)
    public static boolean CONFIGURED = false;
    @ConfigurableField(displayName="image", description="EMI containing database server", initial="NULL", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=EmiChangeListener.class)
    public static String IMAGE = "NULL";
    @ConfigurableField(displayName="volume", description="volume containing database files", initial="NULL", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=VolumeChangeListener.class)
    public static String VOLUME = "NULL";
    @ConfigurableField(displayName="instance_type", description="instance type for database server", initial="m1.small", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=InstanceTypeChangeListener.class)
    public static String INSTANCE_TYPE = "m1.small";
    @ConfigurableField(displayName="availability_zones", description="availability zones for database server", initial="", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=AvailabilityZonesChangeListener.class)
    public static String AVAILABILITY_ZONES = "";
    @ConfigurableField(displayName="keyname", description="keyname to use when debugging database server", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=KeyNameChangeListener.class)
    public static String KEYNAME = null;
    @ConfigurableField(displayName="ntp_server", description="address of the NTP server used by database server", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=NTPServerChangeListener.class)
    public static String NTP_SERVER = null;
    @ConfigurableField(displayName="expiration_days", description="days after which the VMs expire", readonly=false, initial="180", type=ConfigurableFieldType.KEYVALUE, changeListener=VMExpirationDaysChangeListener.class)
    public static String EXPIRATION_DAYS = "180";
    @ConfigurableField(displayName="init_script", description="bash script that will be executed before service configuration and start up", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=InitScriptChangeListener.class)
    public static String INIT_SCRIPT = null;
    public static final String DEFAULT_LAUNCHER_TAG = "euca-internal-db-servers";
    private static AtomicBoolean launchLock = new AtomicBoolean();
    private static final String DB_INSTANCE_IDENTIFIER = "postgresql";
    private static final int DB_PORT = 5432;
    private static final String CONFIG_COMMMENT = "#System generated DB worker config";
    private static final String PASSWORD_PROPERTY = "master_password_encrypted";
    private static final String CERT_PROPERTY = "server_cert_arn";
    static final Set<String> configuredZones = Sets.newHashSet();

    public static String getCredentialsString() {
        String credStr = String.format("euca-%s:%s;", B64.standard.encString((String)"setup-credential"), EXPIRATION_DAYS);
        return credStr;
    }

    private static void onPropertyChange(String emi, String volumeId, String instanceType, String keyname, String ntpServers, String logServer, String logServerPort, String initScript) throws EucalyptusCloudException {
        block55: {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabled(Eucalyptus.class)) {
                return;
            }
            if (emi != null) {
                try {
                    List images = Ec2Client.getInstance().describeImages(null, (List)Lists.newArrayList((Object[])new String[]{emi}));
                    if (images == null || images.size() <= 0) {
                        throw new EucalyptusCloudException("No such EMI is found in the system");
                    }
                    if (!((ImageDetails)images.get(0)).getImageId().toLowerCase().equals(emi.toLowerCase())) {
                        throw new EucalyptusCloudException("No such EMI is found in the system");
                    }
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Failed to verify EMI in the system");
                }
            }
            if (volumeId != null) {
                if (!volumeId.toLowerCase().startsWith("vol-")) {
                    throw new EucalyptusCloudException("No such volume is found");
                }
                try {
                    List volumes = Ec2Client.getInstance().describeVolumes(null, (List)Lists.newArrayList((Object[])new String[]{volumeId}));
                    if (!volumeId.equals(((Volume)volumes.get(0)).getVolumeId()) || !"available".equals(((Volume)volumes.get(0)).getStatus())) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("No such volume id is found");
                }
            }
            if (instanceType != null) {
                // empty if block
            }
            if (keyname != null && !keyname.equals("")) {
                try {
                    List keypairs = Ec2Client.getInstance().describeKeyPairs(null, (List)Lists.newArrayList((Object[])new String[]{keyname}));
                    if (keypairs == null || keypairs.size() <= 0) {
                        throw new EucalyptusCloudException("No such keypair is found in the system");
                    }
                    if (!((DescribeKeyPairsResponseItemType)keypairs.get(0)).getKeyName().equals(keyname)) {
                        throw new EucalyptusCloudException("No such keypair is found in the system");
                    }
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Failed to verify the keyname in the system");
                }
            }
            if (ntpServers != null) {
                // empty if block
            }
            if (emi != null && emi.length() > 0 || instanceType != null && instanceType.length() > 0 || keyname != null && keyname.length() > 0 || ntpServers != null && ntpServers.length() > 0 || logServer != null && logServer.length() > 0 || (logServerPort != null && logServerPort.length() > 0) | initScript != null) {
                String asgName = null;
                LOG.warn((Object)"Changing launch configuration");
                try {
                    List tags = AutoScalingClient.getInstance().describeAutoScalingTags(null);
                    for (TagDescription tag : tags) {
                        if (!DEFAULT_LAUNCHER_TAG.equals(tag.getValue())) continue;
                        asgName = tag.getResourceId();
                        break;
                    }
                }
                catch (Exception ex) {
                    return;
                }
                if (asgName == null) {
                    return;
                }
                try {
                    String newKeyname;
                    AutoScalingGroupType asgType = null;
                    try {
                        DescribeAutoScalingGroupsResponseType resp = AutoScalingClient.getInstance().describeAutoScalingGroups(null, (List)Lists.newArrayList((Object[])new String[]{asgName}));
                        if (resp.getDescribeAutoScalingGroupsResult() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().size() > 0) {
                            asgType = (AutoScalingGroupType)resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().get(0);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("can't find autoscaling group named " + asgName));
                        return;
                    }
                    if (asgType == null) break block55;
                    String lcName = asgType.getLaunchConfigurationName();
                    LaunchConfigurationType lc = AutoScalingClient.getInstance().describeLaunchConfiguration(null, lcName);
                    String tmpLaunchConfigName = null;
                    while ((tmpLaunchConfigName = String.format("lc-euca-internal-db-%s", UUID.randomUUID().toString().substring(0, 8))).equals(asgType.getLaunchConfigurationName())) {
                    }
                    String newEmi = emi != null ? emi : lc.getImageId();
                    String newType = instanceType != null ? instanceType : lc.getInstanceType();
                    String string = newKeyname = keyname != null ? keyname : lc.getKeyName();
                    if (lc.getUserData() == null || lc.getUserData().length() < 0) {
                        throw new EucalyptusCloudException("ASG group for internal-db has invalid user data");
                    }
                    String newUserdata = new String(Base64.decode((byte[])lc.getUserData().getBytes()));
                    String encryptedPasword = null;
                    String serverCertArn = null;
                    int start = newUserdata.indexOf(CONFIG_COMMMENT);
                    if (start < 0) {
                        throw new EucalyptusCloudException("ASG group for internal-db has invalid user data");
                    }
                    int i = newUserdata.indexOf(PASSWORD_PROPERTY, start);
                    int j = newUserdata.indexOf("\n", i);
                    encryptedPasword = newUserdata.substring(i + PASSWORD_PROPERTY.length() + 1, j);
                    i = newUserdata.indexOf(CERT_PROPERTY, start);
                    j = newUserdata.indexOf("\n", i);
                    serverCertArn = newUserdata.substring(i + CERT_PROPERTY.length() + 1, j);
                    if (volumeId != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", DatabaseServerProperties.getCredentialsString(), DatabaseServerProperties.getServerUserData(volumeId, NTP_SERVER, INIT_SCRIPT, encryptedPasword, serverCertArn)));
                    }
                    if (initScript != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", DatabaseServerProperties.getCredentialsString(), DatabaseServerProperties.getServerUserData(VOLUME, NTP_SERVER, INIT_SCRIPT, encryptedPasword, serverCertArn)));
                    }
                    if (ntpServers != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", DatabaseServerProperties.getCredentialsString(), DatabaseServerProperties.getServerUserData(VOLUME, ntpServers, INIT_SCRIPT, encryptedPasword, serverCertArn)));
                    }
                    if (logServer != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", DatabaseServerProperties.getCredentialsString(), DatabaseServerProperties.getServerUserData(VOLUME, NTP_SERVER, INIT_SCRIPT, encryptedPasword, serverCertArn)));
                    }
                    if (logServerPort != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", DatabaseServerProperties.getCredentialsString(), DatabaseServerProperties.getServerUserData(VOLUME, NTP_SERVER, INIT_SCRIPT, encryptedPasword, serverCertArn)));
                    }
                    try {
                        AutoScalingClient.getInstance().createLaunchConfiguration(null, newEmi, newType, lc.getIamInstanceProfile(), tmpLaunchConfigName, (String)lc.getSecurityGroups().getMember().get(0), newKeyname, newUserdata);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to create temporary launch config", (Throwable)ex);
                        throw new EucalyptusCloudException("failed to create temporary launch config", (Throwable)ex);
                    }
                    try {
                        AutoScalingClient.getInstance().updateAutoScalingGroup(null, asgName, null, asgType.getDesiredCapacity().intValue(), tmpLaunchConfigName);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to update the autoscaling group", (Throwable)ex);
                        throw new EucalyptusCloudException("failed to update the autoscaling group", (Throwable)ex);
                    }
                    try {
                        AutoScalingClient.getInstance().deleteLaunchConfiguration(null, asgType.getLaunchConfigurationName());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to delete the old launch configuration", (Throwable)ex);
                    }
                    try {
                        AutoScalingClient.getInstance().createLaunchConfiguration(null, newEmi, newType, lc.getIamInstanceProfile(), asgType.getLaunchConfigurationName(), (String)lc.getSecurityGroups().getMember().get(0), newKeyname, newUserdata);
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("unable to create the new launch config", (Throwable)ex);
                    }
                    try {
                        AutoScalingClient.getInstance().updateAutoScalingGroup(null, asgName, null, asgType.getDesiredCapacity().intValue(), asgType.getLaunchConfigurationName());
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("failed to update the autoscaling group", (Throwable)ex);
                    }
                    try {
                        AutoScalingClient.getInstance().deleteLaunchConfiguration(null, tmpLaunchConfigName);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to delete the temporary launch configuration", (Throwable)ex);
                    }
                    try {
                        List images = Ec2Client.getInstance().describeImages(null, (List)Lists.newArrayList((Object[])new String[]{emi}));
                        for (ResourceTag tag : ((ImageDetails)images.get(0)).getTagSet()) {
                            AutoScalingClient.getInstance().createOrUpdateAutoscalingTags(null, tag.getKey(), tag.getValue(), asgName);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to propogate tags from image to ASG", (Throwable)ex);
                    }
                    LOG.debug((Object)String.format("autoscaling group '%s' was updated", asgName));
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Unable to update the autoscaling group", (Throwable)ex);
                }
            }
        }
    }

    static String getServerUserData(String volumeId, String ntpServer, String initScript, String masterPasswordEnc, String serverCertArn) {
        HashMap<String, String> kvMap = new HashMap<String, String>();
        if (volumeId != null) {
            kvMap.put("volume_id", volumeId);
        }
        if (ntpServer != null) {
            kvMap.put("ntp_server", ntpServer);
        }
        kvMap.put(PASSWORD_PROPERTY, masterPasswordEnc);
        kvMap.put(CERT_PROPERTY, serverCertArn);
        kvMap.put("euare_service_url", String.format("euare.%s", DNSProperties.DOMAIN));
        kvMap.put("compute_service_url", String.format("compute.%s", DNSProperties.DOMAIN));
        StringBuilder sb = new StringBuilder("#!/bin/bash").append("\n");
        if (initScript != null && initScript.length() > 0) {
            sb.append(initScript);
        }
        sb.append("\n");
        sb.append(CONFIG_COMMMENT);
        sb.append("\n");
        sb.append("mkdir -p /etc/eucalyptus-database-server/\n");
        sb.append("yum -y --disablerepo \\* --enablerepo eucalyptus-service-image install eucalyptus-database-server\n");
        sb.append("echo \"");
        for (String key : kvMap.keySet()) {
            String value = (String)kvMap.get(key);
            sb.append(String.format("\n%s=%s", key, value));
        }
        sb.append("\n\" > /etc/eucalyptus-database-server/database-server.conf");
        sb.append("\ntouch /var/lib/eucalyptus-database-server/ntp.lock");
        sb.append("\nchown -R eucalyptus:eucalyptus /etc/eucalyptus-database-server");
        sb.append("\nservice eucalyptus-database-server start");
        return sb.toString();
    }

    public static List<String> listConfiguredZones() throws Exception {
        if (configuredZones.size() <= 0) {
            ArrayList allZones = Lists.newArrayList();
            try {
                List clusters = Ec2Client.getInstance().describeAvailabilityZones(null, false);
                for (ClusterInfoType c : clusters) {
                    allZones.add(c.getZoneName());
                }
            }
            catch (Exception ex) {
                throw new Exception("failed to lookup availability zones", ex);
            }
            if (AVAILABILITY_ZONES != null && AVAILABILITY_ZONES.length() > 0) {
                if (AVAILABILITY_ZONES.contains(",")) {
                    String[] tokens;
                    for (String zone : tokens = AVAILABILITY_ZONES.split(",")) {
                        if (!allZones.contains(zone)) continue;
                        configuredZones.add(zone);
                    }
                } else if (allZones.contains(AVAILABILITY_ZONES)) {
                    configuredZones.add(AVAILABILITY_ZONES);
                }
            } else {
                configuredZones.addAll(allZones);
            }
        }
        return Lists.newArrayList(configuredZones);
    }

    public static class RemoteDatabaseChecker
    implements EventListener<ClockTick> {
        static final int CHECK_EVERY_SECONDS = 60;
        static Date lastChecked = null;

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new RemoteDatabaseChecker());
        }

        public void fireEvent(ClockTick event) {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabledLocally(Eucalyptus.class)) {
                return;
            }
            if (Topology.isEnabled(Reporting.class)) {
                return;
            }
            if (lastChecked == null) {
                lastChecked = new Date();
            } else {
                int elapsedSec = (int)((double)(new Date().getTime() - lastChecked.getTime()) / 1000.0);
                if (elapsedSec < 60) {
                    return;
                }
                lastChecked = new Date();
            }
            try {
                ConfigurableProperty hostProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlyhost");
                if ("localhost".equals(hostProp.getValue())) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            ArrayList instances = Lists.newArrayList();
            String asgName = null;
            try {
                List tags = AutoScalingClient.getInstance().describeAutoScalingTags(null);
                for (TagDescription tag : tags) {
                    if (!DatabaseServerProperties.DEFAULT_LAUNCHER_TAG.equals(tag.getValue())) continue;
                    asgName = tag.getResourceId();
                    break;
                }
            }
            catch (Exception ex) {
                return;
            }
            if (asgName == null) {
                return;
            }
            AutoScalingGroupType asgType = null;
            try {
                DescribeAutoScalingGroupsResponseType resp = AutoScalingClient.getInstance().describeAutoScalingGroups(null, (List)Lists.newArrayList((Object[])new String[]{asgName}));
                if (resp.getDescribeAutoScalingGroupsResult() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().size() > 0) {
                    asgType = (AutoScalingGroupType)resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().get(0);
                }
                if (asgType.getInstances() != null && asgType.getInstances().getMember() != null) {
                    instances.addAll(Collections2.transform((Collection)asgType.getInstances().getMember(), (Function)new Function<Instance, String>(){

                        public String apply(Instance arg0) {
                            return arg0.getInstanceId();
                        }
                    }));
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Can't find autoscaling group named " + asgName));
                return;
            }
            ArrayList runningIps = Lists.newArrayList();
            try {
                List ec2Instances = Ec2Client.getInstance().describeInstances(null, (List)instances);
                for (RunningInstancesItemType inst : ec2Instances) {
                    if (!"running".equals(inst.getStateName())) continue;
                    runningIps.add(inst.getIpAddress());
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Can't get the ip address of the running instance", (Throwable)ex);
                return;
            }
            if (runningIps.size() > 1) {
                LOG.warn((Object)"There are more than 1 instances running remote databases.");
            } else if (runningIps.size() == 0) {
                return;
            }
            String instanceIp = (String)runningIps.get(0);
            if (instanceIp == null || instanceIp.length() <= 0) {
                LOG.warn((Object)"Invalid IP address for the instance running remote databases.");
                return;
            }
            try {
                ConfigurableProperty hostProp = PropertyDirectory.getPropertyEntry((String)"services.database.appendonlyhost");
                String curHost = hostProp.getValue();
                if ("localhost".equals(curHost)) {
                    return;
                }
                if (!instanceIp.equals(curHost)) {
                    hostProp.setValue(instanceIp);
                    LOG.info((Object)("Updated the property services.database.appendonlyhost to " + instanceIp));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to update the property: services.database.appendonlyhost", (Throwable)ex);
            }
        }
    }

    public static class InitScriptChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                if (t.getValue() != null && !t.getValue().equals(newValue)) {
                    DatabaseServerProperties.onPropertyChange(null, null, null, null, null, null, null, newValue);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change init script", (Throwable)e);
            }
        }
    }

    public static class VMExpirationDaysChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                int newExp = Integer.parseInt(newValue);
                if (newExp <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("The value must be number type and bigger than 0");
            }
        }
    }

    public static class NTPServerChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String) {
                    if (newValue.contains(",")) {
                        String[] addresses = newValue.split(",");
                        if (addresses.length - 1 != StringUtils.countOccurrencesOf((String)newValue, (String)",")) {
                            throw new EucalyptusCloudException("Invalid address");
                        }
                        for (String address : addresses) {
                            if (HostSpecifier.isValid((String)String.format("%s.com", address))) continue;
                            throw new EucalyptusCloudException("Invalid address");
                        }
                    } else {
                        String address = newValue;
                        if (address != null && !address.equals("") && !HostSpecifier.isValid((String)String.format("%s.com", address))) {
                            throw new EucalyptusCloudException("Invalid address");
                        }
                    }
                } else {
                    throw new EucalyptusCloudException("Address is not string type");
                }
                DatabaseServerProperties.onPropertyChange(null, null, null, null, newValue, null, null, null);
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change ntp server address", (Throwable)e);
            }
        }
    }

    public static class AvailabilityZonesChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                String zones = (String)newValue;
                if (zones.length() == 0) {
                    return;
                }
                ArrayList availabilityZones = Lists.newArrayList();
                if (zones.contains(",")) {
                    String[] tokens = zones.split(",");
                    if (tokens.length - 1 != StringUtils.countOccurrencesOf((String)zones, (String)",")) {
                        throw new EucalyptusCloudException("Invalid availability zones");
                    }
                    for (String zone : tokens) {
                        availabilityZones.add(zone);
                    }
                } else {
                    availabilityZones.add(zones);
                }
                try {
                    List clusters = Ec2Client.getInstance().describeAvailabilityZones(null, false);
                    ArrayList clusterNames = Lists.newArrayList();
                    for (ClusterInfoType cluster : clusters) {
                        clusterNames.add(cluster.getZoneName());
                    }
                    for (String zone : availabilityZones) {
                        if (clusterNames.contains(zone)) continue;
                        throw new ConfigurablePropertyException(zone + " is not found in availability zones");
                    }
                }
                catch (Exception ex) {
                    throw new ConfigurablePropertyException("Faield to check availability zones", (Throwable)ex);
                }
            }
            catch (ConfigurablePropertyException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("Failed to check availability zones", (Throwable)ex);
            }
        }
    }

    public static class KeyNameChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && t.getValue() != null && !t.getValue().equals(newValue)) {
                    DatabaseServerProperties.onPropertyChange(null, null, null, (String)newValue, null, null, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change key name", (Throwable)e);
            }
        }
    }

    public static class InstanceTypeChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String) {
                    if (newValue == null || ((String)newValue).equals("")) {
                        throw new EucalyptusCloudException("Instance type cannot be unset");
                    }
                    if (t.getValue() != null && !t.getValue().equals(newValue)) {
                        DatabaseServerProperties.onPropertyChange(null, null, (String)newValue, null, null, null, null, null);
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change instance type", (Throwable)e);
            }
        }
    }

    public static class VolumeChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && t.getValue() != null && !t.getValue().equals(newValue) && ((String)newValue).length() > 0) {
                    DatabaseServerProperties.onPropertyChange(null, (String)newValue, null, null, null, null, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change VOLUME ID", (Throwable)e);
            }
        }
    }

    public static class EmiChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && t.getValue() != null && !t.getValue().equals(newValue) && ((String)newValue).length() > 0) {
                    DatabaseServerProperties.onPropertyChange((String)newValue, null, null, null, null, null, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change EMI ID", (Throwable)e);
            }
        }
    }

    public static class LogServerPortChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                Integer.parseInt(newValue);
                if (t.getValue() != null && !t.getValue().equals(newValue) && newValue.length() > 0) {
                    DatabaseServerProperties.onPropertyChange(null, null, null, null, null, null, newValue, null);
                }
            }
            catch (NumberFormatException ex) {
                throw new ConfigurablePropertyException("Invalid number");
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change log server port to " + newValue, (Throwable)e);
            }
        }
    }

    public static class LogServerAddressChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                InetAddress.getByName(newValue);
                if (t.getValue() != null && !t.getValue().equals(newValue) && newValue.length() > 0) {
                    DatabaseServerProperties.onPropertyChange(null, null, null, null, null, newValue, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change log server to " + newValue, (Throwable)e);
            }
        }
    }

    public static class EnabledChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            block9: {
                try {
                    if ("false".equals(((String)newValue).toLowerCase()) && "true".equals(t.getValue())) {
                        if (!launchLock.compareAndSet(false, true)) {
                            throw new ConfigurablePropertyException("the property is currently being updated");
                        }
                        DisableDBRunner disableDbRun = new DisableDBRunner();
                        Threads.enqueue(Eucalyptus.class, DatabaseServerProperties.class, (Callable)disableDbRun);
                        break block9;
                    }
                    if (!"true".equals(((String)newValue).toLowerCase()) || !"false".equals(t.getValue())) break block9;
                    if (!launchLock.compareAndSet(false, true)) {
                        throw new ConfigurablePropertyException("the property is currently being updated");
                    }
                    NewDBRunner newDbRun = new NewDBRunner();
                    Threads.enqueue(Eucalyptus.class, DatabaseServerProperties.class, (Callable)newDbRun);
                }
                catch (Exception e) {
                    throw new ConfigurablePropertyException("Could not toggle database server", (Throwable)e);
                }
            }
        }
    }

    private static class DestroyDBRunner
    implements Callable<Boolean> {
        private DestroyDBRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                DeleteDBInstanceEvent evt = new DeleteDBInstanceEvent(Accounts.lookupSystemAdmin().getUserId());
                evt.setDbInstanceIdentifier(DatabaseServerProperties.DB_INSTANCE_IDENTIFIER);
                DatabaseEventListeners.getInstance().fire(evt);
            }
            catch (Exception e) {
                LOG.error((Object)"failed to handle DeleteDbInstanceEvent", (Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                launchLock.set(false);
            }
            LOG.info((Object)"Database VM is destroyed");
            return true;
        }
    }

    private static class DisableDBRunner
    implements Callable<Boolean> {
        private DisableDBRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                DisableDBInstanceEvent evt = new DisableDBInstanceEvent(Accounts.lookupSystemAdmin().getUserId());
                evt.setDbInstanceIdentifier(DatabaseServerProperties.DB_INSTANCE_IDENTIFIER);
                DatabaseEventListeners.getInstance().fire(evt);
            }
            catch (Exception e) {
                LOG.error((Object)"failed to disable remote database", (Throwable)e);
                ConfigurableProperty prop = PropertyDirectory.getPropertyEntry((String)"services.database.worker.configured");
                if (prop != null) {
                    prop.setValue("true");
                }
                Boolean bl = false;
                return bl;
            }
            finally {
                launchLock.set(false);
            }
            LOG.info((Object)"Remote database is disabled");
            return true;
        }
    }

    private static class NewDBRunner
    implements Callable<Boolean> {
        private NewDBRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                DatabaseUserEvent evt;
                String masterPassword = DatabaseInfo.getDatabaseInfo().getAppendOnlyPassword();
                if (masterPassword == null || masterPassword.length() <= 0) {
                    masterPassword = Crypto.generateAlphanumericId((int)8, (String)"").toLowerCase();
                }
                String masterUserName = "eucalyptus";
                boolean vmCreated = false;
                try {
                    evt = new NewDBInstanceEvent(Accounts.lookupSystemAdmin().getUserId());
                    ((NewDBInstanceEvent)evt).setMasterUserName("eucalyptus");
                    ((NewDBInstanceEvent)evt).setMasterUserPassword(masterPassword);
                    ((NewDBInstanceEvent)evt).setDbInstanceIdentifier(DatabaseServerProperties.DB_INSTANCE_IDENTIFIER);
                    ((NewDBInstanceEvent)evt).setPort(5432);
                    DatabaseEventListeners.getInstance().fire(evt);
                    vmCreated = true;
                }
                catch (Exception e) {
                    LOG.error((Object)"failed to create a database vm", (Throwable)e);
                    vmCreated = false;
                }
                if (!vmCreated) {
                    Boolean e = false;
                    return e;
                }
                try {
                    evt = new EnableDBInstanceEvent(Accounts.lookupSystemAdmin().getUserId());
                    ((EnableDBInstanceEvent)evt).setMasterUserName("eucalyptus");
                    ((EnableDBInstanceEvent)evt).setMasterUserPassword(masterPassword);
                    ((EnableDBInstanceEvent)evt).setDbInstanceIdentifier(DatabaseServerProperties.DB_INSTANCE_IDENTIFIER);
                    ((EnableDBInstanceEvent)evt).setPort(5432);
                    DatabaseEventListeners.getInstance().fire(evt);
                }
                catch (Exception e) {
                    LOG.error((Object)"failed to enable remote database", (Throwable)e);
                    throw e;
                }
            }
            catch (Exception ex) {
                Boolean bl = false;
                return bl;
            }
            finally {
                launchLock.set(false);
            }
            LOG.info((Object)"New remote database is created");
            return true;
        }
    }

    public static abstract class DatabaseServerPropertyBootstrapper
    extends Bootstrapper.Simple {
        public boolean check() throws Exception {
            if ("localhost".equals(DatabaseInfo.getDatabaseInfo().getAppendOnlyHost())) {
                return true;
            }
            String vmHost = null;
            try {
                DatabaseInfo dbInfo = DatabaseInfo.getDatabaseInfo();
                vmHost = dbInfo.getAppendOnlyHost();
                String port = dbInfo.getAppendOnlyPort();
                String userName = dbInfo.getAppendOnlyUser();
                String password = dbInfo.getAppendOnlyPassword();
                String jdbcUrl = EventHandlerChainEnableVmDatabase.WaitOnDb.getJdbcUrlWithSsl(vmHost, Integer.parseInt(port));
                return EventHandlerChainEnableVmDatabase.WaitOnDb.pingDatabase(jdbcUrl, userName, password);
            }
            catch (Exception ex) {
                LOG.warn((Object)("Error pinging append-only database at " + vmHost));
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enable() throws Exception {
            Class<DatabaseServerPropertyBootstrapper> clazz = DatabaseServerPropertyBootstrapper.class;
            synchronized (DatabaseServerPropertyBootstrapper.class) {
                if (PersistenceContexts.remoteConnected()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                try {
                    Groovyness.run((String)"setup_persistence_remote.groovy");
                    LOG.info((Object)"Remote persistence contexts are initialized");
                }
                catch (Exception ex) {
                    LOG.error((Object)"Failed to setup remote persistence contexts", (Throwable)ex);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                return true;
            }
        }
    }

    @Provides(value=CloudWatchBackend.class)
    @RunDuring(value=Bootstrap.Stage.Final)
    @DependsLocal(value={CloudWatchBackend.class})
    public static class CloudWatchPropertyBootstrapper
    extends DatabaseServerPropertyBootstrapper {
    }

    @Provides(value=Reporting.class)
    @RunDuring(value=Bootstrap.Stage.Final)
    @DependsLocal(value={Reporting.class})
    public static class ReportingPropertyBootstrapper
    extends DatabaseServerPropertyBootstrapper {
    }
}

