/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.database.activities;

import com.eucalyptus.database.activities.DatabaseEvent;
import com.eucalyptus.database.activities.DeleteDBInstanceEvent;
import com.eucalyptus.database.activities.DisableDBInstanceEvent;
import com.eucalyptus.database.activities.EnableDBInstanceEvent;
import com.eucalyptus.database.activities.EventHandlerChains;
import com.eucalyptus.database.activities.NewDBInstanceEvent;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.resources.EventHandlerChainException;
import com.eucalyptus.resources.ResourceEvent;
import com.eucalyptus.util.Exceptions;
import org.apache.log4j.Logger;

public class DatabaseEventListeners {
    private static final Logger LOG = Logger.getLogger(DatabaseEventListeners.class);
    private static DatabaseEventListeners _instance = new DatabaseEventListeners();

    private DatabaseEventListeners() {
        DatabaseEventListener.register();
    }

    public static DatabaseEventListeners getInstance() {
        return _instance;
    }

    public void fire(DatabaseEvent evt) throws EventFailedException {
        ListenerRegistry.getInstance().fireThrowableEvent((Event)evt);
    }

    static enum DatabaseEventListener implements EventListener<DatabaseEvent>
    {
        NewDBInstance(NewDBInstanceEvent.class){

            public void fireEvent(DatabaseEvent event) {
                try {
                    EventHandlerChains.onNewDBInstance().execute((ResourceEvent)((NewDBInstanceEvent)event));
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
        ,
        DeleteDBInstance(DeleteDBInstanceEvent.class){

            public void fireEvent(DatabaseEvent event) {
                try {
                    EventHandlerChains.onDeleteDBInstance().execute((ResourceEvent)((DeleteDBInstanceEvent)event));
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
        ,
        EnableDBInstance(EnableDBInstanceEvent.class){

            public void fireEvent(DatabaseEvent event) {
                try {
                    EventHandlerChains.onEnableDBInstance().execute((ResourceEvent)((EnableDBInstanceEvent)event));
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        }
        ,
        DisableDBInstance(DisableDBInstanceEvent.class){

            public void fireEvent(DatabaseEvent event) {
                try {
                    EventHandlerChains.onDisableDBInstance().execute((ResourceEvent)((DisableDBInstanceEvent)event));
                }
                catch (EventHandlerChainException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        };

        private final Class<? extends DatabaseEvent> evtType;

        private DatabaseEventListener(Class<? extends DatabaseEvent> type) {
            this.evtType = type;
        }

        public static void register() {
            for (DatabaseEventListener listener : DatabaseEventListener.values()) {
                Listeners.register(listener.evtType, (EventListener)listener);
            }
        }
    }
}

