/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.upgrade;

import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.system.Ats;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import org.hibernate.ejb.EntityManagerFactoryImpl;

class UpgradeUtils {
    UpgradeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean transactionalForEntity(Class entityClass, Function<EntityManager, Boolean> callback) {
        String context = ((PersistenceContext)Ats.inClassHierarchy((Object)entityClass).get(PersistenceContext.class)).name();
        EntityManagerFactoryImpl entityManagerFactory = PersistenceContexts.getEntityManagerFactory((String)context);
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        boolean success = false;
        try {
            success = (Boolean)callback.apply((Object)entityManager);
        }
        finally {
            if (success && !transaction.getRollbackOnly()) {
                transaction.commit();
            } else {
                transaction.rollback();
            }
        }
        return success;
    }

    static Function<EntityManager, Boolean> dropTables(final List<String> dropTables) {
        return new Function<EntityManager, Boolean>(){

            public Boolean apply(final EntityManager entityManager) {
                return Iterables.all((Iterable)dropTables, (Predicate)new Predicate<String>(){

                    public boolean apply(String table) {
                        entityManager.createNativeQuery("drop table if exists " + table).executeUpdate();
                        return true;
                    }
                });
            }
        };
    }
}

