/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.units;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.google.common.base.CaseFormat;

@ConfigurableClass(root="reporting", description="Parameters controlling reporting units")
public class Units {
    @ConfigurableField(initial="DAYS", description="Default time unit")
    public static String DEFAULT_TIME_UNIT = "DAYS";
    @ConfigurableField(initial="GB", description="Default size unit")
    public static String DEFAULT_SIZE_UNIT = "GB";
    @ConfigurableField(initial="DAYS", description="Default size-time time unit (GB-days, etc)")
    public static String DEFAULT_SIZE_TIME_TIME_UNIT = "DAYS";
    @ConfigurableField(initial="GB", description="Default size-time size unit (GB-days, etc)")
    public static String DEFAULT_SIZE_TIME_SIZE_UNIT = "GB";
    private final TimeUnit timeUnit;
    private final SizeUnit sizeUnit;
    private final TimeUnit sizeTimeTimeUnit;
    private final SizeUnit sizeTimeSizeUnit;

    public static Units getDefaultDisplayUnits() {
        return new Units(TimeUnit.fromString(DEFAULT_TIME_UNIT, TimeUnit.DAYS), SizeUnit.fromString(DEFAULT_SIZE_UNIT, SizeUnit.GB), TimeUnit.fromString(DEFAULT_SIZE_TIME_TIME_UNIT, TimeUnit.DAYS), SizeUnit.fromString(DEFAULT_SIZE_TIME_SIZE_UNIT, SizeUnit.GB));
    }

    public Units() {
        this(Units.getDefaultDisplayUnits());
    }

    public Units(Units units) {
        this(units.getTimeUnit(), units.getSizeUnit(), units.getSizeTimeTimeUnit(), units.getSizeTimeSizeUnit());
    }

    public Units(TimeUnit timeUnit, SizeUnit sizeUnit, TimeUnit sizeTimeTimeUnit, SizeUnit sizeTimeSizeUnit) {
        this.timeUnit = timeUnit;
        this.sizeUnit = sizeUnit;
        this.sizeTimeTimeUnit = sizeTimeTimeUnit;
        this.sizeTimeSizeUnit = sizeTimeSizeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public SizeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public TimeUnit getSizeTimeTimeUnit() {
        return this.sizeTimeTimeUnit;
    }

    public SizeUnit getSizeTimeSizeUnit() {
        return this.sizeTimeSizeUnit;
    }

    public String toString() {
        return String.format("[timeUnit:%s,sizeUnit:%s,sizeTimeTimeUnit:%s,sizeTimeSizeUnit:%s]", new Object[]{this.timeUnit, this.sizeUnit, this.sizeTimeTimeUnit, this.sizeTimeSizeUnit});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sizeTimeSizeUnit == null ? 0 : this.sizeTimeSizeUnit.hashCode());
        result = 31 * result + (this.sizeTimeTimeUnit == null ? 0 : this.sizeTimeTimeUnit.hashCode());
        result = 31 * result + (this.sizeUnit == null ? 0 : this.sizeUnit.hashCode());
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Units other = (Units)obj;
        if (this.sizeTimeSizeUnit != other.sizeTimeSizeUnit) {
            return false;
        }
        if (this.sizeTimeTimeUnit != other.sizeTimeTimeUnit) {
            return false;
        }
        if (this.sizeUnit != other.sizeUnit) {
            return false;
        }
        return this.timeUnit == other.timeUnit;
    }

    public String labelForSizeTime() {
        return (Object)((Object)this.getSizeTimeSizeUnit()) + "-" + this.capitalize((Object)this.getSizeTimeTimeUnit());
    }

    public String labelForSize() {
        return this.getSizeUnit().toString();
    }

    public String labelForTime() {
        return this.capitalize((Object)this.getTimeUnit());
    }

    private String capitalize(Object item) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, item.toString());
    }
}

