/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.units;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum TimeUnit {
    MS(1L, "ms", "MILLIS", "MILLISECONDS"),
    SECS(TimeUnit.MS.factor * 1000L, "secs", "S", "SECONDS"),
    MINS(TimeUnit.SECS.factor * 60L, "mins", "M", "MINUTES"),
    HOURS(TimeUnit.MINS.factor * 60L, "hrs", "H", "HRS", "HOURS"),
    DAYS(TimeUnit.HOURS.factor * 24L, "days", "D"),
    YEARS(TimeUnit.DAYS.factor * 365L, "years", "Y");

    private final long factor;
    private final String str;
    private final List<String> aliases;

    private TimeUnit(long factor, String str, String ... alias) {
        this.factor = factor;
        this.str = str;
        this.aliases = ImmutableList.copyOf((Object[])alias);
    }

    public long getFactor() {
        return this.factor;
    }

    public String toString() {
        return this.str;
    }

    public static TimeUnit fromString(String value, TimeUnit fallback) {
        TimeUnit timeUnit = fallback;
        if (value != null) {
            String upperValue = value.toUpperCase();
            try {
                timeUnit = TimeUnit.valueOf(upperValue);
            }
            catch (IllegalArgumentException e) {
                for (TimeUnit unit : TimeUnit.values()) {
                    if (!unit.aliases.contains(upperValue)) continue;
                    timeUnit = unit;
                    break;
                }
            }
        }
        return timeUnit;
    }
}

