/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.units;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum SizeUnit {
    B(1L, "BYTES"),
    KB(1024L, new String[0]),
    MB(0x100000L, new String[0]),
    GB(0x40000000L, new String[0]),
    TB(0x10000000000L, new String[0]),
    PB(0x4000000000000L, new String[0]);

    private final long factor;
    private final List<String> aliases;

    private SizeUnit(long factor, String ... alias) {
        this.factor = factor;
        this.aliases = ImmutableList.copyOf((Object[])alias);
    }

    public long getFactor() {
        return this.factor;
    }

    public static SizeUnit fromString(String value, SizeUnit fallback) {
        SizeUnit sizeUnit = fallback;
        if (value != null) {
            String upperValue = value.toUpperCase();
            try {
                sizeUnit = SizeUnit.valueOf(upperValue);
            }
            catch (IllegalArgumentException e) {
                for (SizeUnit unit : SizeUnit.values()) {
                    if (!unit.aliases.contains(upperValue)) continue;
                    sizeUnit = unit;
                    break;
                }
            }
        }
        return sizeUnit;
    }
}

