/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.service.ws;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.reporting.service.ReportingErrorResponseType;
import com.eucalyptus.reporting.service.ReportingErrorType;
import com.eucalyptus.reporting.service.ReportingException;
import com.eucalyptus.reporting.service.ws.ReportingQueryBinding;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.LogUtil;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.api.MessagingException;
import org.mule.message.ExceptionMessage;

public class ReportingErrorHandler {
    private static final Logger log = Logger.getLogger(ReportingErrorHandler.class);
    private static final String INTERNAL_FAILURE = "InternalFailure";

    public void handle(ExceptionMessage exMsg) {
        EventRecord.here(ReportingErrorHandler.class, (EventType)EventType.MSG_REPLY, (String[])new String[]{exMsg.getPayload().getClass().getSimpleName()}).debug();
        log.trace((Object)("Caught exception while servicing: " + exMsg.getPayload()));
        Throwable exception = exMsg.getException();
        if (exception instanceof MessagingException && exception.getCause() instanceof EucalyptusCloudException) {
            try {
                String code;
                HttpResponseStatus status;
                EucalyptusCloudException cloudException = (EucalyptusCloudException)exception.getCause();
                BaseMessage payload = ReportingErrorHandler.parsePayload(exMsg.getPayload());
                ReportingErrorResponseType errorResp = new ReportingErrorResponseType();
                if (cloudException instanceof ReportingException) {
                    ReportingException reportingException = (ReportingException)cloudException;
                    status = reportingException.getStatus();
                    code = reportingException.getError();
                } else {
                    status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                    code = INTERNAL_FAILURE;
                }
                errorResp.setHttpStatus(status);
                errorResp.setCorrelationId(payload.getCorrelationId());
                errorResp.setRequestId(payload.getCorrelationId());
                ReportingErrorType error = new ReportingErrorType();
                error.setType("Receiver");
                error.setCode(code);
                error.setMessage(cloudException.getMessage());
                errorResp.getErrors().add(error);
                Contexts.response((BaseMessage)errorResp);
            }
            catch (PayloadParseException e) {
                log.error((Object)"Failed to parse payload ", e.getCause());
            }
        } else {
            log.error((Object)"Unable to handle exception", exception);
        }
    }

    private static BaseMessage parsePayload(Object payload) throws PayloadParseException {
        if (payload instanceof BaseMessage) {
            return (BaseMessage)payload;
        }
        if (payload instanceof String) {
            try {
                return (BaseMessage)BindingManager.getBinding((String)ReportingQueryBinding.REPORTING_DEFAULT_NAMESPACE).fromOM((String)payload);
            }
            catch (Exception e) {
                throw new PayloadParseException(e);
            }
        }
        return new EucalyptusErrorMessageType("ReportingErrorHandler", LogUtil.dumpObject((Object)payload));
    }

    private static final class PayloadParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PayloadParseException(Throwable cause) {
            super(cause);
        }
    }
}

