/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.service;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.id.Reporting;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.reporting.Period;
import com.eucalyptus.reporting.ReportGenerationFacade;
import com.eucalyptus.reporting.export.Export;
import com.eucalyptus.reporting.export.Import;
import com.eucalyptus.reporting.export.ReportingExport;
import com.eucalyptus.reporting.service.DeleteDataResultType;
import com.eucalyptus.reporting.service.DeleteReportDataResponseType;
import com.eucalyptus.reporting.service.DeleteReportDataType;
import com.eucalyptus.reporting.service.ExportDataResultType;
import com.eucalyptus.reporting.service.ExportReportDataResponseType;
import com.eucalyptus.reporting.service.ExportReportDataType;
import com.eucalyptus.reporting.service.GenerateReportResponseType;
import com.eucalyptus.reporting.service.GenerateReportResultType;
import com.eucalyptus.reporting.service.GenerateReportType;
import com.eucalyptus.reporting.service.ReportingException;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.Units;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.ws.handlers.RestfulMarshallingHandler;
import com.google.common.base.Objects;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ConfigurableClass(root="reporting", description="Reporting only parameters")
public class ReportingService {
    private static final Logger logger = Logger.getLogger(ReportingService.class);
    @ConfigurableField(initial="true", description="Set this to false to stop reporting from populating new data")
    public static Boolean DATA_COLLECTION_ENABLED = true;
    private static final int DISABLED_SERVICE_FAULT_ID = 1501;
    private static boolean alreadyFaulted = false;

    public static synchronized void faultDisableReportingServiceIfNecessary() {
        if (!alreadyFaulted) {
            Faults.forComponent(Reporting.class).havingId(1501).withVar("component", "reporting").log();
            alreadyFaulted = true;
        }
    }

    public ExportReportDataResponseType exportData(ExportReportDataType request) throws EucalyptusCloudException {
        ExportReportDataResponseType reply = (ExportReportDataResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        ReportingService.checkAuthorized();
        Date startDate = null;
        Date endDate = null;
        if (request.getStartDate() != null) {
            startDate = new Date(ReportingService.parseDate(request.getStartDate()));
        }
        if (request.getEndDate() != null) {
            endDate = new Date(ReportingService.parseDate(request.getEndDate()));
        }
        if (endDate != null && startDate != null && endDate.getTime() <= startDate.getTime()) {
            throw new ReportingException(HttpResponseStatus.BAD_REQUEST, "BadRequest", "Bad request: Invalid start or end date");
        }
        ReportingExport export = Export.export(startDate, endDate, request.isDependencies());
        reply.setResult(new ExportDataResultType(export));
        logger.info((Object)("Exporting report data from " + (String)Objects.firstNonNull((Object)request.getStartDate(), (Object)"-") + " to " + (String)Objects.firstNonNull((Object)request.getEndDate(), (Object)"-")));
        try {
            RestfulMarshallingHandler.streamResponse((Object)((Object)reply));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new ReportingException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalError", "Error exporting data");
        }
        return null;
    }

    public DeleteReportDataResponseType deleteData(DeleteReportDataType request) throws EucalyptusCloudException {
        DeleteReportDataResponseType reply = (DeleteReportDataResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        ReportingService.checkAuthorized();
        if (request.getEndDate() == null) {
            throw new ReportingException(HttpResponseStatus.BAD_REQUEST, "BadRequest", "Bad request: End date is required");
        }
        Date endDate = new Date(ReportingService.parseDate(request.getEndDate()));
        logger.info((Object)("Deleting report data up to " + request.getEndDate()));
        try {
            reply.setResult(new DeleteDataResultType(Import.deleteAll(endDate)));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new ReportingException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalError", "Error deleting report data");
        }
        return reply;
    }

    public GenerateReportResponseType generateReport(GenerateReportType request) throws EucalyptusCloudException {
        String reportData;
        GenerateReportResponseType reply = (GenerateReportResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        ReportingService.checkAuthorized();
        Period period = Period.defaultPeriod();
        long startTime = period.getBeginningMs();
        long endTime = period.getEndingMs();
        if (request.getStartDate() != null) {
            startTime = ReportingService.parseDate(request.getStartDate());
        }
        if (request.getEndDate() != null) {
            endTime = ReportingService.parseDate(request.getEndDate());
        }
        try {
            reportData = ReportGenerationFacade.generateReport((String)Objects.firstNonNull((Object)request.getType(), (Object)"instance"), (String)Objects.firstNonNull((Object)request.getFormat(), (Object)"html"), ReportingService.units(request), startTime, endTime);
        }
        catch (ReportGenerationFacade.ReportGenerationArgumentException e) {
            throw new ReportingException(HttpResponseStatus.BAD_REQUEST, "BadRequest", "Bad request: Invalid start or end date");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new ReportingException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalError", "Error generating report");
        }
        reply.setResult(new GenerateReportResultType(reportData));
        return reply;
    }

    private static Units units(GenerateReportType request) throws ReportGenerationFacade.ReportGenerationArgumentException {
        return new Units(TimeUnit.fromString(request.getTimeUnit(), TimeUnit.DAYS), SizeUnit.fromString(request.getSizeUnit(), SizeUnit.GB), TimeUnit.fromString(ReportingService.firstNonNullOrNull(request.getSizeTimeTimeUnit(), request.getTimeUnit()), TimeUnit.DAYS), SizeUnit.fromString(ReportingService.firstNonNullOrNull(request.getSizeTimeSizeUnit(), request.getSizeUnit()), SizeUnit.GB));
    }

    private static <T> T firstNonNullOrNull(T ... items) {
        T value = null;
        for (T item : items) {
            if (item == null) continue;
            value = item;
            break;
        }
        return value;
    }

    private static long parseDate(String date) throws ReportingException {
        try {
            return ReportingService.getDateFormat(date.endsWith("Z")).parse(date).getTime();
        }
        catch (ParseException e) {
            throw new ReportingException(HttpResponseStatus.BAD_REQUEST, "BadRequest", "Bad request: Invalid start or end date");
        }
    }

    private static DateFormat getDateFormat(boolean utc) {
        String format = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss" + (utc ? "'Z'" : ""));
        if (utc) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return dateFormat;
    }

    private static void checkAuthorized() throws ReportingException {
        Context ctx = Contexts.lookup();
        User requestUser = ctx.getUser();
        AuthContextSupplier requestUserSupplier = ctx.getAuthContext();
        if (!requestUser.isSystemUser() || !Permissions.isAuthorized((String)"eureport", (String)"", (String)"", null, (String)RestrictedTypes.getIamActionByMessageType(), (AuthContextSupplier)requestUserSupplier)) {
            throw new ReportingException(HttpResponseStatus.UNAUTHORIZED, "NotAuthorized", "Not authorized");
        }
    }
}

