/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.storage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.domain.ReportingAccountCrud;
import com.eucalyptus.reporting.domain.ReportingUserCrud;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.reporting.event.VolumeEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeEventStore;
import com.eucalyptus.reporting.service.ReportingService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class VolumeUsageEventListener
implements EventListener<VolumeEvent> {
    private static Logger LOG = Logger.getLogger(VolumeUsageEventListener.class);

    public static void register() {
        Listeners.register(VolumeEvent.class, (EventListener)new VolumeUsageEventListener());
    }

    public void fireEvent(@Nonnull VolumeEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection disabled....VolumeEvent discarded");
            return;
        }
        Preconditions.checkNotNull((Object)event, (Object)"Event is required");
        long timeInMs = this.getCurrentTimeMillis();
        try {
            User user = this.lookupUser(event.getOwner().getUserId());
            this.getReportingAccountCrud().createOrUpdateAccount(user.getAccount().getAccountNumber(), user.getAccount().getName());
            this.getReportingUserCrud().createOrUpdateUser(user.getUserId(), user.getAccount().getAccountNumber(), user.getName());
            ReportingVolumeEventStore eventStore = this.getReportingVolumeEventStore();
            switch ((VolumeEvent.VolumeAction)event.getActionInfo().getAction()) {
                case VOLUMECREATE: {
                    eventStore.insertCreateEvent(event.getUuid(), event.getVolumeId(), timeInMs, event.getOwner().getUserId(), event.getAvailabilityZone(), event.getSizeGB());
                    break;
                }
                case VOLUMEDELETE: {
                    eventStore.insertDeleteEvent(event.getUuid(), timeInMs);
                    break;
                }
                case VOLUMEATTACH: {
                    eventStore.insertAttachEvent(event.getUuid(), ((EventActionInfo.InstanceEventActionInfo)event.getActionInfo()).getInstanceUuid(), event.getSizeGB(), timeInMs);
                    break;
                }
                case VOLUMEDETACH: {
                    eventStore.insertDetachEvent(event.getUuid(), ((EventActionInfo.InstanceEventActionInfo)event.getActionInfo()).getInstanceUuid(), timeInMs);
                }
            }
        }
        catch (AuthException e) {
            LOG.error((Object)"Unable to fire volume reporting event.", e.getCause());
        }
    }

    protected ReportingAccountCrud getReportingAccountCrud() {
        return ReportingAccountCrud.getInstance();
    }

    protected ReportingUserCrud getReportingUserCrud() {
        return ReportingUserCrud.getInstance();
    }

    protected ReportingVolumeEventStore getReportingVolumeEventStore() {
        return ReportingVolumeEventStore.getInstance();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected User lookupUser(String userId) throws AuthException {
        return Accounts.lookupUserById((String)userId);
    }
}

