/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.storage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.domain.ReportingAccountCrud;
import com.eucalyptus.reporting.domain.ReportingUserCrud;
import com.eucalyptus.reporting.event.SnapShotEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotEventStore;
import com.eucalyptus.reporting.service.ReportingService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class SnapShotUsageEventListener
implements EventListener<SnapShotEvent> {
    private static Logger LOG = Logger.getLogger(SnapShotUsageEventListener.class);

    public static void register() {
        Listeners.register(SnapShotEvent.class, (EventListener)new SnapShotUsageEventListener());
    }

    public void fireEvent(@Nonnull SnapShotEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection disabled....SnapShotEvent discarded");
            return;
        }
        Preconditions.checkNotNull((Object)event, (Object)"Event is required");
        long timeInMs = this.getCurrentTimeMillis();
        try {
            User user = this.lookupUser(event.getUserId());
            this.getReportingAccountCrud().createOrUpdateAccount(user.getAccount().getAccountNumber(), user.getAccount().getName());
            this.getReportingUserCrud().createOrUpdateUser(user.getUserId(), user.getAccount().getAccountNumber(), user.getName());
            ReportingVolumeSnapshotEventStore eventStore = this.getReportingVolumeSnapshotEventStore();
            switch ((SnapShotEvent.SnapShotAction)event.getActionInfo().getAction()) {
                case SNAPSHOTCREATE: {
                    SnapShotEvent.CreateActionInfo eventActionInfo = (SnapShotEvent.CreateActionInfo)event.getActionInfo();
                    eventStore.insertCreateEvent(event.getUuid(), eventActionInfo.getVolumeUuid(), event.getSnapshotId(), timeInMs, event.getUserId(), eventActionInfo.getSize().intValue());
                    break;
                }
                case SNAPSHOTDELETE: {
                    eventStore.insertDeleteEvent(event.getUuid(), timeInMs);
                }
            }
        }
        catch (AuthException e) {
            LOG.error((Object)"Unable fire snap shot reporting event", e.getCause());
        }
    }

    protected ReportingAccountCrud getReportingAccountCrud() {
        return ReportingAccountCrud.getInstance();
    }

    protected ReportingUserCrud getReportingUserCrud() {
        return ReportingUserCrud.getInstance();
    }

    protected ReportingVolumeSnapshotEventStore getReportingVolumeSnapshotEventStore() {
        return ReportingVolumeSnapshotEventStore.getInstance();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected User lookupUser(String userId) throws AuthException {
        return Accounts.lookupUserById((String)userId);
    }
}

