/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.s3;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.domain.ReportingAccountCrud;
import com.eucalyptus.reporting.domain.ReportingUserCrud;
import com.eucalyptus.reporting.event.S3ObjectEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectEventStore;
import com.eucalyptus.reporting.service.ReportingService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class S3ObjectUsageEventListener
implements EventListener<S3ObjectEvent> {
    private static Logger LOG = Logger.getLogger(S3ObjectUsageEventListener.class);

    public static void register() {
        Listeners.register(S3ObjectEvent.class, (EventListener)new S3ObjectUsageEventListener());
    }

    public void fireEvent(@Nonnull S3ObjectEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection disabled....S3ObjectEvent discarded");
            return;
        }
        Preconditions.checkNotNull((Object)event, (Object)"Event is required");
        long timeInMs = this.getCurrentTimeMillis();
        try {
            User user = this.lookupUser(event.getOwnerUserId());
            this.getReportingAccountCrud().createOrUpdateAccount(user.getAccount().getAccountNumber(), user.getAccount().getName());
            this.getReportingUserCrud().createOrUpdateUser(user.getUserId(), user.getAccount().getAccountNumber(), user.getName());
            ReportingS3ObjectEventStore eventStore = this.getReportingS3ObjectEventStore();
            switch ((S3ObjectEvent.S3ObjectAction)event.getAction()) {
                case OBJECTCREATE: {
                    eventStore.insertS3ObjectCreateEvent(event.getBucketName(), event.getObjectKey(), this.toReportingVersion(event.getVersion()), event.getSize(), timeInMs, event.getOwnerUserId());
                    break;
                }
                case OBJECTDELETE: {
                    eventStore.insertS3ObjectDeleteEvent(event.getBucketName(), event.getObjectKey(), this.toReportingVersion(event.getVersion()), timeInMs);
                }
            }
        }
        catch (AuthException e) {
            LOG.error((Object)"Unable fire s3 object reporting event", e.getCause());
        }
    }

    protected ReportingAccountCrud getReportingAccountCrud() {
        return ReportingAccountCrud.getInstance();
    }

    protected ReportingUserCrud getReportingUserCrud() {
        return ReportingUserCrud.getInstance();
    }

    protected ReportingS3ObjectEventStore getReportingS3ObjectEventStore() {
        return ReportingS3ObjectEventStore.getInstance();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected User lookupUser(String userId) throws AuthException {
        return Accounts.lookupUserById((String)userId);
    }

    private String toReportingVersion(String version) {
        if ("null".equals(version)) {
            return null;
        }
        return version;
    }
}

