/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.instance;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.event.InstanceUsageEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceEventStore;
import com.eucalyptus.reporting.service.ReportingService;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;

@ConfigurableClass(root="reporting", description="Parameters controlling reporting")
public class InstanceUsageEventListener
implements EventListener<InstanceUsageEvent> {
    private static final Logger log = Logger.getLogger(InstanceUsageEventListener.class);
    @ConfigurableField(initial="15", description="How often the reporting system requests information from the cluster controller")
    public static long DEFAULT_WRITE_INTERVAL_MINS = 15L;
    private static final ScheduledExecutorService eventFlushTimer = Executors.newSingleThreadScheduledExecutor();
    private static AtomicBoolean busy = new AtomicBoolean(false);
    private static LinkedBlockingQueue<InstanceUsageEvent> eventQueue = new LinkedBlockingQueue();

    public static void register() {
        Listeners.register(InstanceUsageEvent.class, (EventListener)new InstanceUsageEventListener());
    }

    public void fireEvent(@Nonnull InstanceUsageEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            log.trace((Object)"Reporting service data collection disabled....InstanceUsageEvent discarded");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received instance usage event:" + event));
        }
        try {
            eventQueue.offer(event, DEFAULT_WRITE_INTERVAL_MINS + 1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            log.debug((Object)("Unable to queue usage event " + event), (Throwable)e);
        }
        if (!busy.get()) {
            this.flushEventQueue();
        }
    }

    private void flushEventQueue() {
        busy.set(true);
        Runnable safeRunner = new Runnable(){

            @Override
            public void run() {
                HashSet eventBatch = new HashSet();
                eventQueue.drainTo(eventBatch);
                for (InstanceUsageEvent event : eventBatch) {
                    InstanceUsageEventListener.this.insertEvent(event);
                }
                eventBatch.clear();
                busy.set(false);
            }
        };
        eventFlushTimer.schedule(safeRunner, DEFAULT_WRITE_INTERVAL_MINS, TimeUnit.MINUTES);
    }

    private void insertEvent(InstanceUsageEvent event) {
        try {
            ReportingInstanceEventStore eventStore = this.getReportingInstanceEventStore();
            eventStore.insertUsageEvent(event.getUuid(), event.getValueTimestamp(), event.getMetric(), event.getSequenceNum(), event.getDimension(), event.getValue());
        }
        catch (ConstraintViolationException ex) {
            log.debug((Object)ex, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    protected ReportingInstanceEventStore getReportingInstanceEventStore() {
        return ReportingInstanceEventStore.getInstance();
    }
}

