/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.instance;

import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.domain.ReportingAccountCrud;
import com.eucalyptus.reporting.domain.ReportingUserCrud;
import com.eucalyptus.reporting.event.InstanceCreationEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceEventStore;
import com.eucalyptus.reporting.service.ReportingService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class InstanceCreationEventListener
implements EventListener<InstanceCreationEvent> {
    private static final Logger LOG = Logger.getLogger(InstanceCreationEventListener.class);

    public static void register() {
        Listeners.register(InstanceCreationEvent.class, (EventListener)new InstanceCreationEventListener());
    }

    public void fireEvent(@Nonnull InstanceCreationEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection disabled....InstanceCreationEvent discarded");
            return;
        }
        Preconditions.checkNotNull((Object)event, (Object)"Event is required");
        long timestamp = this.getCurrentTimeMillis();
        this.getReportingAccountCrud().createOrUpdateAccount(event.getAccountId(), event.getAccountName());
        this.getReportingUserCrud().createOrUpdateUser(event.getUserId(), event.getAccountId(), event.getUserName());
        ReportingInstanceEventStore eventStore = this.getReportingInstanceEventStore();
        eventStore.insertCreateEvent(event.getUuid(), event.getInstanceId(), timestamp, event.getInstanceType(), event.getUserId(), event.getAvailabilityZone());
    }

    protected ReportingAccountCrud getReportingAccountCrud() {
        return ReportingAccountCrud.getInstance();
    }

    protected ReportingUserCrud getReportingUserCrud() {
        return ReportingUserCrud.getInstance();
    }

    protected ReportingInstanceEventStore getReportingInstanceEventStore() {
        return ReportingInstanceEventStore.getInstance();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

