/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.capacity;

import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.domain.ReportingComputeDomainModel;
import com.eucalyptus.reporting.event.ResourceAvailabilityEvent;
import com.eucalyptus.reporting.service.ReportingService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ResourceAvailabilityEventListener
implements EventListener<ResourceAvailabilityEvent> {
    private static final Logger LOG = Logger.getLogger(ResourceAvailabilityEventListener.class);
    private static final Map<ResourceAvailabilityEvent.ResourceType, ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel>> zoneSetters = ImmutableMap.builder().put((Object)ResourceAvailabilityEvent.ResourceType.Instance, (Object)new ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel.ReportingComputeZoneDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            ResourceAvailabilityEvent.Tag vmTypeTag = (ResourceAvailabilityEvent.Tag)Iterables.find(tags, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)"vm-type"), (Function)ResourceAvailabilityEvent.tagType()), null);
            if (vmTypeTag != null) {
                model.setInstancesAvailableForType(vmTypeTag.getValue(), available.intValue());
                model.setInstancesTotalForType(vmTypeTag.getValue(), total.intValue());
            }
        }
    }).put((Object)ResourceAvailabilityEvent.ResourceType.Core, (Object)new ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel.ReportingComputeZoneDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            model.setEc2ComputeUnitsAvailable(available.intValue());
            model.setEc2ComputeUnitsTotal(total.intValue());
        }
    }).put((Object)ResourceAvailabilityEvent.ResourceType.Memory, (Object)new ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel.ReportingComputeZoneDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            model.setEc2MemoryUnitsAvailable(available.intValue());
            model.setEc2MemoryUnitsTotal(total.intValue());
        }
    }).put((Object)ResourceAvailabilityEvent.ResourceType.Disk, (Object)new ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel.ReportingComputeZoneDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            model.setEc2DiskUnitsAvailable(available.intValue());
            model.setEc2DiskUnitsTotal(total.intValue());
        }
    }).put((Object)ResourceAvailabilityEvent.ResourceType.StorageEBS, (Object)new ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel.ReportingComputeZoneDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            model.setSizeEbsAvailableGB(available);
            model.setSizeEbsTotalGB(total);
        }
    }).build();
    private static final Map<ResourceAvailabilityEvent.ResourceType, ModelComputeUpdater<ReportingComputeDomainModel>> globalSetters = ImmutableMap.builder().put((Object)ResourceAvailabilityEvent.ResourceType.Address, (Object)new ModelComputeUpdater<ReportingComputeDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            model.setNumPublicIpsAvailable(available.intValue());
            model.setNumPublicIpsTotal(total.intValue());
        }
    }).put((Object)ResourceAvailabilityEvent.ResourceType.StorageWalrus, (Object)new ModelComputeUpdater<ReportingComputeDomainModel>(){

        @Override
        public void update(ReportingComputeDomainModel model, Set<ResourceAvailabilityEvent.Tag> tags, Long available, Long total) {
            model.setSizeS3ObjectAvailableGB(available);
            model.setSizeS3ObjectTotalGB(total);
        }
    }).build();

    public static void register() {
        Listeners.register(ResourceAvailabilityEvent.class, (EventListener)new ResourceAvailabilityEventListener());
    }

    public void fireEvent(@Nonnull ResourceAvailabilityEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection disabled....ResourceAvailabilityEvent discarded");
            return;
        }
        Preconditions.checkNotNull((Object)event, (Object)"Event is required");
        ModelComputeUpdater<ReportingComputeDomainModel.ReportingComputeZoneDomainModel> zoneSetter = zoneSetters.get(event.getType());
        ModelComputeUpdater<ReportingComputeDomainModel> globalSetter = globalSetters.get(event.getType());
        for (ResourceAvailabilityEvent.Availability availability : event.getAvailability()) {
            if (zoneSetter != null) {
                ReportingComputeDomainModel.ReportingComputeZoneDomainModel zoneModel = this.getZoneModelForTags(availability.getTags());
                if (zoneModel == null) continue;
                zoneSetter.update(zoneModel, availability.getTags(), availability.getAvailable(), availability.getTotal());
            }
            if (globalSetter == null) continue;
            ReportingComputeDomainModel globalModel = this.getReportingComputeDomainModel();
            globalSetter.update(globalModel, availability.getTags(), availability.getAvailable(), availability.getTotal());
        }
    }

    @Nullable
    private ReportingComputeDomainModel.ReportingComputeZoneDomainModel getZoneModelForTags(@Nonnull Set<ResourceAvailabilityEvent.Tag> tags) {
        ReportingComputeDomainModel.ReportingComputeZoneDomainModel model = null;
        for (ResourceAvailabilityEvent.Tag tag : tags) {
            if (tag instanceof ResourceAvailabilityEvent.Dimension && "availabilityZone".equals(tag.getType())) {
                model = this.getReportingComputeDomainModelForZone(tag.getValue());
                continue;
            }
            if (!(tag instanceof ResourceAvailabilityEvent.Type) || tag.getType().equals("vm-type")) continue;
            return null;
        }
        return model;
    }

    @Nonnull
    protected ReportingComputeDomainModel getReportingComputeDomainModel() {
        return ReportingComputeDomainModel.getGlobalComputeDomainModel();
    }

    @Nonnull
    protected ReportingComputeDomainModel.ReportingComputeZoneDomainModel getReportingComputeDomainModelForZone(@Nonnull String availabilityZone) {
        return ReportingComputeDomainModel.getZoneComputeDomainModel(availabilityZone);
    }

    private static interface ModelComputeUpdater<T> {
        public void update(T var1, Set<ResourceAvailabilityEvent.Tag> var2, Long var3, Long var4);
    }
}

