/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.backend;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cluster.callback.DescribeSensorCallback;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.component.id.Reporting;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.service.ReportingService;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.DescribeSensorsResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

@ConfigurableClass(root="cloud.monitor", description="Parameters controlling cloud watch and reporting")
public class DescribeSensorsListener
implements EventListener<Hertz> {
    @ConfigurableField(initial="5", description="How often the reporting system requests information from the cluster controller")
    public static Long DEFAULT_POLL_INTERVAL_MINS = 5L;
    public static final int REPORTING_NUM_THREADS = 4;
    private Integer COLLECTION_INTERVAL_TIME_MS;
    @ConfigurableField(initial="5", description="The initial history size of metrics to be send from the cc to the clc")
    public static Integer HISTORY_SIZE = 5;
    private Integer MAX_WRITE_INTERVAL_MS = 86400000;
    private Integer SENSOR_QUERY_BATCH_SIZE = 10;
    private static final AtomicBoolean busy = new AtomicBoolean(false);
    private static final Logger LOG = Logger.getLogger(DescribeSensorsListener.class);

    public static void register() {
        Listeners.register(Hertz.class, (EventListener)new DescribeSensorsListener());
    }

    public void fireEvent(Hertz event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection has been disabled....DescribeSensorsEvent discarded");
            return;
        }
        long defaultPollIntervalSeconds = TimeUnit.MINUTES.toSeconds(DEFAULT_POLL_INTERVAL_MINS);
        if (!(Bootstrap.isOperational().booleanValue() && BootstrapArgs.isCloudController().booleanValue() && event.isAsserted(defaultPollIntervalSeconds))) {
            return;
        }
        this.COLLECTION_INTERVAL_TIME_MS = DEFAULT_POLL_INTERVAL_MINS >= 1L ? Integer.valueOf((int)TimeUnit.MINUTES.toMillis(DEFAULT_POLL_INTERVAL_MINS) / 2) : Integer.valueOf(0);
        if (this.COLLECTION_INTERVAL_TIME_MS == 0 || HISTORY_SIZE > 15 || HISTORY_SIZE < 1) {
            LOG.debug((Object)"The instance usage report is disabled");
        } else if (this.COLLECTION_INTERVAL_TIME_MS <= this.MAX_WRITE_INTERVAL_MS) {
            try {
                if (event.isAsserted(defaultPollIntervalSeconds) && Bootstrap.isFinished().booleanValue() && Hosts.isCoordinator() && busy.compareAndSet(false, true)) {
                    Threads.lookup(Reporting.class).limitTo(Integer.valueOf(4)).submit((Callable)new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws Exception {
                            try {
                                Iterable processInts = Iterables.partition((Iterable)Iterables.transform((Iterable)VmInstances.list((Predicate)VmInstance.VmState.RUNNING), (Function)HasName.GET_NAME), (int)DescribeSensorsListener.this.SENSOR_QUERY_BATCH_SIZE);
                                for (ServiceConfiguration ccConfig : Topology.enabledServices(ClusterController.class)) {
                                    for (List instIds : processInts) {
                                        ArrayList instanceIds = Lists.newArrayList((Iterable)instIds);
                                        DescribeSensorCallback msgCallback = new DescribeSensorCallback(HISTORY_SIZE, DescribeSensorsListener.this.COLLECTION_INTERVAL_TIME_MS, instanceIds){

                                            public void fireException(Throwable e) {
                                            }

                                            public void fire(DescribeSensorsResponse msg) {
                                            }
                                        };
                                        CheckedListenableFuture ret = AsyncRequests.newRequest((RemoteCallback)msgCallback).dispatch(ccConfig);
                                        try {
                                            new DescribeSensorCallback(HISTORY_SIZE.intValue(), DescribeSensorsListener.this.COLLECTION_INTERVAL_TIME_MS.intValue(), instanceIds).fire((DescribeSensorsResponse)ret.get());
                                        }
                                        catch (Exception e) {
                                            Exceptions.maybeInterrupted((Throwable)e);
                                        }
                                    }
                                }
                            }
                            finally {
                                busy.set(false);
                            }
                            return null;
                        }
                    });
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Unable to listen for describe sensors events", (Throwable)ex);
            }
        } else {
            LOG.error((Object)("DEFAULT_POLL_INTERVAL_MINS : " + DEFAULT_POLL_INTERVAL_MINS + " must be less than 1440 minutes"));
        }
    }
}

