/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.modules.address;

import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.domain.ReportingAccountCrud;
import com.eucalyptus.reporting.domain.ReportingUserCrud;
import com.eucalyptus.reporting.event.AddressEvent;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.reporting.event_store.ReportingElasticIpEventStore;
import com.eucalyptus.reporting.service.ReportingService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class AddressUsageEventListener
implements EventListener<AddressEvent> {
    private static final Logger LOG = Logger.getLogger(AddressUsageEventListener.class);

    public static void register() {
        Listeners.register(AddressEvent.class, (EventListener)new AddressUsageEventListener());
    }

    public void fireEvent(@Nonnull AddressEvent event) {
        if (!ReportingService.DATA_COLLECTION_ENABLED.booleanValue()) {
            ReportingService.faultDisableReportingServiceIfNecessary();
            LOG.trace((Object)"Reporting service data collection disabled....AddressUsageEvent discarded");
            return;
        }
        Preconditions.checkNotNull((Object)event, (Object)"Event is required");
        long timestamp = this.getCurrentTimeMillis();
        this.getReportingAccountCrud().createOrUpdateAccount(event.getAccountId(), event.getAccountName());
        this.getReportingUserCrud().createOrUpdateUser(event.getUserId(), event.getAccountId(), event.getUserName());
        ReportingElasticIpEventStore eventStore = this.getReportingElasticIpEventStore();
        switch ((AddressEvent.AddressAction)event.getActionInfo().getAction()) {
            case ALLOCATE: {
                eventStore.insertCreateEvent(timestamp, event.getUserId(), event.getAddress());
                break;
            }
            case RELEASE: {
                eventStore.insertDeleteEvent(event.getAddress(), timestamp);
                break;
            }
            case ASSOCIATE: {
                eventStore.insertAttachEvent(event.getAddress(), ((EventActionInfo.InstanceEventActionInfo)event.getActionInfo()).getInstanceUuid(), timestamp);
                break;
            }
            case DISASSOCIATE: {
                eventStore.insertDetachEvent(event.getAddress(), ((EventActionInfo.InstanceEventActionInfo)event.getActionInfo()).getInstanceUuid(), timestamp);
            }
        }
    }

    protected ReportingAccountCrud getReportingAccountCrud() {
        return ReportingAccountCrud.getInstance();
    }

    protected ReportingUserCrud getReportingUserCrud() {
        return ReportingUserCrud.getInstance();
    }

    protected ReportingElasticIpEventStore getReportingElasticIpEventStore() {
        return ReportingElasticIpEventStore.getInstance();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

