/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.export;

import com.eucalyptus.reporting.export.ReportedAction;
import com.eucalyptus.reporting.export.ReportedUsage;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ReportingExport {
    private static Supplier<ReportingExportLoadListener> loadListenerSupplier = null;
    private final List<Iterable<ReportedAction>> actions = Lists.newArrayList();
    private final List<Iterable<ReportedUsage>> usage = Lists.newArrayList();
    private final ReportingExportLoadListener listener;

    public static void setLoadListenerSupplier(Supplier<ReportingExportLoadListener> supplier) {
        loadListenerSupplier = supplier;
    }

    public ReportingExport() {
        this.listener = (ReportingExportLoadListener)this.getListenerSupplier().get();
    }

    private Supplier<ReportingExportLoadListener> getListenerSupplier() {
        return (Supplier)Objects.firstNonNull(loadListenerSupplier, (Object)Suppliers.ofInstance((Object)new DefaultLoadListener()));
    }

    public ReportingExport(ReportingExportLoadListener listener) {
        this.listener = listener;
    }

    public void addActions(Iterable<ReportedAction> actions) {
        this.actions.add(actions);
    }

    public void addUsage(Iterable<ReportedUsage> usage) {
        this.usage.add(usage);
    }

    public void addAction(ReportedAction action) {
        this.listener.addAction(action);
    }

    public Iterator<ReportedAction> iterateActions() {
        return this.iterateAll(this.actions);
    }

    public void addUsage(ReportedUsage usage) {
        this.listener.addUsage(usage);
    }

    public Iterator<ReportedUsage> iterateUsage() {
        return this.iterateAll(this.usage);
    }

    private <T> Iterator<T> iterateAll(Iterable<Iterable<T>> data) {
        ArrayList iterators = Lists.newArrayList();
        for (Iterable<T> iterable : data) {
            iterators.add(iterable.iterator());
        }
        return Iterators.unmodifiableIterator((Iterator)Iterators.concat(iterators.iterator()));
    }

    private class DefaultLoadListener
    implements ReportingExportLoadListener {
        private DefaultLoadListener() {
        }

        @Override
        public void addAction(ReportedAction action) {
            ReportingExport.this.actions.add(Collections.singleton(action));
        }

        @Override
        public void addUsage(ReportedUsage usage) {
            ReportingExport.this.usage.add(Collections.singleton(usage));
        }
    }

    public static interface ReportingExportLoadListener {
        public void addAction(ReportedAction var1);

        public void addUsage(ReportedUsage var1);
    }
}

