/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.export;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.export.ExportUtils;
import com.eucalyptus.reporting.export.ReportedAction;
import com.eucalyptus.reporting.export.ReportedUsage;
import com.eucalyptus.reporting.export.ReportingExport;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class Import {
    private static final Logger logger = Logger.getLogger(Import.class);
    private int count;
    private long minTimestamp;
    private long maxTimestamp;

    public static int deleteAll() {
        return Import.deleteAll(ExportUtils.getPersistentClasses(), null);
    }

    public static int deleteAll(@Nullable Date createdTimestamp) {
        return Import.deleteAll(ExportUtils.getTimestampedClasses(), createdTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportResult importData(File exportFile, Runnable preImportCallback) throws Exception {
        ImportResult importResult;
        FileInputStream in = null;
        try {
            in = new FileInputStream(exportFile);
            importResult = Import.importData(in, preImportCallback);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)in);
        return importResult;
    }

    public static ImportResult importData(InputStream in, Runnable preImportCallback) throws Exception {
        return new Import().doImport(in, preImportCallback);
    }

    protected void resetStats() {
        this.count = 0;
        this.minTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
    }

    protected ImportResult getStats() {
        return new ImportResult(this.count, this.minTimestamp, this.maxTimestamp);
    }

    protected ImportResult doImport(final InputStream in, final Runnable preImportCallback) throws Exception {
        final Supplier callback = Suppliers.memoize((Supplier)new Supplier<Void>(){

            public Void get() {
                if (preImportCallback != null) {
                    preImportCallback.run();
                }
                return null;
            }
        });
        this.resetStats();
        return this.transactional(new Callable<ImportResult>(){

            @Override
            public ImportResult call() throws Exception {
                ReportingExport.setLoadListenerSupplier((Supplier<ReportingExport.ReportingExportLoadListener>)Suppliers.ofInstance((Object)new ReportingExport.ReportingExportLoadListener(){
                    private final Set<String> userIds = Sets.newHashSet();
                    private final Set<String> accountIds = Sets.newHashSet();

                    @Override
                    public void addAction(ReportedAction action) {
                        callback.get();
                        this.checkUserAndAccountDependencies(action);
                        this.add(action, ExportUtils.fromExportAction());
                    }

                    @Override
                    public void addUsage(ReportedUsage usage) {
                        callback.get();
                        this.add(usage, ExportUtils.fromExportUsage());
                    }

                    private void checkUserAndAccountDependencies(ReportedAction action) {
                        if (!(Strings.isNullOrEmpty((String)action.getUserId()) || Strings.isNullOrEmpty((String)action.getUserName()) || Strings.isNullOrEmpty((String)action.getAccountId()) || this.userIds.contains(action.getUserId()))) {
                            Import.this.merge(new ReportingUser(action.getUserId(), action.getAccountId(), action.getUserName()));
                            this.userIds.add(action.getUserId());
                        }
                        if (!(Strings.isNullOrEmpty((String)action.getAccountId()) || Strings.isNullOrEmpty((String)action.getAccountName()) || this.accountIds.contains(action.getAccountId()))) {
                            Import.this.merge(new ReportingAccount(action.getAccountId(), action.getAccountName()));
                            this.accountIds.add(action.getAccountId());
                        }
                    }

                    private <T> void add(T item, Function<T, ReportingEventSupport> transform) {
                        ReportingEventSupport event = (ReportingEventSupport)transform.apply(item);
                        Import.this.count++;
                        Import.this.minTimestamp = Math.min(Import.this.minTimestamp, event.getTimestampMs());
                        Import.this.maxTimestamp = Math.max(Import.this.maxTimestamp, event.getTimestampMs());
                        Import.this.merge(event);
                    }
                }));
                String bindingName = "www_eucalyptus_com_ns_reporting_export_2012_08_24";
                BindingManager.seedBinding((String)"www_eucalyptus_com_ns_reporting_export_2012_08_24", ReportingExport.class);
                Binding binding = BindingManager.getBinding((String)"www_eucalyptus_com_ns_reporting_export_2012_08_24");
                binding.fromStream(ReportingExport.class, (InputStream)new BufferedInputStream(in));
                return Import.this.getStats();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T transactional(Callable<T> callable) throws Exception {
        EntityTransaction transaction = Entities.get(ExportUtils.getTemplateClass());
        try {
            T t = callable.call();
            return t;
        }
        finally {
            transaction.commit();
        }
    }

    protected void merge(Object object) {
        Entities.mergeDirect((Object)object);
    }

    public static int deleteAll(@Nonnull Iterable<Class<?>> entityClasses, @Nullable Date createdTimestamp) {
        int deleted = 0;
        for (Class<?> reportingClass : entityClasses) {
            deleted += Import.deleteAll(reportingClass, createdTimestamp);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteAll(@Nonnull Class<?> persistentClass, @Nullable Date createdTimestamp) {
        EntityTransaction transaction = Entities.get(ExportUtils.getTemplateClass());
        try {
            int n = createdTimestamp == null ? Entities.deleteAll(persistentClass) : Entities.deleteAllMatching(persistentClass, (String)"where creationTimestamp < :creationTimestamp", Collections.singletonMap("creationTimestamp", createdTimestamp));
            return n;
        }
        finally {
            transaction.commit();
        }
    }

    public static class ImportResult {
        private final int items;
        private final long minTimestamp;
        private final long maxTimestamp;

        public ImportResult(int items, long minTimestamp, long maxTimestamp) {
            this.items = items;
            this.minTimestamp = minTimestamp;
            this.maxTimestamp = maxTimestamp;
        }

        public int getItems() {
            return this.items;
        }

        public long getMinTimestamp() {
            return this.minTimestamp;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }
    }
}

