/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.export;

import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.EventFactory;
import com.eucalyptus.reporting.event_store.ReportingElasticIpAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceUsageEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotDeleteEvent;
import com.eucalyptus.reporting.export.ReportedAction;
import com.eucalyptus.reporting.export.ReportedUsage;
import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class ExportUtils {
    private static final List<Class<?>> supportClasses = ImmutableList.of(ReportingUser.class, ReportingAccount.class);
    private static final List<Class<? extends ReportingEventSupport>> eventClasses = ImmutableList.of(ReportingElasticIpCreateEvent.class, ReportingElasticIpAttachEvent.class, ReportingElasticIpDetachEvent.class, ReportingElasticIpDeleteEvent.class, ReportingInstanceCreateEvent.class, ReportingS3ObjectCreateEvent.class, ReportingS3ObjectDeleteEvent.class, ReportingVolumeCreateEvent.class, ReportingVolumeAttachEvent.class, ReportingVolumeDetachEvent.class, ReportingVolumeDeleteEvent.class, ReportingVolumeSnapshotCreateEvent.class, (Object[])new Class[]{ReportingVolumeSnapshotDeleteEvent.class});
    private static final List<Class<? extends ReportingEventSupport>> usageClasses = ImmutableList.of(ReportingInstanceUsageEvent.class);
    private static final BiMap<TypeAndAction, Class<? extends ReportingEventSupport>> typeActionToClass = ImmutableBiMap.builder().put((Object)ExportUtils.typeAndAction("ec2.ip", "Allocate"), ReportingElasticIpCreateEvent.class).put((Object)ExportUtils.typeAndAction("ec2.ip", "Associate"), ReportingElasticIpAttachEvent.class).put((Object)ExportUtils.typeAndAction("ec2.ip", "Disassociate"), ReportingElasticIpDetachEvent.class).put((Object)ExportUtils.typeAndAction("ec2.ip", "Release"), ReportingElasticIpDeleteEvent.class).put((Object)ExportUtils.typeAndAction("ec2.instance", "Create"), ReportingInstanceCreateEvent.class).put((Object)ExportUtils.typeAndAction("ec2.instance", "Usage"), ReportingInstanceUsageEvent.class).put((Object)ExportUtils.typeAndAction("s3.object", "Create"), ReportingS3ObjectCreateEvent.class).put((Object)ExportUtils.typeAndAction("s3.object", "Delete"), ReportingS3ObjectDeleteEvent.class).put((Object)ExportUtils.typeAndAction("ec2.volume", "Create"), ReportingVolumeCreateEvent.class).put((Object)ExportUtils.typeAndAction("ec2.volume", "Attach"), ReportingVolumeAttachEvent.class).put((Object)ExportUtils.typeAndAction("ec2.volume", "Detach"), ReportingVolumeDetachEvent.class).put((Object)ExportUtils.typeAndAction("ec2.volume", "Delete"), ReportingVolumeDeleteEvent.class).put((Object)ExportUtils.typeAndAction("ec2.snapshot", "Create"), ReportingVolumeSnapshotCreateEvent.class).put((Object)ExportUtils.typeAndAction("ec2.snapshot", "Delete"), ReportingVolumeSnapshotDeleteEvent.class).build();
    private static final Map<Class<? extends ReportingEventSupport>, Function<ReportedAction, ReportingEventSupport>> fromActionFunctions = ImmutableMap.builder().put(ReportingElasticIpCreateEvent.class, (Object)FromEventFunctions.IP_CREATE).put(ReportingElasticIpAttachEvent.class, (Object)FromEventFunctions.IP_ATTACH).put(ReportingElasticIpDetachEvent.class, (Object)FromEventFunctions.IP_DETACH).put(ReportingElasticIpDeleteEvent.class, (Object)FromEventFunctions.IP_DELETE).put(ReportingInstanceCreateEvent.class, (Object)FromEventFunctions.INSTANCE_CREATE).put(ReportingS3ObjectCreateEvent.class, (Object)FromEventFunctions.OBJECT_CREATE).put(ReportingS3ObjectDeleteEvent.class, (Object)FromEventFunctions.OBJECT_DELETE).put(ReportingVolumeCreateEvent.class, (Object)FromEventFunctions.VOLUME_CREATE).put(ReportingVolumeAttachEvent.class, (Object)FromEventFunctions.VOLUME_ATTACH).put(ReportingVolumeDetachEvent.class, (Object)FromEventFunctions.VOLUME_DETACH).put(ReportingVolumeDeleteEvent.class, (Object)FromEventFunctions.VOLUME_DELETE).put(ReportingVolumeSnapshotCreateEvent.class, (Object)FromEventFunctions.SNAPSHOT_CREATE).put(ReportingVolumeSnapshotDeleteEvent.class, (Object)FromEventFunctions.SNAPSHOT_DELETE).build();
    private static final Map<Class<? extends ReportingEventSupport>, Function<ReportingEventSupport, ReportedAction>> toActionFunctions = ImmutableMap.builder().put(ReportingElasticIpCreateEvent.class, (Object)ToEventFunctions.IP_CREATE).put(ReportingElasticIpAttachEvent.class, (Object)ToEventFunctions.IP_ATTACH).put(ReportingElasticIpDetachEvent.class, (Object)ToEventFunctions.IP_DETACH).put(ReportingElasticIpDeleteEvent.class, (Object)ToEventFunctions.IP_DELETE).put(ReportingInstanceCreateEvent.class, (Object)ToEventFunctions.INSTANCE_CREATE).put(ReportingS3ObjectCreateEvent.class, (Object)ToEventFunctions.OBJECT_CREATE).put(ReportingS3ObjectDeleteEvent.class, (Object)ToEventFunctions.OBJECT_DELETE).put(ReportingVolumeCreateEvent.class, (Object)ToEventFunctions.VOLUME_CREATE).put(ReportingVolumeAttachEvent.class, (Object)ToEventFunctions.VOLUME_ATTACH).put(ReportingVolumeDetachEvent.class, (Object)ToEventFunctions.VOLUME_DETACH).put(ReportingVolumeDeleteEvent.class, (Object)ToEventFunctions.VOLUME_DELETE).put(ReportingVolumeSnapshotCreateEvent.class, (Object)ToEventFunctions.SNAPSHOT_CREATE).put(ReportingVolumeSnapshotDeleteEvent.class, (Object)ToEventFunctions.SNAPSHOT_DELETE).build();
    private static final Map<Class<? extends ReportingEventSupport>, Function<ReportedUsage, ReportingEventSupport>> fromUsageFunctions = ImmutableMap.builder().put(ReportingInstanceUsageEvent.class, (Object)FromUsageBuilders.INSTANCE).build();
    private static final Map<Class<? extends ReportingEventSupport>, Function<ReportingEventSupport, ReportedUsage>> toUsageFunctions = ImmutableMap.builder().put(ReportingInstanceUsageEvent.class, (Object)ToUsageBuilders.INSTANCE).build();

    public static Class<?> getTemplateClass() {
        return eventClasses.get(0);
    }

    public static Iterable<Class<? extends ReportingEventSupport>> getEventClasses() {
        return eventClasses;
    }

    public static Iterable<Class<? extends ReportingEventSupport>> getUsageClasses() {
        return usageClasses;
    }

    public static Iterable<Class<?>> getSupportClasses() {
        return supportClasses;
    }

    public static Iterable<Class<?>> getTimestampedClasses() {
        return Iterables.concat(eventClasses, usageClasses);
    }

    public static Iterable<Class<?>> getPersistentClasses() {
        return Iterables.concat(eventClasses, usageClasses, supportClasses);
    }

    public static Function<ReportedAction, ReportingEventSupport> fromExportAction() {
        return FromExportAction.INSTANCE;
    }

    public static Function<ReportingEventSupport, ReportedAction> toExportAction() {
        return ToExportAction.INSTANCE;
    }

    public static Function<ReportedUsage, ReportingEventSupport> fromExportUsage() {
        return FromExportUsage.INSTANCE;
    }

    public static Function<ReportingEventSupport, ReportedUsage> toExportUsage(final List<? super ReportingEventSupport> actions) {
        return new Function<ReportingEventSupport, ReportedUsage>(){

            public ReportedUsage apply(ReportingEventSupport reportingEventSupport) {
                if (eventClasses.contains(reportingEventSupport.getClass())) {
                    if (actions != null) {
                        actions.add(reportingEventSupport);
                    }
                    return null;
                }
                Function builder = (Function)toUsageFunctions.get(reportingEventSupport.getClass());
                return (ReportedUsage)builder.apply((Object)reportingEventSupport);
            }
        };
    }

    private static TypeAndAction typeAndAction(String type, String action) {
        return new TypeAndAction(type, action);
    }

    private static final class TypeAndAction {
        private final String type;
        private final String action;

        private TypeAndAction(String type, String action) {
            this.type = type;
            this.action = action;
        }

        public String getType() {
            return this.type;
        }

        public String getAction() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndAction that = (TypeAndAction)o;
            if (!this.action.equals(that.action)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.action.hashCode();
            return result;
        }
    }

    private static enum FromUsageBuilders implements Function<ReportedUsage, ReportingEventSupport>
    {
        INSTANCE{

            public ReportingEventSupport apply(ReportedUsage reportedUsage) {
                return EventFactory.newInstanceUsage(reportedUsage.getEventUuid(), reportedUsage.getCreated(), reportedUsage.getOccurred(), reportedUsage.getId(), reportedUsage.getMetric(), reportedUsage.getDimension(), reportedUsage.getSequence(), reportedUsage.getValue());
            }
        };

    }

    private static enum ToUsageBuilders implements Function<ReportingEventSupport, ReportedUsage>
    {
        INSTANCE{

            public ReportedUsage apply(ReportingEventSupport reportingEventSupport) {
                ReportingInstanceUsageEvent usageEvent = (ReportingInstanceUsageEvent)reportingEventSupport;
                ReportedUsage usage = new ReportedUsage(reportingEventSupport);
                usage.setId(usageEvent.getUuid());
                usage.setMetric(usageEvent.getMetric());
                usage.setDimension(usageEvent.getDimension());
                usage.setSequence(usageEvent.getSequenceNum());
                usage.setValue(usageEvent.getValue());
                usage.setType("ec2.instance");
                return usage;
            }
        };

    }

    private static enum ToEventFunctions implements Function<ReportingEventSupport, ReportedAction>
    {
        IP_CREATE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingElasticIpCreateEvent createEvent = (ReportingElasticIpCreateEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.ip");
                action.setAction("Allocate");
                action.setId(createEvent.getIp());
                action.setUserId(createEvent.getUserId());
                return action;
            }
        }
        ,
        IP_ATTACH{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingElasticIpAttachEvent attachEvent = (ReportingElasticIpAttachEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.ip");
                action.setAction("Associate");
                action.setId(attachEvent.getIp());
                action.setInstanceUuid(attachEvent.getInstanceUuid());
                return action;
            }
        }
        ,
        IP_DETACH{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingElasticIpDetachEvent detachEvent = (ReportingElasticIpDetachEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.ip");
                action.setAction("Disassociate");
                action.setId(detachEvent.getIp());
                action.setInstanceUuid(detachEvent.getInstanceUuid());
                return action;
            }
        }
        ,
        IP_DELETE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingElasticIpDeleteEvent deleteEvent = (ReportingElasticIpDeleteEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.ip");
                action.setAction("Release");
                action.setId(deleteEvent.getIp());
                return action;
            }
        }
        ,
        INSTANCE_CREATE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingInstanceCreateEvent createEvent = (ReportingInstanceCreateEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.instance");
                action.setAction("Create");
                action.setUuid(createEvent.getUuid());
                action.setId(createEvent.getInstanceId());
                action.setSubType(createEvent.getInstanceType());
                action.setScope(createEvent.getAvailabilityZone());
                action.setUserId(createEvent.getUserId());
                return action;
            }
        }
        ,
        OBJECT_CREATE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingS3ObjectCreateEvent createEvent = (ReportingS3ObjectCreateEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("s3.object");
                action.setAction("Create");
                action.setScope(createEvent.getS3BucketName());
                action.setId(createEvent.getS3ObjectKey());
                action.setVersion(createEvent.getObjectVersion());
                action.setSize(createEvent.getSize());
                action.setUserId(createEvent.getUserId());
                return action;
            }
        }
        ,
        OBJECT_DELETE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingS3ObjectDeleteEvent deleteEvent = (ReportingS3ObjectDeleteEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("s3.object");
                action.setAction("Delete");
                action.setScope(deleteEvent.getS3BucketName());
                action.setId(deleteEvent.getS3ObjectKey());
                action.setVersion(deleteEvent.getObjectVersion());
                return action;
            }
        }
        ,
        VOLUME_CREATE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingVolumeCreateEvent createEvent = (ReportingVolumeCreateEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.volume");
                action.setAction("Create");
                action.setUuid(createEvent.getUuid());
                action.setId(createEvent.getVolumeId());
                action.setUserId(createEvent.getUserId());
                action.setScope(createEvent.getAvailabilityZone());
                action.setSize(createEvent.getSizeGB());
                return action;
            }
        }
        ,
        VOLUME_ATTACH{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingVolumeAttachEvent attachEvent = (ReportingVolumeAttachEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.volume");
                action.setAction("Attach");
                action.setUuid(attachEvent.getVolumeUuid());
                action.setInstanceUuid(attachEvent.getInstanceUuid());
                action.setSize(attachEvent.getSizeGB());
                return action;
            }
        }
        ,
        VOLUME_DETACH{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingVolumeDetachEvent detachEvent = (ReportingVolumeDetachEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.volume");
                action.setAction("Detach");
                action.setUuid(detachEvent.getVolumeUuid());
                action.setInstanceUuid(detachEvent.getInstanceUuid());
                return action;
            }
        }
        ,
        VOLUME_DELETE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingVolumeDeleteEvent deleteEvent = (ReportingVolumeDeleteEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.volume");
                action.setAction("Delete");
                action.setUuid(deleteEvent.getUuid());
                return action;
            }
        }
        ,
        SNAPSHOT_CREATE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingVolumeSnapshotCreateEvent createEvent = (ReportingVolumeSnapshotCreateEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.snapshot");
                action.setAction("Create");
                action.setUuid(createEvent.getUuid());
                action.setId(createEvent.getVolumeSnapshotId());
                action.setVolumeUuid(createEvent.getVolumeUuid());
                action.setUserId(createEvent.getUserId());
                action.setSize(createEvent.getSizeGB());
                return action;
            }
        }
        ,
        SNAPSHOT_DELETE{

            public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
                ReportingVolumeSnapshotDeleteEvent deleteEvent = (ReportingVolumeSnapshotDeleteEvent)reportingEventSupport;
                ReportedAction action = new ReportedAction(reportingEventSupport);
                action.setType("ec2.snapshot");
                action.setAction("Delete");
                action.setUuid(deleteEvent.getUuid());
                return action;
            }
        };

    }

    private static enum FromEventFunctions implements Function<ReportedAction, ReportingEventSupport>
    {
        IP_CREATE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newIpCreate(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUserId(), reportedAction.getId());
            }
        }
        ,
        IP_ATTACH{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newIpAttach(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getId(), reportedAction.getInstanceUuid());
            }
        }
        ,
        IP_DETACH{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newIpDetach(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getId(), reportedAction.getInstanceUuid());
            }
        }
        ,
        IP_DELETE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newIpDelete(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getId());
            }
        }
        ,
        INSTANCE_CREATE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newInstanceCreate(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid(), reportedAction.getId(), reportedAction.getSubType(), reportedAction.getUserId(), reportedAction.getScope());
            }
        }
        ,
        OBJECT_CREATE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newS3ObjectCreate(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getScope(), reportedAction.getId(), reportedAction.getVersion(), reportedAction.getSize(), reportedAction.getUserId());
            }
        }
        ,
        OBJECT_DELETE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newS3ObjectDelete(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getScope(), reportedAction.getId(), reportedAction.getVersion());
            }
        }
        ,
        VOLUME_CREATE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newVolumeCreate(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid(), reportedAction.getId(), reportedAction.getUserId(), reportedAction.getScope(), reportedAction.getSize());
            }
        }
        ,
        VOLUME_ATTACH{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newVolumeAttach(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid(), reportedAction.getInstanceUuid(), reportedAction.getSize());
            }
        }
        ,
        VOLUME_DETACH{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newVolumeDetach(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid(), reportedAction.getInstanceUuid());
            }
        }
        ,
        VOLUME_DELETE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newVolumeDelete(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid());
            }
        }
        ,
        SNAPSHOT_CREATE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newSnapshotCreate(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid(), reportedAction.getId(), reportedAction.getVolumeUuid(), reportedAction.getUserId(), reportedAction.getSize());
            }
        }
        ,
        SNAPSHOT_DELETE{

            public ReportingEventSupport apply(ReportedAction reportedAction) {
                return EventFactory.newSnapshotDelete(reportedAction.getEventUuid(), reportedAction.getCreated(), reportedAction.getOccurred(), reportedAction.getUuid());
            }
        };

    }

    private static enum FromExportUsage implements Function<ReportedUsage, ReportingEventSupport>
    {
        INSTANCE;


        public ReportingEventSupport apply(ReportedUsage reportedUsage) {
            Class eventClass = (Class)typeActionToClass.get((Object)ExportUtils.typeAndAction(reportedUsage.getType(), "Usage"));
            Function builder = (Function)fromUsageFunctions.get(eventClass);
            return (ReportingEventSupport)builder.apply((Object)reportedUsage);
        }
    }

    private static enum ToExportAction implements Function<ReportingEventSupport, ReportedAction>
    {
        INSTANCE;


        public ReportedAction apply(ReportingEventSupport reportingEventSupport) {
            Function builder = (Function)toActionFunctions.get(reportingEventSupport.getClass());
            return (ReportedAction)builder.apply((Object)reportingEventSupport);
        }
    }

    private static enum FromExportAction implements Function<ReportedAction, ReportingEventSupport>
    {
        INSTANCE;


        public ReportingEventSupport apply(ReportedAction reportedAction) {
            Class eventClass = (Class)typeActionToClass.get((Object)ExportUtils.typeAndAction(reportedAction.getType(), reportedAction.getAction()));
            Function builder = (Function)fromActionFunctions.get(eventClass);
            return (ReportingEventSupport)builder.apply((Object)reportedAction);
        }
    }
}

