/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.export;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.export.ExportUtils;
import com.eucalyptus.reporting.export.ReportedAction;
import com.eucalyptus.reporting.export.ReportingExport;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class Export {
    private static final Logger log = Logger.getLogger(Export.class);
    private static final String CREATION_TIMESTAMP = "creationTimestamp";

    public static ReportingExport export(Date startDate, Date endDate, boolean includeDependencies) {
        ReportingExport export = new ReportingExport();
        Conjunction criterion = Restrictions.conjunction();
        if (startDate != null) {
            criterion.add((Criterion)Restrictions.ge((String)CREATION_TIMESTAMP, (Object)startDate));
        }
        if (endDate != null) {
            criterion.add((Criterion)Restrictions.lt((String)CREATION_TIMESTAMP, (Object)endDate));
        }
        ArrayList actions = Lists.newArrayList();
        export.addUsage(Iterables.filter((Iterable)Iterables.transform(Export.iterableExporter(criterion, ExportUtils.getUsageClasses(), Collections.emptyList(), includeDependencies), ExportUtils.toExportUsage(includeDependencies ? actions : null)), (Predicate)Predicates.notNull()));
        export.addActions(Iterables.transform((Iterable)Iterables.concat((Iterable)actions, Export.iterableExporter(criterion, ExportUtils.getEventClasses(), actions, includeDependencies)), (Function)Functions.compose(Export.userAccountDecorator(), ExportUtils.toExportAction())));
        return export;
    }

    private static Function<ReportedAction, ReportedAction> userAccountDecorator() {
        final HashMap userIdToUserNameMap = Maps.newHashMap();
        final HashMap accountIdToNameMap = Maps.newHashMap();
        return new Function<ReportedAction, ReportedAction>(){

            public ReportedAction apply(ReportedAction reportedAction) {
                if (reportedAction.getUserId() != null) {
                    String accountName;
                    ReportingUser user = (ReportingUser)userIdToUserNameMap.get(reportedAction.getUserId());
                    if (user == null) {
                        user = (ReportingUser)Export.getById(ReportingUser.class, reportedAction.getUserId());
                        userIdToUserNameMap.put(reportedAction.getUserId(), user);
                    }
                    if ((accountName = (String)accountIdToNameMap.get(user.getAccountId())) == null) {
                        accountName = ((ReportingAccount)Export.getById(ReportingAccount.class, user.getAccountId())).getName();
                        accountIdToNameMap.put(user.getAccountId(), accountName);
                    }
                    reportedAction.setUserName(user.getName());
                    reportedAction.setAccountId(user.getAccountId());
                    reportedAction.setAccountName(accountName);
                }
                return reportedAction;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getById(Class<T> itemClass, Object id) {
        EntityTransaction transaction = Entities.get(itemClass);
        try {
            Object object = Export.criteriaFor(itemClass, Restrictions.idEq((Object)id)).uniqueResult();
            return (T)object;
        }
        finally {
            transaction.rollback();
        }
    }

    private static Iterable<ReportingEventSupport> iterableExporter(final Conjunction criterion, final Iterable<Class<? extends ReportingEventSupport>> classes, final Iterable<ReportingEventSupport> existingDependencies, final boolean includeDependencies) {
        return new Iterable<ReportingEventSupport>(){

            @Override
            public Iterator<ReportingEventSupport> iterator() {
                ArrayList iterators = Lists.newArrayList();
                HashSet dependencies = Sets.newHashSet((Iterable)Iterables.transform((Iterable)existingDependencies, (Function)Export.toDependency()));
                for (Class eventClass : classes) {
                    iterators.add(Export.iteratorFor(eventClass, dependencies, (Criterion)criterion, includeDependencies));
                }
                return Iterators.concat(iterators.iterator());
            }
        };
    }

    private static Function<ReportingEventSupport, ReportingEventSupport.EventDependency> toDependency() {
        return new Function<ReportingEventSupport, ReportingEventSupport.EventDependency>(){

            public ReportingEventSupport.EventDependency apply(ReportingEventSupport reportingEventSupport) {
                return reportingEventSupport.asDependency();
            }
        };
    }

    private static Iterator<ReportingEventSupport> iteratorFor(final Class<? extends ReportingEventSupport> eventClass, final Set<ReportingEventSupport.EventDependency> dependencies, final Criterion criterion, final boolean includeDependencies) {
        return new Iterator<ReportingEventSupport>(){
            private static final int batchSize = 5000;
            private int offset = 0;
            private final LinkedList<ReportingEventSupport> data = Lists.newLinkedList();

            @Override
            public boolean hasNext() {
                this.ensureData();
                return !this.data.isEmpty();
            }

            @Override
            public ReportingEventSupport next() {
                this.ensureData();
                return this.data.removeFirst();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void ensureData() {
                if (this.data.isEmpty()) {
                    this.readNextBatch();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void readNextBatch() {
                EntityTransaction transaction = Entities.get((Object)eventClass);
                try {
                    Export.addToExportList((List<ReportingEventSupport>)this.data, (Set<ReportingEventSupport.EventDependency>)dependencies, includeDependencies, Export.criteriaFor(eventClass, criterion).setFirstResult(this.offset).setMaxResults(5000).list());
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                finally {
                    this.offset += 5000;
                    transaction.rollback();
                }
            }
        };
    }

    private static Criteria criteriaFor(Class<?> persistentClass, Criterion criterion) {
        return Entities.createCriteria(persistentClass).setReadOnly(true).setCacheable(false).setCacheMode(CacheMode.IGNORE).setFetchSize(500).add(criterion);
    }

    private static void addToExportList(List<ReportingEventSupport> export, Set<ReportingEventSupport.EventDependency> dependencies, boolean includeDependencies, List entities) {
        for (Object entity : entities) {
            if (!(entity instanceof ReportingEventSupport)) continue;
            ReportingEventSupport eventSupport = (ReportingEventSupport)entity;
            Export.addToExportList(export, dependencies, includeDependencies, eventSupport);
        }
    }

    private static void addToExportList(List<ReportingEventSupport> export, Set<ReportingEventSupport.EventDependency> dependencies, boolean includeDependencies, ReportingEventSupport eventSupport) {
        ReportingEventSupport.EventDependency dependency = eventSupport.asDependency();
        if (dependency != null) {
            if (dependencies.contains(dependency)) {
                return;
            }
            dependencies.add(dependency);
        }
        if (includeDependencies) {
            Export.ensureDependencies(export, dependencies, eventSupport);
        }
        export.add(eventSupport);
    }

    private static void ensureDependencies(List<ReportingEventSupport> export, Set<ReportingEventSupport.EventDependency> dependencies, ReportingEventSupport persistent) {
        for (ReportingEventSupport.EventDependency dependency : persistent.getDependencies()) {
            Export.ensureDependency(export, dependencies, dependency);
        }
    }

    private static void ensureDependency(List<ReportingEventSupport> export, Set<ReportingEventSupport.EventDependency> dependencies, ReportingEventSupport.EventDependency dependency) {
        Object value;
        if (!dependencies.contains(dependency) && ReportingEventSupport.class.isAssignableFrom(dependency.getDependencyType()) && (value = Export.criteriaFor(dependency.getDependencyType(), (Criterion)Restrictions.eq((String)dependency.getProperty(), (Object)dependency.getValue())).uniqueResult()) instanceof ReportingEventSupport) {
            Export.addToExportList(export, dependencies, true, (ReportingEventSupport)value);
        }
    }
}

