/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.reporting.event_store.EventStoreSupport;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotDeleteEvent;
import com.google.common.base.Preconditions;

public class ReportingVolumeSnapshotEventStore
extends EventStoreSupport {
    private static final ReportingVolumeSnapshotEventStore instance = new ReportingVolumeSnapshotEventStore();

    public static ReportingVolumeSnapshotEventStore getInstance() {
        return instance;
    }

    protected ReportingVolumeSnapshotEventStore() {
    }

    public void insertCreateEvent(String uuid, String volumeUuid, String volumeSnapshotId, long timestampMs, String userId, long sizeGB) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        Preconditions.checkNotNull((Object)volumeSnapshotId, (Object)"VolumeSnapshotId is required");
        Preconditions.checkNotNull((Object)userId, (Object)"UserId is required");
        this.persist(new ReportingVolumeSnapshotCreateEvent(uuid, volumeUuid, volumeSnapshotId, timestampMs, userId, sizeGB));
    }

    public void insertDeleteEvent(String uuid, long timestampMs) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        this.persist(new ReportingVolumeSnapshotDeleteEvent(uuid, timestampMs));
    }
}

