/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_volume_snapshot_create_events")
public class ReportingVolumeSnapshotCreateEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="uuid", nullable=false, unique=true)
    private String uuid;
    @Column(name="volume_uuid", nullable=false)
    private String volumeUuid;
    @Column(name="volume_snapshot_id", nullable=false)
    private String volumeSnapshotId;
    @Column(name="user_id", nullable=false)
    private String userId;
    @Column(name="sizeGB", nullable=false)
    private Long sizeGB;

    protected ReportingVolumeSnapshotCreateEvent() {
    }

    ReportingVolumeSnapshotCreateEvent(String uuid, String volumeUuid, String volumeSnapshotId, Long timestampMs, String userId, Long sizeGB) {
        this.uuid = uuid;
        this.volumeUuid = volumeUuid;
        this.volumeSnapshotId = volumeSnapshotId;
        this.timestampMs = timestampMs;
        this.userId = userId;
        this.sizeGB = sizeGB;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVolumeUuid() {
        return this.volumeUuid;
    }

    public String getVolumeSnapshotId() {
        return this.volumeSnapshotId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getSizeGB() {
        return this.sizeGB;
    }

    @Override
    public ReportingEventSupport.EventDependency asDependency() {
        return this.asDependency("uuid", this.uuid);
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingVolumeSnapshotCreateEvent.withDependencies().user(this.userId).set();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingVolumeSnapshotCreateEvent other = (ReportingVolumeSnapshotCreateEvent)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return "[uuid:" + this.uuid + " volumeSnapshotId:" + this.volumeSnapshotId + " timestampMs:" + this.timestampMs + " userId:" + this.userId + "]";
    }
}

