/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.reporting.event_store.EventStoreSupport;
import com.eucalyptus.reporting.event_store.ReportingVolumeAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDetachEvent;
import com.google.common.base.Preconditions;

public class ReportingVolumeEventStore
extends EventStoreSupport {
    private static final ReportingVolumeEventStore instance = new ReportingVolumeEventStore();

    public static ReportingVolumeEventStore getInstance() {
        return instance;
    }

    protected ReportingVolumeEventStore() {
    }

    public void insertCreateEvent(String uuid, String volumeId, long timestampMs, String userId, String availabilityZone, long sizeGB) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        Preconditions.checkNotNull((Object)volumeId, (Object)"VolumeId is required");
        Preconditions.checkNotNull((Object)userId, (Object)"UserId is required");
        Preconditions.checkNotNull((Object)availabilityZone, (Object)"AvailabilityZone is required");
        this.persist(new ReportingVolumeCreateEvent(uuid, volumeId, timestampMs, userId, availabilityZone, sizeGB));
    }

    public void insertDeleteEvent(String uuid, long timestampMs) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        this.persist(new ReportingVolumeDeleteEvent(uuid, timestampMs));
    }

    public void insertAttachEvent(String uuid, String instanceUuid, long sizeGB, long timestampMs) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        Preconditions.checkNotNull((Object)instanceUuid, (Object)"InstanceUuid is required");
        this.persist(new ReportingVolumeAttachEvent(uuid, instanceUuid, sizeGB, timestampMs));
    }

    public void insertDetachEvent(String uuid, String instanceUuid, long timestampMs) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        Preconditions.checkNotNull((Object)instanceUuid, (Object)"InstanceUuid is required");
        this.persist(new ReportingVolumeDetachEvent(uuid, instanceUuid, timestampMs));
    }
}

