/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_volume_delete_events")
public class ReportingVolumeDeleteEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="uuid", nullable=false)
    private String uuid;

    protected ReportingVolumeDeleteEvent(String uuid, Long timestampMs) {
        this.uuid = uuid;
        this.timestampMs = timestampMs;
    }

    protected ReportingVolumeDeleteEvent() {
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingVolumeDeleteEvent.withDependencies().relation(ReportingVolumeCreateEvent.class, "uuid", this.uuid).set();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.timestampMs == null ? 0 : this.timestampMs.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingVolumeDeleteEvent other = (ReportingVolumeDeleteEvent)obj;
        if (this.timestampMs == null ? other.timestampMs != null : !this.timestampMs.equals(other.timestampMs)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

