/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_volume_create_events")
public class ReportingVolumeCreateEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="uuid", nullable=false, unique=true)
    private String uuid;
    @Column(name="volume_id", nullable=false)
    private String volumeId;
    @Column(name="user_id", nullable=false)
    private String userId;
    @Column(name="availability_zone", nullable=false)
    private String availabilityZone;
    @Column(name="sizeGB", nullable=false)
    private Long sizeGB;

    protected ReportingVolumeCreateEvent() {
    }

    ReportingVolumeCreateEvent(String uuid, String volumeId, long timestampMs, String userId, String availabilityZone, long sizeGB) {
        this.uuid = uuid;
        this.timestampMs = timestampMs;
        this.volumeId = volumeId;
        this.userId = userId;
        this.availabilityZone = availabilityZone;
        this.sizeGB = sizeGB;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Long getSizeGB() {
        return this.sizeGB;
    }

    @Override
    public ReportingEventSupport.EventDependency asDependency() {
        return this.asDependency("uuid", this.uuid);
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingVolumeCreateEvent.withDependencies().user(this.userId).set();
    }

    public int hashCode() {
        return this.uuid == null ? 0 : this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingVolumeCreateEvent other = (ReportingVolumeCreateEvent)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return "[uuid:" + this.uuid + " volumeId:" + this.volumeId + " userId:" + this.userId + "]";
    }
}

