/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_volume_attach_events")
public class ReportingVolumeAttachEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="volume_uuid", nullable=false)
    private String volumeUuid;
    @Column(name="instance_uuid", nullable=false)
    private String instanceUuid;
    @Column(name="size_gb", nullable=false)
    private Long sizeGB;

    ReportingVolumeAttachEvent() {
    }

    ReportingVolumeAttachEvent(String volumeUuid, String instanceUuid, long sizeGB, long timestampMs) {
        this.volumeUuid = volumeUuid;
        this.instanceUuid = instanceUuid;
        this.sizeGB = sizeGB;
        this.timestampMs = timestampMs;
    }

    public String getVolumeUuid() {
        return this.volumeUuid;
    }

    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    public Long getSizeGB() {
        return this.sizeGB;
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingVolumeAttachEvent.withDependencies().relation(ReportingVolumeCreateEvent.class, "uuid", this.volumeUuid).relation(ReportingInstanceCreateEvent.class, "uuid", this.instanceUuid).set();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.instanceUuid == null ? 0 : this.instanceUuid.hashCode());
        result = 31 * result + (this.sizeGB == null ? 0 : this.sizeGB.hashCode());
        result = 31 * result + (this.timestampMs == null ? 0 : this.timestampMs.hashCode());
        result = 31 * result + (this.volumeUuid == null ? 0 : this.volumeUuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingVolumeAttachEvent other = (ReportingVolumeAttachEvent)obj;
        if (this.instanceUuid == null ? other.instanceUuid != null : !this.instanceUuid.equals(other.instanceUuid)) {
            return false;
        }
        if (this.sizeGB == null ? other.sizeGB != null : !this.sizeGB.equals(other.sizeGB)) {
            return false;
        }
        if (this.timestampMs == null ? other.timestampMs != null : !this.timestampMs.equals(other.timestampMs)) {
            return false;
        }
        return !(this.volumeUuid == null ? other.volumeUuid != null : !this.volumeUuid.equals(other.volumeUuid));
    }
}

