/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectCreateEvent;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_s3_object_delete_events")
public class ReportingS3ObjectDeleteEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="s3_bucket_name", nullable=false)
    private String s3BucketName;
    @Column(name="s3_object_key", nullable=false)
    private String s3ObjectKey;
    @Column(name="s3_object_version", nullable=true)
    protected String objectVersion;

    protected ReportingS3ObjectDeleteEvent() {
    }

    protected ReportingS3ObjectDeleteEvent(String s3BucketName, String s3ObjectKey, String objectVersion, Long timestampMs) {
        this.s3BucketName = s3BucketName;
        this.s3ObjectKey = s3ObjectKey;
        this.objectVersion = objectVersion;
        this.timestampMs = timestampMs;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    public String getObjectVersion() {
        return this.objectVersion;
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingS3ObjectDeleteEvent.withDependencies().relation(ReportingS3ObjectCreateEvent.class, "s3ObjectName", this.s3ObjectKey).set();
    }

    public String toString() {
        return "ReportingS3ObjectDeleteEvent [s3BucketName=" + this.s3BucketName + ", s3ObjectKey=" + this.s3ObjectKey + ", s3ObjectSize=" + ", timestampMs=" + this.timestampMs + "]";
    }
}

