/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_s3_object_create_events")
public class ReportingS3ObjectCreateEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="s3_bucket_name", nullable=false)
    protected String s3BucketName;
    @Column(name="s3_object_name", nullable=false)
    protected String s3ObjectKey;
    @Column(name="s3_object_version", nullable=true)
    protected String objectVersion;
    @Column(name="size", nullable=false)
    protected Long size;
    @Column(name="user_id", nullable=false)
    protected String userId;

    protected ReportingS3ObjectCreateEvent() {
    }

    ReportingS3ObjectCreateEvent(String s3BucketName, String s3ObjectKey, String objectVersion, Long size, Long timestampMs, String userId) {
        this.s3BucketName = s3BucketName;
        this.s3ObjectKey = s3ObjectKey;
        this.objectVersion = objectVersion;
        this.size = size;
        this.timestampMs = timestampMs;
        this.userId = userId;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getSize() {
        return this.size;
    }

    public String getObjectVersion() {
        return this.objectVersion;
    }

    @Override
    public ReportingEventSupport.EventDependency asDependency() {
        return this.asDependency("s3ObjectName", this.s3ObjectKey);
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingS3ObjectCreateEvent.withDependencies().user(this.userId).set();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.s3BucketName == null ? 0 : this.s3BucketName.hashCode());
        result = 31 * result + (this.s3ObjectKey == null ? 0 : this.s3ObjectKey.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.timestampMs == null ? 0 : this.timestampMs.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingS3ObjectCreateEvent other = (ReportingS3ObjectCreateEvent)obj;
        if (this.s3BucketName == null ? other.s3BucketName != null : !this.s3BucketName.equals(other.s3BucketName)) {
            return false;
        }
        if (this.s3ObjectKey == null ? other.s3ObjectKey != null : !this.s3ObjectKey.equals(other.s3ObjectKey)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.timestampMs == null ? other.timestampMs != null : !this.timestampMs.equals(other.timestampMs)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public String toString() {
        return "ReportingS3ObjectCreateEvent [s3BucketName=" + this.s3BucketName + ", s3ObjectName=" + this.s3ObjectKey + ", timestampMs=" + this.timestampMs + ", userId=" + this.userId + ", s3ObjectSize=" + this.size + "]";
    }
}

