/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.util.Parameters;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_instance_usage_events")
public class ReportingInstanceUsageEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="uuid", nullable=false)
    protected String uuid;
    @Column(name="metric", nullable=false)
    protected String metric;
    @Column(name="sequenceNum", nullable=false)
    protected Long sequenceNum;
    @Column(name="dimension", nullable=false)
    protected String dimension;
    @Column(name="value", nullable=false)
    protected Double value;

    protected ReportingInstanceUsageEvent() {
    }

    ReportingInstanceUsageEvent(String uuid, String metric, Long sequenceNum, String dimension, Double value, Long valueTimestamp) {
        Parameters.checkParam((Object)uuid, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)metric, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)sequenceNum, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)dimension, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)value, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)valueTimestamp, (Matcher)Matchers.notNullValue());
        this.uuid = uuid;
        this.timestampMs = valueTimestamp;
        this.metric = metric;
        this.sequenceNum = sequenceNum;
        this.dimension = dimension;
        this.value = value;
    }

    public ReportingInstanceUsageEvent zero(Long timestamp) {
        ReportingInstanceUsageEvent event = new ReportingInstanceUsageEvent();
        event.uuid = this.uuid;
        event.metric = this.metric;
        event.dimension = this.dimension;
        event.value = 0.0;
        event.timestampMs = timestamp;
        event.sequenceNum = -1L;
        return event;
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingInstanceUsageEvent.withDependencies().relation(ReportingInstanceCreateEvent.class, "uuid", this.uuid).set();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getMetric() {
        return this.metric;
    }

    public Long getSequenceNum() {
        return this.sequenceNum;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Double getValue() {
        return this.value;
    }

    public String toString() {
        return "ReportingInstanceUsageEvent [uuid=" + this.uuid + ", metric=" + this.metric + ", sequenceNum=" + this.sequenceNum + ", dimension=" + this.dimension + ", value=" + this.value + ", timestamp=" + this.timestampMs + "]";
    }
}

