/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.reporting.event_store.EventStoreSupport;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceUsageEvent;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class ReportingInstanceEventStore
extends EventStoreSupport {
    private static final ReportingInstanceEventStore instance = new ReportingInstanceEventStore();

    public static ReportingInstanceEventStore getInstance() {
        return instance;
    }

    protected ReportingInstanceEventStore() {
    }

    public void insertCreateEvent(@Nonnull String uuid, @Nonnull String instanceId, @Nonnull Long timestampMs, @Nonnull String instanceType, @Nonnull String userId, @Nonnull String availabilityZone) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        Preconditions.checkNotNull((Object)instanceId, (Object)"InstanceId is required");
        Preconditions.checkNotNull((Object)timestampMs, (Object)"TimestampMs is required");
        Preconditions.checkNotNull((Object)instanceType, (Object)"InstanceType is required");
        Preconditions.checkNotNull((Object)userId, (Object)"UserId is required");
        Preconditions.checkNotNull((Object)availabilityZone, (Object)"AvailabilityZone is required");
        this.persist(new ReportingInstanceCreateEvent(uuid, instanceId, timestampMs, instanceType, userId, availabilityZone));
    }

    public void insertUsageEvent(@Nonnull String uuid, @Nonnull Long timestamp, @Nonnull String metric, @Nonnull Long sequenceNum, @Nonnull String dimension, @Nonnull Double value) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Uuid is required");
        Preconditions.checkNotNull((Object)timestamp, (Object)"Timestamp is required");
        Preconditions.checkNotNull((Object)metric, (Object)"Metric is required");
        Preconditions.checkNotNull((Object)sequenceNum, (Object)"SequenceNum is required");
        Preconditions.checkNotNull((Object)dimension, (Object)"Dimension is required");
        Preconditions.checkNotNull((Object)value, (Object)"value is required");
        this.persist(new ReportingInstanceUsageEvent(uuid, metric, sequenceNum, dimension, value, timestamp));
    }
}

