/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_instance_create_events")
public class ReportingInstanceCreateEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="uuid", nullable=false)
    private String uuid;
    @Column(name="instance_id", nullable=false)
    private String instanceId;
    @Column(name="instance_type", nullable=false)
    private String instanceType;
    @Column(name="user_id", nullable=false)
    private String userId;
    @Column(name="availability_zone", nullable=false)
    private String availabilityZone;

    protected ReportingInstanceCreateEvent() {
    }

    ReportingInstanceCreateEvent(String uuid, String instanceId, Long timestampMs, String instanceType, String userId, String availabilityZone) {
        this.uuid = uuid;
        this.instanceId = instanceId;
        this.timestampMs = timestampMs;
        this.instanceType = instanceType;
        this.userId = userId;
        this.availabilityZone = availabilityZone;
    }

    @Override
    public ReportingEventSupport.EventDependency asDependency() {
        return this.asDependency("uuid", this.uuid);
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingInstanceCreateEvent.withDependencies().user(this.userId).set();
    }

    public int hashCode() {
        return this.uuid == null ? 0 : this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingInstanceCreateEvent other = (ReportingInstanceCreateEvent)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String toString() {
        return "ReportingInstanceCreateEvent [uuid=" + this.uuid + ", instanceId=" + this.instanceId + ", instanceType=" + this.instanceType + ", userId=" + this.userId + ", availabilityZone=" + this.availabilityZone + "]";
    }
}

