/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.GenericGenerator;

@MappedSuperclass
public abstract class ReportingEventSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="reporting-uuid")
    @GenericGenerator(name="reporting-uuid", strategy="com.eucalyptus.reporting.event_store.ReportingEventIdGenerator")
    @Column(name="id", nullable=false, updatable=false)
    private String id;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_timestamp", updatable=false, nullable=false)
    private Date creationTimestamp;
    @Column(name="timestamp_ms", nullable=false)
    protected Long timestampMs;

    public String getId() {
        return this.id;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public final Long getTimestampMs() {
        return this.timestampMs;
    }

    @Nullable
    public EventDependency asDependency() {
        return null;
    }

    public abstract Set<EventDependency> getDependencies();

    protected final EventDependency asDependency(String property, String value) {
        return new EventDependency(this.getClass(), property, value);
    }

    protected static EventDependencyBuilder withDependencies() {
        return new EventDependencyBuilder();
    }

    void initialize(String eventId, Date created) {
        this.id = eventId;
        this.creationTimestamp = created;
    }

    @PreUpdate
    @PrePersist
    public void updateTimeStamps() {
        if (this.creationTimestamp == null) {
            this.creationTimestamp = new Date();
        }
    }

    public static final class EventDependency {
        private final Class<?> dependencyType;
        private final String property;
        private final String value;

        public EventDependency(Class<?> dependencyType, String property, String value) {
            this.dependencyType = dependencyType;
            this.property = property;
            this.value = value;
        }

        public Class<?> getDependencyType() {
            return this.dependencyType;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventDependency that = (EventDependency)o;
            if (!this.dependencyType.equals(that.dependencyType)) {
                return false;
            }
            if (!this.property.equals(that.property)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.dependencyType.hashCode();
            result = 31 * result + this.property.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    public static class EventDependencyBuilder {
        private final Set<EventDependency> dependencies = Sets.newHashSet();

        private EventDependencyBuilder() {
        }

        public EventDependencyBuilder user(String userId) {
            if (userId != null) {
                this.dependencies.add(new EventDependency(ReportingUser.class, "id", userId));
            }
            return this;
        }

        public EventDependencyBuilder account(String accountId) {
            if (accountId != null) {
                this.dependencies.add(new EventDependency(ReportingAccount.class, "id", accountId));
            }
            return this;
        }

        public EventDependencyBuilder relation(Class<? extends ReportingEventSupport> dependencyType, String property, String value) {
            if (value != null) {
                this.dependencies.add(new EventDependency(dependencyType, property, value));
            }
            return this;
        }

        public Set<EventDependency> set() {
            return this.dependencies;
        }
    }
}

