/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.reporting.event_store.EventStoreSupport;
import com.eucalyptus.reporting.event_store.ReportingElasticIpAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDetachEvent;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class ReportingElasticIpEventStore
extends EventStoreSupport {
    private static final ReportingElasticIpEventStore instance = new ReportingElasticIpEventStore();

    public static ReportingElasticIpEventStore getInstance() {
        return instance;
    }

    protected ReportingElasticIpEventStore() {
    }

    public void insertCreateEvent(long timestampMs, @Nonnull String userId, @Nonnull String ip) {
        Preconditions.checkNotNull((Object)userId, (Object)"UserId is required");
        Preconditions.checkNotNull((Object)ip, (Object)"IP is required");
        this.persist(new ReportingElasticIpCreateEvent(timestampMs, ip, userId));
    }

    public void insertDeleteEvent(@Nonnull String ip, long timestampMs) {
        Preconditions.checkNotNull((Object)ip, (Object)"IP is required");
        this.persist(new ReportingElasticIpDeleteEvent(ip, timestampMs));
    }

    public void insertAttachEvent(@Nonnull String ip, @Nonnull String instanceUuid, long timestampMs) {
        Preconditions.checkNotNull((Object)ip, (Object)"IP is required");
        Preconditions.checkNotNull((Object)instanceUuid, (Object)"InstanceUuid is required");
        this.persist(new ReportingElasticIpAttachEvent(ip, instanceUuid, timestampMs));
    }

    public void insertDetachEvent(@Nonnull String ip, @Nonnull String instanceUuid, long timestampMs) {
        Preconditions.checkNotNull((Object)ip, (Object)"IP is required");
        Preconditions.checkNotNull((Object)instanceUuid, (Object)"InstanceUuid is required");
        this.persist(new ReportingElasticIpDetachEvent(ip, instanceUuid, timestampMs));
    }
}

