/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_elastic_ip_create_events")
public class ReportingElasticIpCreateEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="ip", nullable=false)
    private String ip;
    @Column(name="user_id", nullable=false)
    private String userId;

    protected ReportingElasticIpCreateEvent() {
    }

    ReportingElasticIpCreateEvent(Long timestampMs, String ip, String userId) {
        this.timestampMs = timestampMs;
        this.ip = ip;
        this.userId = userId;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public ReportingEventSupport.EventDependency asDependency() {
        return this.asDependency("ip", this.ip);
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingElasticIpCreateEvent.withDependencies().user(this.userId).set();
    }

    public String toString() {
        return "[timestampMs: " + this.timestampMs + " ip:" + this.ip + " userId:" + this.userId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.timestampMs == null ? 0 : this.timestampMs.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingElasticIpCreateEvent other = (ReportingElasticIpCreateEvent)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.timestampMs == null ? other.timestampMs != null : !this.timestampMs.equals(other.timestampMs)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }
}

