/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.component.annotation.RemotablePersistence;
import com.eucalyptus.reporting.event_store.ReportingElasticIpCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;

@Entity
@PersistenceContext(name="eucalyptus_reporting_backend")
@RemotablePersistence
@Table(name="reporting_elastic_ip_attach_events")
public class ReportingElasticIpAttachEvent
extends ReportingEventSupport {
    private static final long serialVersionUID = 1L;
    @Column(name="ip", nullable=false)
    private String ip;
    @Column(name="instance_uuid", nullable=false)
    private String instanceUuid;

    protected ReportingElasticIpAttachEvent(String ip, String instanceUuid, Long timestampMs) {
        this.ip = ip;
        this.instanceUuid = instanceUuid;
        this.timestampMs = timestampMs;
    }

    protected ReportingElasticIpAttachEvent() {
    }

    public String getIp() {
        return this.ip;
    }

    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    @Override
    public Set<ReportingEventSupport.EventDependency> getDependencies() {
        return ReportingElasticIpAttachEvent.withDependencies().relation(ReportingElasticIpCreateEvent.class, "ip", this.ip).set();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceUuid == null ? 0 : this.instanceUuid.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.timestampMs == null ? 0 : this.timestampMs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportingElasticIpAttachEvent other = (ReportingElasticIpAttachEvent)obj;
        if (this.instanceUuid == null ? other.instanceUuid != null : !this.instanceUuid.equals(other.instanceUuid)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        return !(this.timestampMs == null ? other.timestampMs != null : !this.timestampMs.equals(other.timestampMs));
    }
}

