/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.event_store;

import com.eucalyptus.reporting.event_store.ReportingElasticIpAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceUsageEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotDeleteEvent;
import java.util.Date;

public class EventFactory {
    public static ReportingInstanceCreateEvent newInstanceCreate(String eventId, Date created, Date occurred, String uuid, String instanceId, String instanceType, String userId, String availabilityZone) {
        ReportingInstanceCreateEvent event = new ReportingInstanceCreateEvent(uuid, instanceId, occurred.getTime(), instanceType, userId, availabilityZone);
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingInstanceUsageEvent newInstanceUsage(String eventId, Date created, Date occurred, String uuid, String metric, String dimension, Long sequence, Double value) {
        ReportingInstanceUsageEvent event = new ReportingInstanceUsageEvent(uuid, metric, sequence, dimension, value, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingElasticIpAttachEvent newIpAttach(String eventId, Date created, Date occurred, String ip, String instanceUuid) {
        ReportingElasticIpAttachEvent event = new ReportingElasticIpAttachEvent(ip, instanceUuid, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingElasticIpCreateEvent newIpCreate(String eventId, Date created, Date occurred, String userId, String ip) {
        ReportingElasticIpCreateEvent event = new ReportingElasticIpCreateEvent(occurred.getTime(), ip, userId);
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingElasticIpDetachEvent newIpDetach(String eventId, Date created, Date occurred, String ip, String instanceUuid) {
        ReportingElasticIpDetachEvent event = new ReportingElasticIpDetachEvent(ip, instanceUuid, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingElasticIpDeleteEvent newIpDelete(String eventId, Date created, Date occurred, String ip) {
        ReportingElasticIpDeleteEvent event = new ReportingElasticIpDeleteEvent(ip, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingS3ObjectCreateEvent newS3ObjectCreate(String eventId, Date created, Date occurred, String bucketName, String objectKey, String objectVersion, Long size, String userId) {
        ReportingS3ObjectCreateEvent event = new ReportingS3ObjectCreateEvent(bucketName, objectKey, objectVersion, size, occurred.getTime(), userId);
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingS3ObjectDeleteEvent newS3ObjectDelete(String eventId, Date created, Date occurred, String bucketName, String objectKey, String objectVersion) {
        ReportingS3ObjectDeleteEvent event = new ReportingS3ObjectDeleteEvent(bucketName, objectKey, objectVersion, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingVolumeCreateEvent newVolumeCreate(String eventId, Date created, Date occurred, String uuid, String id, String userId, String availabilityZone, Long size) {
        ReportingVolumeCreateEvent event = new ReportingVolumeCreateEvent(uuid, id, occurred.getTime(), userId, availabilityZone, size);
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingVolumeAttachEvent newVolumeAttach(String eventId, Date created, Date occurred, String uuid, String instanceUuid, Long size) {
        ReportingVolumeAttachEvent event = new ReportingVolumeAttachEvent(uuid, instanceUuid, size, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingVolumeDetachEvent newVolumeDetach(String eventId, Date created, Date occurred, String uuid, String instanceUuid) {
        ReportingVolumeDetachEvent event = new ReportingVolumeDetachEvent(uuid, instanceUuid, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingVolumeDeleteEvent newVolumeDelete(String eventId, Date created, Date occurred, String uuid) {
        ReportingVolumeDeleteEvent event = new ReportingVolumeDeleteEvent(uuid, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingVolumeSnapshotCreateEvent newSnapshotCreate(String eventId, Date created, Date occurred, String uuid, String id, String volumeUuid, String userId, Long size) {
        ReportingVolumeSnapshotCreateEvent event = new ReportingVolumeSnapshotCreateEvent(uuid, volumeUuid, id, occurred.getTime(), userId, size);
        event.initialize(eventId, created);
        return event;
    }

    public static ReportingVolumeSnapshotDeleteEvent newSnapshotDelete(String eventId, Date created, Date occurred, String uuid) {
        ReportingVolumeSnapshotDeleteEvent event = new ReportingVolumeSnapshotDeleteEvent(uuid, occurred.getTime());
        event.initialize(eventId, created);
        return event;
    }
}

