/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.domain;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.domain.ReportingUserDao;
import org.apache.log4j.Logger;

public class ReportingUserCrud {
    private static Logger LOG = Logger.getLogger(ReportingUserCrud.class);
    private static ReportingUserCrud instance = null;

    public static synchronized ReportingUserCrud getInstance() {
        if (instance == null) {
            instance = new ReportingUserCrud();
        }
        return instance;
    }

    protected ReportingUserCrud() {
    }

    public void createOrUpdateUser(String id, String accountId, String name) {
        if (id == null || accountId == null || name == null) {
            throw new IllegalArgumentException("args cant be null");
        }
        ReportingUser oldUser = ReportingUserDao.getInstance().getReportingUser(id);
        if (oldUser != null && oldUser.getName().equals(name)) {
            return;
        }
        if (oldUser != null) {
            this.updateInDb(id, name);
        } else {
            try {
                this.addToDb(id, accountId, name);
            }
            catch (RuntimeException e) {
                LOG.error((Object)e);
            }
        }
    }

    private void updateInDb(String id, String name) {
        LOG.debug((Object)("Update reporting user in db, id:" + id + " name:" + name));
        try (TransactionResource db = Entities.transactionFor(ReportingUser.class);){
            ReportingUser searchUser = new ReportingUser();
            searchUser.setId(id);
            ((ReportingUser)Entities.uniqueResult((Object)searchUser)).setName(name);
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }

    private void addToDb(String id, String accountId, String name) {
        LOG.debug((Object)("Add reporting user to db, id:" + id + " accountId:" + accountId + " name:" + name));
        try (TransactionResource db = Entities.transactionFor(ReportingUser.class);){
            Entities.persist((Object)new ReportingUser(id, accountId, name));
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }
}

