/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ReportingComputeDomainModel {
    private static final ReportingComputeDomainModel globalModel = new ReportingComputeDomainModel();
    private static final ConcurrentMap<String, ReportingComputeZoneDomainModel> zoneModels = Maps.newConcurrentMap();
    private final AtomicReference<Long> sizeS3ObjectAvailableGB = new AtomicReference();
    private final AtomicReference<Long> sizeS3ObjectTotalGB = new AtomicReference();
    private final AtomicReference<Integer> numPublicIpsAvailable = new AtomicReference();
    private final AtomicReference<Integer> numPublicIpsTotal = new AtomicReference();

    public static ReportingComputeDomainModel getGlobalComputeDomainModel() {
        return globalModel;
    }

    public static Set<String> getZones() {
        return Sets.newTreeSet(zoneModels.keySet());
    }

    public static ReportingComputeZoneDomainModel getZoneComputeDomainModel(String zoneName) {
        ReportingComputeZoneDomainModel zoneModel = (ReportingComputeZoneDomainModel)zoneModels.get(zoneName);
        if (zoneModel == null && zoneModels.putIfAbsent(zoneName, zoneModel = new ReportingComputeZoneDomainModel()) != null) {
            zoneModel = (ReportingComputeZoneDomainModel)zoneModels.get(zoneName);
        }
        return zoneModel;
    }

    public Long getSizeS3ObjectAvailableGB() {
        return this.sizeS3ObjectAvailableGB.get();
    }

    public void setSizeS3ObjectAvailableGB(Long sizeS3ObjectAvailableGB) {
        this.sizeS3ObjectAvailableGB.set(sizeS3ObjectAvailableGB);
    }

    public Long getSizeS3ObjectTotalGB() {
        return this.sizeS3ObjectTotalGB.get();
    }

    public void setSizeS3ObjectTotalGB(Long sizeS3ObjectTotalGB) {
        this.sizeS3ObjectTotalGB.set(sizeS3ObjectTotalGB);
    }

    public Integer getNumPublicIpsAvailable() {
        return this.numPublicIpsAvailable.get();
    }

    public void setNumPublicIpsAvailable(Integer numPublicIpsAvailable) {
        this.numPublicIpsAvailable.set(numPublicIpsAvailable);
    }

    public Integer getNumPublicIpsTotal() {
        return this.numPublicIpsTotal.get();
    }

    public void setNumPublicIpsTotal(Integer numPublicIpsTotal) {
        this.numPublicIpsTotal.set(numPublicIpsTotal);
    }

    public static String dump() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("Compute capacity:\n");
        builder.append("IP Addresses: ").append(globalModel.getNumPublicIpsAvailable()).append("/").append(globalModel.getNumPublicIpsTotal()).append("\n");
        builder.append("S3 Storage  : ").append(globalModel.getSizeS3ObjectAvailableGB()).append("/").append(globalModel.getSizeS3ObjectTotalGB()).append(" GiB\n");
        for (Map.Entry modelEntry : zoneModels.entrySet()) {
            builder.append((String)modelEntry.getKey()).append(":\n");
            builder.append("\t").append("Cores      : ").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getEc2ComputeUnitsAvailable()).append("/").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getEc2ComputeUnitsTotal()).append("\n");
            builder.append("\t").append("Disk       : ").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getEc2DiskUnitsAvailable()).append("/").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getEc2DiskUnitsTotal()).append(" GiB\n");
            builder.append("\t").append("Memory     : ").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getEc2MemoryUnitsAvailable()).append("/").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getEc2MemoryUnitsTotal()).append(" MiB\n");
            builder.append("\t").append("EBS Storage: ").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getSizeEbsAvailableGB()).append("/").append(((ReportingComputeZoneDomainModel)modelEntry.getValue()).getSizeEbsTotalGB()).append(" GiB\n");
        }
        return builder.toString();
    }

    public static final class ReportingComputeZoneDomainModel {
        private final AtomicReference<Integer> ec2ComputeUnitsAvailable = new AtomicReference();
        private final AtomicReference<Integer> ec2ComputeUnitsTotal = new AtomicReference();
        private final AtomicReference<Integer> ec2MemoryUnitsAvailable = new AtomicReference();
        private final AtomicReference<Integer> ec2MemoryUnitsTotal = new AtomicReference();
        private final AtomicReference<Integer> ec2DiskUnitsAvailable = new AtomicReference();
        private final AtomicReference<Integer> ec2DiskUnitsTotal = new AtomicReference();
        private final AtomicReference<Long> sizeEbsAvailableGB = new AtomicReference();
        private final AtomicReference<Long> sizeEbsTotalGB = new AtomicReference();
        private final Map<String, Integer> ec2VmTypeToAvailable = Maps.newConcurrentMap();
        private final Map<String, Integer> ec2VmTypeToTotal = Maps.newConcurrentMap();

        public Integer getEc2ComputeUnitsAvailable() {
            return this.ec2ComputeUnitsAvailable.get();
        }

        public void setEc2ComputeUnitsAvailable(Integer available) {
            this.ec2ComputeUnitsAvailable.set(available);
        }

        public Integer getEc2ComputeUnitsTotal() {
            return this.ec2ComputeUnitsTotal.get();
        }

        public void setEc2ComputeUnitsTotal(Integer ec2ComputeUnitsTotal) {
            this.ec2ComputeUnitsTotal.set(ec2ComputeUnitsTotal);
        }

        public Integer getEc2MemoryUnitsAvailable() {
            return this.ec2MemoryUnitsAvailable.get();
        }

        public void setEc2MemoryUnitsAvailable(Integer ec2MemoryUnitsAvailable) {
            this.ec2MemoryUnitsAvailable.set(ec2MemoryUnitsAvailable);
        }

        public Integer getEc2MemoryUnitsTotal() {
            return this.ec2MemoryUnitsTotal.get();
        }

        public void setEc2MemoryUnitsTotal(Integer ec2MemoryUnitsTotal) {
            this.ec2MemoryUnitsTotal.set(ec2MemoryUnitsTotal);
        }

        public Integer getEc2DiskUnitsAvailable() {
            return this.ec2DiskUnitsAvailable.get();
        }

        public void setEc2DiskUnitsAvailable(Integer ec2DiskUnitsAvailable) {
            this.ec2DiskUnitsAvailable.set(ec2DiskUnitsAvailable);
        }

        public Integer getEc2DiskUnitsTotal() {
            return this.ec2DiskUnitsTotal.get();
        }

        public void setEc2DiskUnitsTotal(Integer ec2DiskUnitsTotal) {
            this.ec2DiskUnitsTotal.set(ec2DiskUnitsTotal);
        }

        public Long getSizeEbsAvailableGB() {
            return this.sizeEbsAvailableGB.get();
        }

        public void setSizeEbsAvailableGB(Long sizeEbsAvailableGB) {
            this.sizeEbsAvailableGB.set(sizeEbsAvailableGB);
        }

        public Long getSizeEbsTotalGB() {
            return this.sizeEbsTotalGB.get();
        }

        public void setSizeEbsTotalGB(Long sizeEbsTotalGB) {
            this.sizeEbsTotalGB.set(sizeEbsTotalGB);
        }

        public Set<String> getVmTypes() {
            return Sets.newHashSet((Iterable)Iterables.concat(this.ec2VmTypeToAvailable.keySet(), this.ec2VmTypeToTotal.keySet()));
        }

        public Integer getInstancesAvailableForType(String vmType) {
            return this.ec2VmTypeToAvailable.get(vmType);
        }

        public void setInstancesAvailableForType(String vmType, Integer available) {
            this.ec2VmTypeToAvailable.put(vmType, available);
        }

        public Integer getInstancesTotalForType(String vmType) {
            return this.ec2VmTypeToTotal.get(vmType);
        }

        public void setInstancesTotalForType(String vmType, Integer total) {
            this.ec2VmTypeToTotal.put(vmType, total);
        }
    }
}

