/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.domain;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingAccountDao;
import org.apache.log4j.Logger;

public class ReportingAccountCrud {
    private static Logger LOG = Logger.getLogger(ReportingAccountCrud.class);
    private static ReportingAccountCrud instance = null;

    public static synchronized ReportingAccountCrud getInstance() {
        if (instance == null) {
            instance = new ReportingAccountCrud();
        }
        return instance;
    }

    protected ReportingAccountCrud() {
    }

    public void createOrUpdateAccount(String id, String name) {
        if (id == null || name == null) {
            throw new IllegalArgumentException("args cant be null");
        }
        LOG.debug((Object)("createOrUpdateAccount id:" + id + " name:" + name));
        if (id.matches("\\D+") || name.matches("\\d+")) {
            LOG.error((Object)("Funnny account, id:" + id + " name:" + name), (Throwable)new IllegalArgumentException());
        }
        ReportingAccount account = new ReportingAccount(id, name);
        ReportingAccount oldAccount = ReportingAccountDao.getInstance().getReportingAccount(account.getId());
        if (oldAccount != null && oldAccount.getName().equals(account.getName())) {
            return;
        }
        if (oldAccount != null) {
            this.updateInDb(account);
        } else {
            try {
                this.addToDb(account);
            }
            catch (RuntimeException e) {
                LOG.error((Object)e);
            }
        }
    }

    private void updateInDb(ReportingAccount account) {
        LOG.debug((Object)("Update reporting account in db, account:" + account));
        try (TransactionResource db = Entities.transactionFor(ReportingAccount.class);){
            ReportingAccount searchAccount = new ReportingAccount();
            searchAccount.setId(account.getId());
            ((ReportingAccount)Entities.uniqueResult((Object)searchAccount)).setName(account.getName());
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private void addToDb(ReportingAccount account) {
        LOG.debug((Object)("Add reporting account to db, account:" + account));
        try (TransactionResource db = Entities.transactionFor(ReportingAccount.class);){
            Entities.persist((Object)account);
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }
}

