/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class DurationCalculator<T> {
    private final Map<T, TreeSet<Long>> startTimesMs = new HashMap<T, TreeSet<Long>>();
    private final Map<T, TreeSet<Long>> endTimesMs = new HashMap<T, TreeSet<Long>>();
    private final long reportStartMs;
    private final long reportEndMs;

    public DurationCalculator(long reportStartMs, long reportEndMs) {
        this.reportStartMs = reportStartMs;
        this.reportEndMs = reportEndMs;
    }

    public void addStart(T key, long timestampMs) {
        if (!this.startTimesMs.containsKey(key)) {
            this.startTimesMs.put(key, new TreeSet());
        }
        if (!this.endTimesMs.containsKey(key)) {
            this.endTimesMs.put(key, new TreeSet());
        }
        this.startTimesMs.get(key).add(timestampMs);
    }

    public void addEnd(T key, long timestampMs) {
        if (!this.startTimesMs.containsKey(key)) {
            this.startTimesMs.put(key, new TreeSet());
        }
        if (!this.endTimesMs.containsKey(key)) {
            this.endTimesMs.put(key, new TreeSet());
        }
        this.endTimesMs.get(key).add(timestampMs);
    }

    public Map<T, Long> getDurationMap() {
        HashMap<T, Long> rv = new HashMap<T, Long>();
        for (T key : this.startTimesMs.keySet()) {
            for (Long startMs : this.startTimesMs.get(key)) {
                Long endMs = this.endTimesMs.get(key).higher(startMs);
                if (endMs == null) {
                    endMs = this.reportEndMs;
                }
                rv.put(key, DurationCalculator.boundDuration(this.reportStartMs, this.reportEndMs, startMs, endMs));
            }
        }
        return rv;
    }

    public static long boundDuration(long reportStart, long reportEnd, long periodStart, long periodEnd) {
        if (periodStart >= reportEnd) {
            return 0L;
        }
        if (periodEnd <= reportStart) {
            return 0L;
        }
        return Math.min(reportEnd, periodEnd) - Math.max(reportStart, periodStart);
    }

    public static long boundDuration(long reportStart, long reportEnd, long periodStart) {
        if (periodStart >= reportEnd) {
            return 0L;
        }
        return reportEnd - Math.max(reportStart, periodStart);
    }
}

