/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.util;

import com.eucalyptus.reporting.art.util.DurationCalculator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class AttachDurationCalculator<A, B> {
    private final Map<A, Map<B, TreeSet<Long>>> attachments = new HashMap<A, Map<B, TreeSet<Long>>>();
    private final long reportBeginMs;
    private final long reportEndMs;

    public AttachDurationCalculator(long reportBeginMs, long reportEndMs) {
        this.reportBeginMs = reportBeginMs;
        this.reportEndMs = reportEndMs;
    }

    public void detach(A resourceKey, B attachedKey, long timestampMs) {
        Map<B, TreeSet<Long>> innerMap;
        if (timestampMs >= this.reportEndMs) {
            return;
        }
        if (!this.attachments.containsKey(resourceKey)) {
            this.attachments.put(resourceKey, new HashMap());
        }
        if (!(innerMap = this.attachments.get(resourceKey)).containsKey(attachedKey)) {
            innerMap.put(attachedKey, new TreeSet());
        }
        innerMap.get(attachedKey).add(timestampMs);
    }

    public long attach(A resourceKey, B attachedResourceKey, long timestampMs) {
        TreeSet<Long> timestamps;
        Long detachTimestamp;
        Map<B, TreeSet<Long>> innerMap;
        if (timestampMs >= this.reportEndMs) {
            return 0L;
        }
        if (this.attachments.containsKey(resourceKey) && (innerMap = this.attachments.get(resourceKey)).containsKey(attachedResourceKey) && (detachTimestamp = (timestamps = innerMap.get(attachedResourceKey)).ceiling(timestampMs)) != null) {
            return DurationCalculator.boundDuration(this.reportBeginMs, this.reportEndMs, timestampMs, detachTimestamp);
        }
        return DurationCalculator.boundDuration(this.reportBeginMs, this.reportEndMs, timestampMs, this.reportEndMs);
    }
}

